/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.tiles.mechanism.generator.energy.fluid;

import com.denfop.IUItem;
import com.denfop.api.audio.EnumTypeAudio;
import com.denfop.api.audio.IAudioFixer;
import com.denfop.api.energy.EnergyNetGlobal;
import com.denfop.api.recipe.InvSlotOutput;
import com.denfop.api.tile.IMultiTileBlock;
import com.denfop.audio.EnumSound;
import com.denfop.blocks.BlockTileEntity;
import com.denfop.blocks.FluidName;
import com.denfop.blocks.mechanism.BlockBaseMachine2;
import com.denfop.componets.AdvEnergy;
import com.denfop.componets.Fluids;
import com.denfop.container.ContainerPetrolGenerator;
import com.denfop.gui.GuiPetrolGenerator;
import com.denfop.invslot.InvSlotCharge;
import com.denfop.invslot.InvSlotFluid;
import com.denfop.invslot.InvSlotFluidByList;
import com.denfop.network.DecoderHandler;
import com.denfop.network.EncoderHandler;
import com.denfop.network.IUpdatableTileEvent;
import com.denfop.network.packet.CustomPacketBuffer;
import com.denfop.network.packet.PacketStopSound;
import com.denfop.network.packet.PacketUpdateFieldTile;
import com.denfop.tiles.base.TileEntityLiquidTankInventory;
import java.io.IOException;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.mutable.MutableObject;

public class TilePetrolGenerator
extends TileEntityLiquidTankInventory
implements IAudioFixer,
IUpdatableTileEvent {
    public final InvSlotCharge chargeSlot = new InvSlotCharge(this, 1);
    public final InvSlotFluid fluidSlot;
    public final InvSlotOutput outputSlot;
    public final double coef;
    public final String name;
    public final AdvEnergy energy;
    public final int production = 60;
    public EnumTypeAudio typeAudio = EnumTypeAudio.OFF;
    public EnumTypeAudio[] valuesAudio = EnumTypeAudio.values();
    private boolean sound = true;

    public TilePetrolGenerator() {
        super(12);
        this.name = null;
        this.coef = 1.0;
        this.fluidSlot = new InvSlotFluidByList(this, 1, FluidName.fluidbenz.getInstance());
        this.outputSlot = new InvSlotOutput(this, 1);
        this.energy = this.addComponent(AdvEnergy.asBasicSource(this, 50000.0 * this.coef, EnergyNetGlobal.instance.getTierFromPower(this.production)).addManagedSlot(this.chargeSlot));
        ((Fluids.InternalFluidTank)this.getFluidTank()).setAcceptedFluids(Fluids.fluidPredicate(FluidName.fluidbenz.getInstance()));
    }

    @Override
    public IMultiTileBlock getTeBlock() {
        return BlockBaseMachine2.gen_pet;
    }

    @Override
    public BlockTileEntity getBlock() {
        return IUItem.basemachine1;
    }

    @Override
    public void readContainerPacket(CustomPacketBuffer customPacketBuffer) {
        super.readContainerPacket(customPacketBuffer);
        try {
            this.sound = (Boolean)DecoderHandler.decode(customPacketBuffer);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public CustomPacketBuffer writeContainerPacket() {
        CustomPacketBuffer packet = super.writeContainerPacket();
        try {
            EncoderHandler.encode(packet, this.sound);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return packet;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbttagcompound) {
        super.func_145839_a(nbttagcompound);
        this.sound = nbttagcompound.func_74767_n("sound");
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbttagcompound) {
        super.func_189515_b(nbttagcompound);
        nbttagcompound.func_74757_a("sound", this.sound);
        return nbttagcompound;
    }

    @Override
    public void updateTileServer(EntityPlayer entityPlayer, double i) {
        this.sound = !this.sound;
        new PacketUpdateFieldTile(this, "sound", this.sound);
        if (!this.sound && this.getType() == EnumTypeAudio.ON) {
            this.setType(EnumTypeAudio.OFF);
            this.initiate(2);
        }
    }

    @Override
    public void updateField(String name, CustomPacketBuffer is) {
        if (name.equals("sound")) {
            try {
                this.sound = (Boolean)DecoderHandler.decode(is);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        super.updateField(name, is);
    }

    @Override
    public EnumTypeAudio getType() {
        return this.typeAudio;
    }

    @Override
    public void setType(EnumTypeAudio type) {
        this.typeAudio = type;
    }

    @Override
    public boolean getEnable() {
        return this.sound;
    }

    @Override
    public void initiate(int soundEvent) {
        if (this.getType() == this.valuesAudio[soundEvent % this.valuesAudio.length]) {
            return;
        }
        this.setType(this.valuesAudio[soundEvent % this.valuesAudio.length]);
        if (!this.getEnable()) {
            return;
        }
        if (this.getSound() == null) {
            return;
        }
        if (soundEvent == 0) {
            this.func_145831_w().func_184133_a(null, this.field_174879_c, this.getSound(), SoundCategory.BLOCKS, 1.0f, 1.0f);
        } else if (soundEvent == 1) {
            new PacketStopSound(this.func_145831_w(), this.field_174879_c);
            this.func_145831_w().func_184133_a(null, this.field_174879_c, EnumSound.InterruptOne.getSoundEvent(), SoundCategory.BLOCKS, 1.0f, 1.0f);
        } else {
            new PacketStopSound(this.func_145831_w(), this.field_174879_c);
        }
    }

    @Override
    public SoundEvent getSound() {
        return EnumSound.petrol_generator.getSoundEvent();
    }

    @Override
    public void updateEntityServer() {
        MutableObject output;
        super.updateEntityServer();
        if (this.needsFluid() && this.fluidSlot.transferToTank((IFluidTank)this.fluidTank, (MutableObject<ItemStack>)(output = new MutableObject()), true) && (output.getValue() == null || this.outputSlot.canAdd((ItemStack)output.getValue()))) {
            this.fluidSlot.transferToTank((IFluidTank)this.fluidTank, (MutableObject<ItemStack>)output, false);
            if (output.getValue() != null) {
                this.outputSlot.add((ItemStack)output.getValue());
            }
        }
        boolean newActive = this.gainEnergy();
        if (this.getActive() != newActive) {
            this.setActive(newActive);
        }
        if (this.getActive() && this.func_145831_w().field_73011_w.getWorldTime() % 60L == 0L) {
            this.initiate(2);
        }
    }

    public boolean gainEnergy() {
        if (this.isConverting()) {
            this.energy.addEnergy((double)this.production * this.coef);
            this.getFluidTank().drain(2, true);
            this.initiate(0);
            return true;
        }
        this.initiate(2);
        return false;
    }

    public boolean isConverting() {
        return this.getTankAmount() > 0 && this.energy.getEnergy() + (double)this.production <= this.energy.getCapacity();
    }

    public ContainerPetrolGenerator getGuiContainer(EntityPlayer entityPlayer) {
        return new ContainerPetrolGenerator(entityPlayer, this);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiScreen getGui(EntityPlayer entityPlayer, boolean isAdmin) {
        return new GuiPetrolGenerator(new ContainerPetrolGenerator(entityPlayer, this));
    }
}

