/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.tiles.mechanism.generator.energy;

import com.denfop.IUItem;
import com.denfop.api.tile.IMultiTileBlock;
import com.denfop.blocks.BlockTileEntity;
import com.denfop.blocks.mechanism.BlockBaseMachine3;
import com.denfop.container.ContainerSolar;
import com.denfop.gui.GuiSolar;
import com.denfop.network.DecoderHandler;
import com.denfop.network.EncoderHandler;
import com.denfop.network.packet.CustomPacketBuffer;
import com.denfop.tiles.mechanism.generator.energy.TileEntityBaseGenerator;
import com.denfop.utils.ModUtils;
import java.io.IOException;
import net.minecraft.block.material.MapColor;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileEntitySolarGenerator
extends TileEntityBaseGenerator {
    public boolean rain;
    public boolean noSunWorld;
    public boolean wetBiome;
    public boolean skyIsVisible;
    public boolean sunIsUp;
    private Biome biome;

    public TileEntitySolarGenerator() {
        super(1.0, 1, 32);
    }

    public static double getSkyLight(World world, BlockPos pos) {
        if (world.field_73011_w.func_177495_o()) {
            return 0.0;
        }
        float sunBrightness = ModUtils.limit((float)Math.cos(world.func_72929_e(1.0f)) * 2.0f + 0.2f, 0.0f, 1.0f);
        if (!BiomeDictionary.hasType((Biome)world.func_180494_b(pos), (BiomeDictionary.Type)BiomeDictionary.Type.SANDY)) {
            sunBrightness *= 1.0f - world.func_72867_j(1.0f) * 5.0f / 16.0f;
            sunBrightness *= 1.0f - world.func_72819_i(1.0f) * 5.0f / 16.0f;
            sunBrightness = ModUtils.limit(sunBrightness, 0.0f, 1.0f);
        }
        return (float)world.func_175642_b(EnumSkyBlock.SKY, pos) / 15.0f * sunBrightness;
    }

    @Override
    public void readContainerPacket(CustomPacketBuffer customPacketBuffer) {
        super.readContainerPacket(customPacketBuffer);
        try {
            this.sunIsUp = (Boolean)DecoderHandler.decode(customPacketBuffer);
            this.skyIsVisible = (Boolean)DecoderHandler.decode(customPacketBuffer);
            this.rain = (Boolean)DecoderHandler.decode(customPacketBuffer);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public CustomPacketBuffer writeContainerPacket() {
        CustomPacketBuffer packet = super.writeContainerPacket();
        try {
            EncoderHandler.encode(packet, this.sunIsUp);
            EncoderHandler.encode(packet, this.skyIsVisible);
            EncoderHandler.encode(packet, this.rain);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return packet;
    }

    @Override
    public IMultiTileBlock getTeBlock() {
        return BlockBaseMachine3.solar_iu;
    }

    @Override
    public BlockTileEntity getBlock() {
        return IUItem.basemachine2;
    }

    @Override
    public void onLoaded() {
        super.onLoaded();
        this.biome = this.field_145850_b.func_180494_b(this.field_174879_c);
        this.noSunWorld = this.field_145850_b.field_73011_w.func_177495_o();
        this.updateSunVisibility();
    }

    @Override
    public boolean gainEnergy() {
        if (this.func_145831_w().field_73011_w.getWorldTime() % 40L == 0L) {
            this.updateSunVisibility();
        }
        if (this.sunIsUp && this.skyIsVisible && !this.rain) {
            this.energy.addEnergy(1.0);
            return true;
        }
        return false;
    }

    @Override
    public boolean gainFuel() {
        return false;
    }

    public void updateSunVisibility() {
        this.wetBiome = this.biome.func_76727_i() > 0.0f;
        this.rain = this.wetBiome && (this.field_145850_b.func_72896_J() || this.field_145850_b.func_72911_I());
        this.sunIsUp = this.field_145850_b.func_72935_r();
        this.skyIsVisible = this.field_145850_b.func_175710_j(this.field_174879_c.func_177984_a()) && this.field_145850_b.func_180495_p(this.field_174879_c.func_177984_a()).func_185904_a().func_151565_r() == MapColor.field_151660_b && !this.noSunWorld;
    }

    @Override
    public boolean needsFuel() {
        return false;
    }

    public ContainerSolar getGuiContainer(EntityPlayer player) {
        return new ContainerSolar(this, player);
    }

    @SideOnly(value=Side.CLIENT)
    public GuiSolar getGui(EntityPlayer player, boolean isAdmin) {
        return new GuiSolar(this.getGuiContainer(player));
    }

    @Override
    protected boolean delayActiveUpdate() {
        return true;
    }
}

