/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.tiles.mechanism;

import com.denfop.IUItem;
import com.denfop.Localization;
import com.denfop.api.tile.IMultiTileBlock;
import com.denfop.audio.EnumSound;
import com.denfop.blocks.BlockTileEntity;
import com.denfop.blocks.mechanism.BlockBaseMachine1;
import com.denfop.componets.AdvEnergy;
import com.denfop.container.ContainerMagnet;
import com.denfop.gui.GuiMagnet;
import com.denfop.network.DecoderHandler;
import com.denfop.network.EncoderHandler;
import com.denfop.network.packet.CustomPacketBuffer;
import com.denfop.tiles.base.TileElectricMachine;
import com.denfop.tiles.base.TileEntityAntiMagnet;
import java.io.IOException;
import java.util.List;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileMagnet
extends TileElectricMachine {
    public int energyconsume = 1000;
    public boolean work = true;
    public String player = "";

    public TileMagnet() {
        super(100000.0, 14, 24);
    }

    @Override
    public void readContainerPacket(CustomPacketBuffer customPacketBuffer) {
        super.readContainerPacket(customPacketBuffer);
        try {
            this.energyconsume = (Integer)DecoderHandler.decode(customPacketBuffer);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public CustomPacketBuffer writeContainerPacket() {
        CustomPacketBuffer packet = super.writeContainerPacket();
        try {
            EncoderHandler.encode(packet, this.energyconsume);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return packet;
    }

    @Override
    public SoundEvent getSound() {
        return EnumSound.magnet.getSoundEvent();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void addInformation(ItemStack stack, List<String> tooltip, ITooltipFlag advanced) {
        tooltip.add(Localization.translate("iu.magnet_work_info"));
        if (this.getComp(AdvEnergy.class) != null) {
            AdvEnergy energy = this.getComp(AdvEnergy.class);
            if (!energy.getSourceDirs().isEmpty()) {
                tooltip.add(Localization.translate("iu.item.tooltip.PowerTier", energy.getSourceTier()));
            } else if (!energy.getSinkDirs().isEmpty()) {
                tooltip.add(Localization.translate("iu.item.tooltip.PowerTier", energy.getSinkTier()));
            }
        }
    }

    @Override
    public IMultiTileBlock getTeBlock() {
        return BlockBaseMachine1.magnet;
    }

    @Override
    public BlockTileEntity getBlock() {
        return IUItem.basemachine;
    }

    @Override
    public void onPlaced(ItemStack stack, EntityLivingBase placer, EnumFacing facing) {
        super.onPlaced(stack, placer, facing);
        if (placer instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)placer;
            this.player = player.func_70005_c_();
            for (int x = this.field_174879_c.func_177958_n() - 10; x <= this.field_174879_c.func_177958_n() + 10; ++x) {
                for (int y = this.field_174879_c.func_177956_o() - 10; y <= this.field_174879_c.func_177956_o() + 10; ++y) {
                    for (int z = this.field_174879_c.func_177952_p() - 10; z <= this.field_174879_c.func_177952_p() + 10; ++z) {
                        TileEntity tileEntity = this.func_145831_w().func_175625_s(new BlockPos(x, y, z));
                        if (tileEntity == null || new BlockPos(x, y, z).equals((Object)this.field_174879_c) || !(tileEntity instanceof TileEntityAntiMagnet)) continue;
                        TileEntityAntiMagnet tile = (TileEntityAntiMagnet)tileEntity;
                        if (tile.player.equals(this.player)) continue;
                        this.work = false;
                    }
                }
            }
        }
    }

    @Override
    public void func_145839_a(NBTTagCompound nbttagcompound) {
        super.func_145839_a(nbttagcompound);
        this.player = nbttagcompound.func_74779_i("player");
        this.work = nbttagcompound.func_74767_n("work");
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbttagcompound) {
        super.func_189515_b(nbttagcompound);
        nbttagcompound.func_74778_a("player", this.player);
        nbttagcompound.func_74757_a("work", this.work);
        return nbttagcompound;
    }

    @Override
    public void updateEntityServer() {
        super.updateEntityServer();
        if (!this.work) {
            return;
        }
        boolean ret = false;
        if (this.field_145850_b.field_73011_w.getWorldTime() % 4L == 0L) {
            int radius = 10;
            AxisAlignedBB axisalignedbb = new AxisAlignedBB((double)(this.field_174879_c.func_177958_n() - radius), (double)(this.field_174879_c.func_177956_o() - radius), (double)(this.field_174879_c.func_177952_p() - radius), (double)(this.field_174879_c.func_177958_n() + radius), (double)(this.field_174879_c.func_177956_o() + radius), (double)(this.field_174879_c.func_177952_p() + radius));
            List list = this.func_145831_w().func_72872_a(EntityItem.class, axisalignedbb);
            if (this.func_145831_w().field_73011_w.getWorldTime() % 10L == 0L) {
                for (EntityItem item : list) {
                    ItemStack stack;
                    if (item.field_70128_L || !this.energy.canUseEnergy(this.energyconsume) || !this.outputSlot.canAdd(stack = item.func_92059_d())) continue;
                    item.func_70106_y();
                    this.initiate(0);
                    this.setActive(true);
                    this.energy.useEnergy(this.energyconsume);
                    this.outputSlot.add(stack);
                    ret = true;
                }
            }
        }
        if (this.func_145831_w().field_73011_w.getWorldTime() % 10L == 0L && !ret && this.getActive()) {
            this.setActive(false);
            this.initiate(2);
        }
    }

    @Override
    public int func_70302_i_() {
        return 24;
    }

    public double getEnergy() {
        return this.energy.getEnergy();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiScreen getGui(EntityPlayer entityPlayer, boolean isAdmin) {
        return new GuiMagnet(new ContainerMagnet(entityPlayer, this));
    }

    public ContainerMagnet getGuiContainer(EntityPlayer entityPlayer) {
        return new ContainerMagnet(entityPlayer, this);
    }
}

