/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.tiles.mechanism;

import com.denfop.IUCore;
import com.denfop.Localization;
import com.denfop.api.recipe.IUpdateTick;
import com.denfop.api.recipe.InvSlotRecipes;
import com.denfop.api.recipe.MachineRecipe;
import com.denfop.api.upgrades.IUpgradableBlock;
import com.denfop.api.upgrades.UpgradableProperty;
import com.denfop.container.ContainerGenStone;
import com.denfop.gui.GuiGenStone;
import com.denfop.invslot.InvSlotUpgrade;
import com.denfop.network.DecoderHandler;
import com.denfop.network.EncoderHandler;
import com.denfop.network.IUpdatableTileEvent;
import com.denfop.network.packet.CustomPacketBuffer;
import com.denfop.tiles.base.TileElectricMachine;
import java.io.IOException;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Keyboard;

public abstract class TileBaseGenStone
extends TileElectricMachine
implements IUpgradableBlock,
IUpdateTick,
IUpdatableTileEvent {
    public final double defaultEnergyConsume;
    public final int defaultOperationLength;
    public final int defaultTier;
    public final double defaultEnergyStorage;
    public final InvSlotUpgrade upgradeSlot;
    private final ItemStack sand;
    private final ItemStack gravel;
    public double energyConsume;
    public Mode mode;
    public int operationLength;
    public int operationsPerTick;
    public InvSlotRecipes inputSlotA;
    public MachineRecipe output;
    protected short progress = 0;
    protected double guiProgress;

    public TileBaseGenStone(int energyPerTick, int length, int outputSlots) {
        this(energyPerTick, length, outputSlots, 1);
    }

    public TileBaseGenStone(int energyPerTick, int length, int outputSlots, int aDefaultTier) {
        super((double)energyPerTick * (double)length, 1, outputSlots);
        this.defaultEnergyConsume = this.energyConsume = (double)energyPerTick;
        this.defaultOperationLength = this.operationLength = length;
        this.defaultTier = aDefaultTier;
        this.defaultEnergyStorage = energyPerTick * length;
        this.upgradeSlot = new InvSlotUpgrade(this, 4);
        this.output = null;
        this.mode = Mode.COBBLESTONE;
        this.sand = new ItemStack((Block)Blocks.field_150354_m, 8);
        this.gravel = new ItemStack(Blocks.field_150351_n, 8);
    }

    public static int applyModifier(int base, int extra, double multiplier) {
        double ret = Math.round((double)(base + extra) * multiplier);
        return ret > 2.147483647E9 ? Integer.MAX_VALUE : (int)ret;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbttagcompound) {
        super.func_145839_a(nbttagcompound);
        this.progress = nbttagcompound.func_74765_d("progress");
        this.mode = Mode.values()[nbttagcompound.func_74762_e("mode")];
    }

    @Override
    public void onUpdate() {
    }

    @Override
    public void readContainerPacket(CustomPacketBuffer customPacketBuffer) {
        super.readContainerPacket(customPacketBuffer);
        try {
            this.guiProgress = (Double)DecoderHandler.decode(customPacketBuffer);
            this.mode = Mode.values()[(Integer)DecoderHandler.decode(customPacketBuffer)];
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public CustomPacketBuffer writeContainerPacket() {
        CustomPacketBuffer packet = super.writeContainerPacket();
        try {
            EncoderHandler.encode(packet, this.guiProgress);
            EncoderHandler.encode(packet, (Object)this.mode);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return packet;
    }

    public Mode getMode() {
        return this.mode;
    }

    @Override
    public MachineRecipe getRecipeOutput() {
        return this.output;
    }

    @Override
    public void setRecipeOutput(MachineRecipe output) {
        this.output = output;
    }

    @SideOnly(value=Side.CLIENT)
    public GuiGenStone getGui(EntityPlayer entityPlayer, boolean isAdmin) {
        return new GuiGenStone(new ContainerGenStone(entityPlayer, this));
    }

    public String getStartSoundFile() {
        return "Machines/gen_cobblectone.ogg";
    }

    public String getInterruptSoundFile() {
        return "Machines/InterruptOne.ogg";
    }

    @Override
    public Set<UpgradableProperty> getUpgradableProperties() {
        return EnumSet.of(UpgradableProperty.Processing, UpgradableProperty.Transformer, UpgradableProperty.EnergyStorage, UpgradableProperty.ItemConsuming, UpgradableProperty.ItemProducing);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void addInformation(ItemStack stack, List<String> tooltip, ITooltipFlag advanced) {
        if (!Keyboard.isKeyDown((int)42)) {
            tooltip.add(Localization.translate("press.lshift"));
        }
        if (Keyboard.isKeyDown((int)42)) {
            tooltip.add(Localization.translate("iu.machines_work_energy") + this.defaultEnergyConsume + Localization.translate("iu.machines_work_energy_type_eu"));
            tooltip.add(Localization.translate("iu.machines_work_length") + this.defaultOperationLength);
        }
        super.addInformation(stack, tooltip, advanced);
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbttagcompound) {
        super.func_189515_b(nbttagcompound);
        nbttagcompound.func_74777_a("progress", this.progress);
        nbttagcompound.func_74768_a("mode", this.mode.ordinal());
        return nbttagcompound;
    }

    public double getProgress() {
        return this.guiProgress;
    }

    @Override
    public void onLoaded() {
        super.onLoaded();
        if (IUCore.proxy.isSimulating()) {
            this.setOverclockRates();
            this.inputSlotA.load();
            this.getOutput();
        }
    }

    @Override
    public void updateEntityServer() {
        super.updateEntityServer();
        MachineRecipe output = this.output;
        if (output != null && this.canAdd() && this.energy.getEnergy() >= this.energyConsume) {
            if (!this.getActive()) {
                this.setActive(true);
                if ((double)this.operationLength > (double)this.defaultOperationLength * 0.1) {
                    this.initiate(0);
                }
            }
            this.progress = (short)(this.progress + 1);
            this.energy.useEnergy(this.energyConsume);
            double k = this.progress;
            this.guiProgress = k / (double)this.operationLength;
            if (this.progress >= this.operationLength) {
                this.guiProgress = 0.0;
                this.operate(output);
                this.progress = 0;
                if ((double)this.operationLength > (double)this.defaultOperationLength * 0.1 || this.getType() != this.valuesAudio[2 % this.valuesAudio.length]) {
                    this.initiate(2);
                }
            }
        } else {
            if (output == null && this.getActive()) {
                this.progress = 0;
                if ((double)this.operationLength > (double)this.defaultOperationLength * 0.1 || this.getType() != this.valuesAudio[1 % this.valuesAudio.length]) {
                    this.initiate(1);
                }
            }
            if (this.getActive()) {
                this.setActive(false);
            }
        }
        if (this.upgradeSlot.tickNoMark()) {
            this.setOverclockRates();
        }
    }

    private boolean canAdd() {
        switch (this.getMode()) {
            default: {
                return this.outputSlot.canAdd(this.output.getRecipe().output.items);
            }
            case SAND: {
                return this.outputSlot.canAdd(this.sand);
            }
            case GRAVEL: 
        }
        return this.outputSlot.canAdd(this.gravel);
    }

    public void setOverclockRates() {
        this.operationsPerTick = this.upgradeSlot.getOperationsPerTick(this.defaultOperationLength);
        this.operationLength = this.upgradeSlot.getOperationLength(this.defaultOperationLength);
        this.energyConsume = this.upgradeSlot.getEnergyDemand(this.defaultEnergyConsume);
        int tier = this.upgradeSlot.getTier(this.defaultTier);
        this.energy.setSinkTier(tier);
        this.energy.setCapacity(this.upgradeSlot.getEnergyStorage(this.defaultEnergyStorage));
        this.operationsPerTick = Math.min(1, this.operationsPerTick);
        this.dischargeSlot.setTier(tier);
    }

    public void operate(MachineRecipe output) {
        List<ItemStack> processResult = output.getRecipe().output.items;
        this.operateOnce(output, processResult);
    }

    public void operateOnce(MachineRecipe output, List<ItemStack> processResult) {
        switch (this.getMode()) {
            default: {
                this.outputSlot.add(processResult);
                break;
            }
            case SAND: {
                this.outputSlot.add(this.sand);
                break;
            }
            case GRAVEL: {
                this.outputSlot.add(this.gravel);
            }
        }
    }

    public MachineRecipe getOutput() {
        this.output = this.inputSlotA.process();
        return this.output;
    }

    @Override
    public void updateTileServer(EntityPlayer entityPlayer, double i) {
        if (i == 10.0) {
            super.updateTileServer(entityPlayer, i);
        } else {
            this.mode = Mode.values()[(this.mode.ordinal() + 1) % Mode.values().length];
        }
    }

    public ContainerGenStone getGuiContainer(EntityPlayer entityPlayer) {
        return new ContainerGenStone(entityPlayer, this);
    }

    public void onGuiClosed(EntityPlayer entityPlayer) {
    }

    public static enum Mode {
        COBBLESTONE,
        GRAVEL,
        SAND;

    }
}

