/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.tiles.base;

import com.denfop.IUItem;
import com.denfop.api.Recipes;
import com.denfop.api.gui.IType;
import com.denfop.api.recipe.BaseMachineRecipe;
import com.denfop.api.recipe.IPatternStorage;
import com.denfop.api.recipe.RecipeInfo;
import com.denfop.container.ContainerScanner;
import com.denfop.gui.GuiScanner;
import com.denfop.invslot.InvSlot;
import com.denfop.invslot.InvSlotScannable;
import com.denfop.items.ItemCrystalMemory;
import com.denfop.network.DecoderHandler;
import com.denfop.network.EncoderHandler;
import com.denfop.network.IUpdatableTileEvent;
import com.denfop.network.packet.CustomPacketBuffer;
import com.denfop.tiles.base.TileElectricMachine;
import com.denfop.utils.ModUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class TileScanner
extends TileElectricMachine
implements IType,
IUpdatableTileEvent {
    public final int maxprogress;
    public final InvSlotScannable inputSlot;
    public final InvSlot diskSlot;
    public int progress = 0;
    public double patternUu;
    public double patternEu;
    public ItemStack pattern;
    public BaseMachineRecipe recipe;
    Map<BlockPos, IPatternStorage> iPatternStorageMap = new HashMap<BlockPos, IPatternStorage>();
    List<IPatternStorage> iPatternStorageList = new ArrayList<IPatternStorage>();
    private ItemStack currentStack = ModUtils.emptyStack;
    public State state;

    public TileScanner(int maxprogress) {
        super(512000.0, 14, 0);
        this.pattern = ModUtils.emptyStack;
        this.maxprogress = maxprogress;
        this.state = State.IDLE;
        this.inputSlot = new InvSlotScannable(this, 1);
        this.diskSlot = new InvSlot(this, InvSlot.TypeItemSlot.INPUT_OUTPUT, 1){

            @Override
            public boolean accepts(ItemStack stack, int index) {
                return stack.func_77973_b() == IUItem.crystalMemory;
            }
        };
    }

    @Override
    public SoundEvent getSound() {
        return null;
    }

    @Override
    public void onNeighborChange(Block neighbor, BlockPos neighborPos) {
        IPatternStorage storage;
        super.onNeighborChange(neighbor, neighborPos);
        TileEntity tile = this.func_145831_w().func_175625_s(neighborPos);
        if (tile instanceof IPatternStorage) {
            if (!this.iPatternStorageList.contains((IPatternStorage)tile)) {
                this.iPatternStorageList.add((IPatternStorage)tile);
                this.iPatternStorageMap.put(neighborPos, (IPatternStorage)tile);
            }
        } else if (tile == null && (storage = this.iPatternStorageMap.get(neighborPos)) != null) {
            this.iPatternStorageList.remove(storage);
            this.iPatternStorageMap.remove(neighborPos, storage);
        }
    }

    @Override
    public void readContainerPacket(CustomPacketBuffer customPacketBuffer) {
        super.readContainerPacket(customPacketBuffer);
        try {
            this.state = State.values()[(Integer)DecoderHandler.decode(customPacketBuffer)];
            this.progress = (Integer)DecoderHandler.decode(customPacketBuffer);
            this.patternEu = (Double)DecoderHandler.decode(customPacketBuffer);
            this.patternUu = (Double)DecoderHandler.decode(customPacketBuffer);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public CustomPacketBuffer writeContainerPacket() {
        CustomPacketBuffer packet = super.writeContainerPacket();
        try {
            EncoderHandler.encode(packet, (Object)this.state);
            EncoderHandler.encode(packet, this.progress);
            EncoderHandler.encode(packet, this.patternEu);
            EncoderHandler.encode(packet, this.patternUu);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return packet;
    }

    @Override
    public void updateEntityServer() {
        super.updateEntityServer();
        if (this.state != State.COMPLETED) {
            if (this.progress < this.maxprogress) {
                if (!this.inputSlot.isEmpty() && (ModUtils.isEmpty(this.currentStack) || ModUtils.checkItemEquality(this.currentStack, this.inputSlot.get()))) {
                    if (this.getPatternStorage() == null && this.diskSlot.isEmpty()) {
                        this.state = State.NO_STORAGE;
                        this.reset();
                    } else if (this.energy.getEnergy() >= 256.0) {
                        if (ModUtils.isEmpty(this.currentStack)) {
                            this.currentStack = ModUtils.setSize(this.inputSlot.get(), 1);
                        }
                        if (this.recipe == null) {
                            this.state = State.FAILED;
                        } else if (this.isPatternRecorded(this.pattern)) {
                            this.state = State.ALREADY_RECORDED;
                            this.reset();
                        } else {
                            this.state = State.SCANNING;
                            this.energy.useEnergy(256.0);
                            ++this.progress;
                            if (this.progress >= this.maxprogress) {
                                this.refreshInfo();
                                this.pattern = this.currentStack.func_77946_l();
                                this.state = State.COMPLETED;
                                this.inputSlot.get().func_190918_g(1);
                            }
                        }
                    } else {
                        this.state = State.NO_ENERGY;
                    }
                } else {
                    this.state = State.IDLE;
                    this.reset();
                }
            } else if (ModUtils.isEmpty(this.pattern)) {
                this.state = State.IDLE;
                this.progress = 0;
            }
        }
    }

    public void reset() {
        this.progress = 0;
        this.currentStack = ModUtils.emptyStack;
    }

    private boolean isPatternRecorded(ItemStack stack) {
        RecipeInfo stored;
        ItemStack crystalMemory;
        if (!this.diskSlot.isEmpty() && this.diskSlot.get().func_77973_b() instanceof ItemCrystalMemory && ModUtils.checkItemEquality(((ItemCrystalMemory)(crystalMemory = this.diskSlot.get()).func_77973_b()).readItemStack(crystalMemory), stack)) {
            return true;
        }
        IPatternStorage storage = this.getPatternStorage();
        if (storage == null) {
            return false;
        }
        Iterator<RecipeInfo> var3 = storage.getPatterns().iterator();
        do {
            if (var3.hasNext()) continue;
            return false;
        } while (!ModUtils.checkItemEquality((stored = var3.next()).getStack(), stack));
        return true;
    }

    private void record() {
        if (!ModUtils.isEmpty(this.pattern) && this.patternUu != Double.POSITIVE_INFINITY && !this.savetoDisk(this.pattern)) {
            IPatternStorage storage = this.getPatternStorage();
            if (storage == null) {
                this.state = State.TRANSFER_ERROR;
                return;
            }
            if (!storage.addPattern(new RecipeInfo(this.pattern, this.patternUu))) {
                this.state = State.TRANSFER_ERROR;
                return;
            }
        }
        this.reset();
    }

    @Override
    public void func_145839_a(NBTTagCompound nbttagcompound) {
        super.func_145839_a(nbttagcompound);
        this.progress = nbttagcompound.func_74762_e("progress");
        NBTTagCompound contentTag = nbttagcompound.func_74775_l("currentStack");
        this.currentStack = new ItemStack(contentTag);
        contentTag = nbttagcompound.func_74775_l("pattern");
        this.pattern = new ItemStack(contentTag);
        int stateIdx = nbttagcompound.func_74762_e("state");
        this.state = stateIdx < State.values().length ? State.values()[stateIdx] : State.IDLE;
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        NBTTagCompound contentTag;
        super.func_189515_b(nbt);
        nbt.func_74768_a("progress", this.progress);
        if (!ModUtils.isEmpty(this.currentStack)) {
            contentTag = new NBTTagCompound();
            this.currentStack.func_77955_b(contentTag);
            nbt.func_74782_a("currentStack", (NBTBase)contentTag);
        }
        if (!ModUtils.isEmpty(this.pattern)) {
            contentTag = new NBTTagCompound();
            this.pattern.func_77955_b(contentTag);
            nbt.func_74782_a("pattern", (NBTBase)contentTag);
        }
        nbt.func_74768_a("state", this.state.ordinal());
        return nbt;
    }

    public ContainerScanner getGuiContainer(EntityPlayer player) {
        return new ContainerScanner(player, this);
    }

    @SideOnly(value=Side.CLIENT)
    public GuiScanner getGui(EntityPlayer player, boolean isAdmin) {
        return new GuiScanner(new ContainerScanner(player, this));
    }

    public void onGuiClosed(EntityPlayer player) {
    }

    public IPatternStorage getPatternStorage() {
        if (this.iPatternStorageList.isEmpty()) {
            return null;
        }
        return this.iPatternStorageList.get(0);
    }

    public boolean savetoDisk(ItemStack stack) {
        if (!this.diskSlot.isEmpty() && stack != null) {
            if (this.diskSlot.get().func_77973_b() instanceof ItemCrystalMemory) {
                ItemStack crystalMemory = this.diskSlot.get();
                ((ItemCrystalMemory)crystalMemory.func_77973_b()).writecontentsTag(crystalMemory, stack);
                return true;
            }
            return false;
        }
        return false;
    }

    @Override
    public void updateTileServer(EntityPlayer player, double event) {
        switch ((int)event) {
            case 0: {
                this.reset();
                break;
            }
            case 1: {
                if (this.state != State.COMPLETED) break;
                this.record();
                this.state = State.IDLE;
            }
        }
    }

    @Override
    public void onLoaded() {
        super.onLoaded();
        if (this.inputSlot.isEmpty()) {
            this.recipe = this.pattern.func_190926_b() ? null : Recipes.recipes.getRecipeOutput("replicator", false, this.pattern);
        } else {
            this.recipe = Recipes.recipes.getRecipeOutput("replicator", false, this.inputSlot.get());
            this.pattern = this.inputSlot.get(0);
        }
        for (EnumFacing facing : EnumFacing.field_82609_l) {
            IPatternStorage storage;
            BlockPos neighborPos = this.field_174879_c.func_177972_a(facing);
            TileEntity tile = this.func_145831_w().func_175625_s(neighborPos);
            if (tile instanceof IPatternStorage) {
                if (this.iPatternStorageList.contains((IPatternStorage)tile)) continue;
                this.iPatternStorageList.add((IPatternStorage)tile);
                this.iPatternStorageMap.put(neighborPos, (IPatternStorage)tile);
                continue;
            }
            if (tile != null || (storage = this.iPatternStorageMap.get(neighborPos)) == null) continue;
            this.iPatternStorageList.remove(storage);
            this.iPatternStorageMap.remove(neighborPos, storage);
        }
        this.refreshInfo();
    }

    private void refreshInfo() {
        if (!ModUtils.isEmpty(this.pattern)) {
            this.patternUu = this.recipe.getOutput().metadata.func_74769_h("matter");
            this.patternEu = this.patternUu * 1.0E9;
        }
    }

    public int getPercentageDone() {
        return 100 * this.progress / this.maxprogress;
    }

    public int getSubPercentageDoneScaled(int width) {
        return width * (100 * this.progress % this.maxprogress) / this.maxprogress;
    }

    public boolean isDone() {
        return this.progress >= 3300;
    }

    public State getState() {
        return this.state;
    }

    public static enum State {
        IDLE,
        SCANNING,
        COMPLETED,
        FAILED,
        NO_STORAGE,
        NO_ENERGY,
        TRANSFER_ERROR,
        ALREADY_RECORDED;

    }
}

