/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.tiles.base;

import com.denfop.IUItem;
import com.denfop.Localization;
import com.denfop.api.gui.IType;
import com.denfop.api.tile.IMultiTileBlock;
import com.denfop.api.vein.IVein;
import com.denfop.api.vein.Type;
import com.denfop.api.vein.VeinSystem;
import com.denfop.audio.EnumSound;
import com.denfop.blocks.BlockTileEntity;
import com.denfop.blocks.mechanism.BlockQuarryVein;
import com.denfop.componets.EnumTypeStyle;
import com.denfop.container.ContainerQuarryVein;
import com.denfop.gui.GuiQuarryVein;
import com.denfop.items.ItemVeinSensor;
import com.denfop.items.upgradekit.ItemUpgradeMachinesKit;
import com.denfop.network.DecoderHandler;
import com.denfop.network.EncoderHandler;
import com.denfop.network.IUpdatableTileEvent;
import com.denfop.network.packet.CustomPacketBuffer;
import com.denfop.network.packet.PacketUpdateFieldTile;
import com.denfop.tiles.base.TileElectricMachine;
import com.denfop.utils.ModUtils;
import java.io.IOException;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Keyboard;

public class TileQuarryVein
extends TileElectricMachine
implements IUpdatableTileEvent,
IType {
    public int level = 1;
    public int time = 0;
    public int progress = 0;
    public IVein vein;
    public boolean start = true;
    private int count = 0;

    public TileQuarryVein() {
        super(400.0, 14, 1);
    }

    @Override
    public IMultiTileBlock getTeBlock() {
        return BlockQuarryVein.quarry_vein;
    }

    @Override
    public BlockTileEntity getBlock() {
        return IUItem.oilquarry;
    }

    @Override
    public ItemStack getPickBlock(EntityPlayer player, RayTraceResult target) {
        ItemStack stack = new ItemStack((Block)IUItem.oilquarry);
        NBTTagCompound nbt = ModUtils.nbt(stack);
        nbt.func_74768_a("level", this.level);
        return stack;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean shouldSideBeRendered(EnumFacing side, BlockPos otherPos) {
        return false;
    }

    @Override
    public boolean isNormalCube() {
        return false;
    }

    @Override
    public boolean doesSideBlockRendering(EnumFacing side) {
        return false;
    }

    public String getStartSoundFile() {
        return "Machines/rig.ogg";
    }

    @Override
    public boolean isSideSolid(EnumFacing side) {
        return false;
    }

    @Override
    public boolean clientNeedsExtraModelInfo() {
        return true;
    }

    public boolean shouldRenderInPass(int pass) {
        return true;
    }

    @Override
    public boolean onActivated(EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (!player.func_184586_b(hand).func_190926_b()) {
            if (player.func_184586_b(hand).func_77973_b() instanceof ItemUpgradeMachinesKit) {
                if (this.level < 4 && this.level == player.func_184586_b(hand).func_77952_i() + 1) {
                    ++this.level;
                    player.func_184586_b(hand).func_190920_e(player.func_184586_b(hand).func_190916_E() - 1);
                    this.updateTileEntityField();
                    return true;
                }
                if (this.level < 4 && player.func_184586_b(hand).func_77952_i() == 3) {
                    this.level = 4;
                    player.func_184586_b(hand).func_190920_e(player.func_184586_b(hand).func_190916_E() - 1);
                    this.updateTileEntityField();
                    return true;
                }
            } else if (player.func_184586_b(hand).func_77973_b() instanceof ItemVeinSensor && this.vein != VeinSystem.system.getEMPTY() && this.vein.get() && this.vein.getType() != Type.EMPTY) {
                NBTTagCompound nbt = ModUtils.nbt(player.func_184586_b(hand));
                if (this.vein.getType() == Type.VEIN) {
                    String s = this.getType(this.vein.getMeta());
                    nbt.func_74778_a("type", s);
                } else {
                    String s = "oil";
                    nbt.func_74778_a("type", s);
                }
                nbt.func_74768_a("x", this.field_174879_c.func_177958_n());
                nbt.func_74768_a("z", this.field_174879_c.func_177952_p());
                return true;
            }
        }
        return super.onActivated(player, hand, side, hitX, hitY, hitZ);
    }

    private String getType(int meta) {
        String[] s = new String[]{"magnetite", "calaverite", "galena", "nickelite", "pyrite", "quartzite", "uranite", "azurite", "rhodonite", "alfildit", "euxenite", "smithsonite", "ilmenite", "todorokite", "ferroaugite", "sheelite"};
        return s[meta % s.length];
    }

    @Override
    public void onPlaced(ItemStack stack, EntityLivingBase placer, EnumFacing facing) {
        super.onPlaced(stack, placer, facing);
        NBTTagCompound nbt = ModUtils.nbt(stack);
        int n = this.level = nbt.func_74762_e("level") != 0 ? nbt.func_74762_e("level") : 1;
        if (this.func_145831_w().field_73011_w.getDimension() != 0) {
            this.vein = VeinSystem.system.getEMPTY();
        } else {
            if (this.field_145850_b.field_72995_K) {
                return;
            }
            Chunk chunk = this.func_145831_w().func_175726_f(this.field_174879_c);
            ChunkPos chunkpos = chunk.func_76632_l();
            if (!VeinSystem.system.getChunkPos().contains(chunkpos)) {
                VeinSystem.system.addVein(chunk);
            }
            this.vein = VeinSystem.system.getVein(chunkpos);
            if (this.vein.get()) {
                this.progress = 1200;
            }
            new PacketUpdateFieldTile(this, "vein", this.vein);
        }
    }

    @Override
    public CustomPacketBuffer writePacket() {
        CustomPacketBuffer packet = super.writePacket();
        try {
            EncoderHandler.encode(packet, this.level);
            EncoderHandler.encode(packet, this.vein);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return packet;
    }

    @Override
    public void readPacket(CustomPacketBuffer customPacketBuffer) {
        super.readPacket(customPacketBuffer);
        try {
            this.level = (Integer)DecoderHandler.decode(customPacketBuffer);
            this.vein = (IVein)DecoderHandler.decode(customPacketBuffer);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void readContainerPacket(CustomPacketBuffer customPacketBuffer) {
        super.readContainerPacket(customPacketBuffer);
        try {
            this.progress = (Integer)DecoderHandler.decode(customPacketBuffer);
            this.level = (Integer)DecoderHandler.decode(customPacketBuffer);
            this.vein = (IVein)DecoderHandler.decode(customPacketBuffer);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public CustomPacketBuffer writeContainerPacket() {
        CustomPacketBuffer packet = super.writeContainerPacket();
        try {
            EncoderHandler.encode(packet, this.progress);
            EncoderHandler.encode(packet, this.level);
            EncoderHandler.encode(packet, this.vein);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return packet;
    }

    @Override
    public void onLoaded() {
        super.onLoaded();
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (this.func_145831_w().field_73011_w.getDimension() != 0) {
            this.vein = VeinSystem.system.getEMPTY();
        } else {
            Chunk chunk = this.func_145831_w().func_175726_f(this.field_174879_c);
            ChunkPos chunkpos = chunk.func_76632_l();
            if (!VeinSystem.system.getChunkPos().contains(chunkpos)) {
                VeinSystem.system.addVein(chunk);
            }
            this.vein = VeinSystem.system.getVein(chunkpos);
            if (this.vein.get()) {
                this.progress = 1200;
            }
            if (this.progress >= 1200) {
                this.vein.setFind(true);
            }
        }
        this.updateTileEntityField();
    }

    private void updateTileEntityField() {
        new PacketUpdateFieldTile(this, "level", this.level);
        new PacketUpdateFieldTile(this, "vein", this.vein);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void addInformation(ItemStack stack, List<String> tooltip, ITooltipFlag advanced) {
        if (!Keyboard.isKeyDown((int)42)) {
            tooltip.add(Localization.translate("press.lshift"));
        }
        if (Keyboard.isKeyDown((int)42)) {
            tooltip.add(Localization.translate("iu.machines_work_energy") + 5 + Localization.translate("iu.machines_work_energy_type_eu"));
        }
        super.addInformation(stack, tooltip, advanced);
    }

    @Override
    public void updateField(String name, CustomPacketBuffer is) {
        if (name.equals("count")) {
            try {
                this.count = (Integer)DecoderHandler.decode(is);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        if (name.equals("vein")) {
            try {
                this.vein = (IVein)DecoderHandler.decode(is);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        if (name.equals("level")) {
            try {
                this.level = (Integer)DecoderHandler.decode(is);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        super.updateField(name, is);
    }

    @Override
    public void updateEntityServer() {
        super.updateEntityServer();
        if (this.vein == null) {
            return;
        }
        if (this.vein.getCol() != this.count) {
            this.count = this.vein.getCol();
            if (this.func_145831_w().field_73011_w.getWorldTime() % 4L == 0L) {
                new PacketUpdateFieldTile(this, "count", this.count);
            }
        }
        if (this.vein.get()) {
            return;
        }
        if (this.progress < 1200 && this.energy.getEnergy() >= 5.0 && !this.vein.get()) {
            if (this.progress == 0) {
                this.initiate(2);
                this.time = 0;
                this.initiate(0);
            }
            if (this.time > 340) {
                this.initiate(2);
                this.time = 0;
            }
            if (this.time == 0) {
                this.initiate(0);
            }
            ++this.time;
            this.progress = (int)((double)this.progress + Math.pow(2.0, this.level - 1));
            this.energy.useEnergy(5.0);
            if (this.progress >= 1200) {
                this.initiate(2);
                this.progress = 1200;
                this.vein.setFind(true);
                this.updateTileEntityField();
            }
        } else if (this.time > 0) {
            this.initiate(2);
            this.time = 0;
        }
    }

    @Override
    public void func_145839_a(NBTTagCompound nbttagcompound) {
        super.func_145839_a(nbttagcompound);
        this.progress = nbttagcompound.func_74762_e("progress");
        this.level = nbttagcompound.func_74762_e("level");
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbttagcompound) {
        super.func_189515_b(nbttagcompound);
        nbttagcompound.func_74768_a("progress", this.progress);
        nbttagcompound.func_74768_a("level", this.level);
        return nbttagcompound;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiScreen getGui(EntityPlayer entityPlayer, boolean isAdmin) {
        return new GuiQuarryVein(this.getGuiContainer(entityPlayer));
    }

    public ContainerQuarryVein getGuiContainer(EntityPlayer entityPlayer) {
        return new ContainerQuarryVein(entityPlayer, this);
    }

    @Override
    public void updateTileServer(EntityPlayer player, double event) {
    }

    public void onGuiClosed(EntityPlayer arg0) {
    }

    @Override
    public EnumTypeStyle getStyle() {
        switch (this.level) {
            case 2: {
                return EnumTypeStyle.ADVANCED;
            }
            case 3: {
                return EnumTypeStyle.IMPROVED;
            }
            case 4: {
                return EnumTypeStyle.PERFECT;
            }
        }
        return EnumTypeStyle.DEFAULT;
    }

    @Override
    public SoundEvent getSound() {
        return EnumSound.quarry.getSoundEvent();
    }
}

