/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.tiles.base;

import com.denfop.Config;
import com.denfop.IUCore;
import com.denfop.IUItem;
import com.denfop.api.Recipes;
import com.denfop.api.energy.EnergyNetGlobal;
import com.denfop.api.recipe.BaseMachineRecipe;
import com.denfop.api.recipe.IHasRecipe;
import com.denfop.api.recipe.IUpdateTick;
import com.denfop.api.recipe.Input;
import com.denfop.api.recipe.InvSlotRecipes;
import com.denfop.api.recipe.MachineRecipe;
import com.denfop.api.recipe.RecipeOutput;
import com.denfop.api.tile.IMultiTileBlock;
import com.denfop.audio.EnumSound;
import com.denfop.blocks.BlockTileEntity;
import com.denfop.blocks.mechanism.BlockMolecular;
import com.denfop.componets.AdvEnergy;
import com.denfop.container.ContainerBaseMolecular;
import com.denfop.gui.GuiMolecularTransformer;
import com.denfop.items.resource.ItemNuclearResource;
import com.denfop.network.DecoderHandler;
import com.denfop.network.EncoderHandler;
import com.denfop.network.IUpdatableTileEvent;
import com.denfop.network.packet.CustomPacketBuffer;
import com.denfop.network.packet.PacketUpdateFieldTile;
import com.denfop.recipe.IInputHandler;
import com.denfop.tiles.base.IIsMolecular;
import com.denfop.tiles.base.TileElectricMachine;
import com.denfop.tiles.base.TileEntityBlock;
import com.denfop.tiles.base.TileEntityInventory;
import com.denfop.utils.ModUtils;
import java.io.IOException;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemEnchantedBook;
import net.minecraft.item.ItemPotion;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileMolecularTransformer
extends TileElectricMachine
implements IUpdatableTileEvent,
IUpdateTick,
IHasRecipe,
IIsMolecular {
    public boolean queue = false;
    public byte redstoneMode = 0;
    public int operationLength;
    public int operationsPerTick;
    public InvSlotRecipes inputSlot;
    public MachineRecipe output;
    public double perenergy;
    public double differenceenergy;
    public double size;
    protected double progress = 0.0;
    protected double guiProgress;
    protected double size_recipe = 0.0;
    protected ItemStack output_stack = new ItemStack(Items.field_190931_a);
    private boolean need = false;

    public TileMolecularTransformer() {
        super(0.0, 14, 1);
        this.energy = this.addComponent(AdvEnergy.asBasicSink((TileEntityInventory)this, 0.0, 14).addManagedSlot(this.dischargeSlot));
        this.inputSlot = new InvSlotRecipes((TileEntityInventory)this, "molecular", (IUpdateTick)this);
        this.output = null;
        Recipes.recipes.addInitRecipes(this);
    }

    public static void addrecipe(ItemStack stack, ItemStack stack1, double energy) {
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74780_a("energy", energy);
        IInputHandler input = Recipes.inputFactory;
        Recipes.recipes.addRecipe("molecular", new BaseMachineRecipe(new Input(input.getInput(stack)), new RecipeOutput(nbt, stack1)));
    }

    public static void addrecipe(String stack, ItemStack stack1, double energy) {
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74780_a("energy", energy);
        IInputHandler input = Recipes.inputFactory;
        Recipes.recipes.addRecipe("molecular", new BaseMachineRecipe(new Input(input.getInput(stack)), new RecipeOutput(nbt, stack1)));
    }

    @Override
    public IMultiTileBlock getTeBlock() {
        return BlockMolecular.molecular;
    }

    @Override
    public BlockTileEntity getBlock() {
        return IUItem.blockmolecular;
    }

    public ItemStack getOutput_stack() {
        return this.output_stack;
    }

    @Override
    public void init() {
        TileMolecularTransformer.addrecipe(new ItemStack(Items.field_151144_bL, 1, 1), new ItemStack(Items.field_151156_bN, 1), Config.molecular1);
        TileMolecularTransformer.addrecipe(IUItem.nuclear_res.getItemStack(ItemNuclearResource.Types.plutonium), new ItemStack(IUItem.proton, 1), Config.molecular3);
        TileMolecularTransformer.addrecipe("ingotSpinel", new ItemStack(IUItem.iuingot, 1, 5), 2500000.0);
        TileMolecularTransformer.addrecipe(new ItemStack(IUItem.photoniy), new ItemStack(IUItem.photoniy_ingot), Config.molecular5);
        TileMolecularTransformer.addrecipe(new ItemStack(Blocks.field_150424_aL), new ItemStack(Items.field_151016_H, 2), Config.molecular6);
        TileMolecularTransformer.addrecipe(new ItemStack((Block)Blocks.field_150354_m), new ItemStack(Blocks.field_150351_n, 1), Config.molecular7);
        TileMolecularTransformer.addrecipe("ingotIridium", new ItemStack(IUItem.core, 1, 0), Config.molecular17);
        TileMolecularTransformer.addrecipe(new ItemStack(IUItem.core, 4, 0), new ItemStack(IUItem.core, 1, 1), Config.molecular18);
        TileMolecularTransformer.addrecipe(new ItemStack(IUItem.core, 4, 1), new ItemStack(IUItem.core, 1, 2), Config.molecular19);
        TileMolecularTransformer.addrecipe(new ItemStack(IUItem.core, 4, 2), new ItemStack(IUItem.core, 1, 3), Config.molecular20);
        TileMolecularTransformer.addrecipe(new ItemStack(IUItem.core, 4, 3), new ItemStack(IUItem.core, 1, 4), Config.molecular21);
        TileMolecularTransformer.addrecipe(new ItemStack(IUItem.core, 4, 4), new ItemStack(IUItem.core, 1, 5), Config.molecular22);
        TileMolecularTransformer.addrecipe(new ItemStack(IUItem.core, 4, 5), new ItemStack(IUItem.core, 1, 6), Config.molecular23);
        TileMolecularTransformer.addrecipe(new ItemStack(IUItem.core, 4, 6), new ItemStack(IUItem.core, 1, 7), Config.molecular24);
        TileMolecularTransformer.addrecipe(new ItemStack(IUItem.core, 4, 7), new ItemStack(IUItem.core, 1, 8), Config.molecular25);
        TileMolecularTransformer.addrecipe(new ItemStack(IUItem.core, 4, 8), new ItemStack(IUItem.core, 1, 9), Config.molecular26);
        TileMolecularTransformer.addrecipe(new ItemStack(IUItem.core, 4, 9), new ItemStack(IUItem.core, 1, 10), Config.molecular38);
        TileMolecularTransformer.addrecipe(new ItemStack(IUItem.core, 4, 10), new ItemStack(IUItem.core, 1, 11), Config.molecular39);
        TileMolecularTransformer.addrecipe(new ItemStack(IUItem.core, 4, 11), new ItemStack(IUItem.core, 1, 12), Config.molecular40);
        TileMolecularTransformer.addrecipe(new ItemStack(IUItem.core, 4, 12), new ItemStack(IUItem.core, 1, 13), Config.molecular41);
        TileMolecularTransformer.addrecipe(new ItemStack(IUItem.matter, 1, 1), new ItemStack(IUItem.lens, 1, 5), Config.molecular27);
        TileMolecularTransformer.addrecipe(new ItemStack(IUItem.matter, 1, 2), new ItemStack(IUItem.lens, 1, 6), Config.molecular28);
        TileMolecularTransformer.addrecipe(new ItemStack(IUItem.matter, 1, 3), new ItemStack(IUItem.lens, 1, 2), Config.molecular29);
        TileMolecularTransformer.addrecipe(new ItemStack(IUItem.matter, 1, 4), new ItemStack(IUItem.lens, 1, 4), Config.molecular30);
        TileMolecularTransformer.addrecipe(new ItemStack(IUItem.matter, 1, 5), new ItemStack(IUItem.lens, 1, 1), Config.molecular31);
        TileMolecularTransformer.addrecipe(new ItemStack(IUItem.matter, 1, 6), new ItemStack(IUItem.lens, 1, 3), Config.molecular32);
        TileMolecularTransformer.addrecipe(new ItemStack(IUItem.matter, 1, 7), new ItemStack(IUItem.lens, 1), Config.molecular33);
        TileMolecularTransformer.addrecipe(new ItemStack(Items.field_151042_j, 1, 0), IUItem.iridiumOre, 7500000.0);
        TileMolecularTransformer.addrecipe(IUItem.iridiumOre, new ItemStack(IUItem.photoniy), Config.molecular34);
    }

    public List<Double> getTime(double energy) {
        double dif = this.differenceenergy;
        return ModUtils.Time((energy - this.energy.getEnergy()) / (dif * 20.0));
    }

    public double getInput() {
        return EnergyNetGlobal.instance.getNodeStats(this.energy.getDelegate()).getEnergyIn();
    }

    public ContainerBaseMolecular getGuiContainer(EntityPlayer entityPlayer) {
        return new ContainerBaseMolecular(entityPlayer, this);
    }

    @Override
    public boolean doesSideBlockRendering(EnumFacing side) {
        return false;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean shouldSideBeRendered(EnumFacing side, BlockPos otherPos) {
        return false;
    }

    @Override
    public boolean isNormalCube() {
        return false;
    }

    @Override
    public void readContainerPacket(CustomPacketBuffer customPacketBuffer) {
        super.readContainerPacket(customPacketBuffer);
        try {
            this.guiProgress = (Double)DecoderHandler.decode(customPacketBuffer);
            this.queue = (Boolean)DecoderHandler.decode(customPacketBuffer);
            this.redstoneMode = (Byte)DecoderHandler.decode(customPacketBuffer);
            this.differenceenergy = (Double)DecoderHandler.decode(customPacketBuffer);
            this.perenergy = (Double)DecoderHandler.decode(customPacketBuffer);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public CustomPacketBuffer writeContainerPacket() {
        CustomPacketBuffer packet = super.writeContainerPacket();
        try {
            EncoderHandler.encode(packet, this.guiProgress);
            EncoderHandler.encode(packet, this.queue);
            EncoderHandler.encode(packet, this.redstoneMode);
            EncoderHandler.encode(packet, this.differenceenergy);
            EncoderHandler.encode(packet, this.perenergy);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return packet;
    }

    @Override
    public boolean onActivated(EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        return super.onActivated(player, hand, side, hitX, hitY, hitZ);
    }

    @Override
    public CustomPacketBuffer writePacket() {
        CustomPacketBuffer packet = super.writePacket();
        try {
            EncoderHandler.encode(packet, this.guiProgress);
            EncoderHandler.encode(packet, this.queue);
            EncoderHandler.encode(packet, this.redstoneMode);
            EncoderHandler.encode(packet, this.energy, false);
            EncoderHandler.encode(packet, this.output_stack);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return packet;
    }

    @Override
    public void readPacket(CustomPacketBuffer customPacketBuffer) {
        super.readPacket(customPacketBuffer);
        try {
            this.guiProgress = (Double)DecoderHandler.decode(customPacketBuffer);
            this.queue = (Boolean)DecoderHandler.decode(customPacketBuffer);
            this.redstoneMode = (Byte)DecoderHandler.decode(customPacketBuffer);
            this.energy.onNetworkUpdate(customPacketBuffer);
            this.output_stack = (ItemStack)DecoderHandler.decode(customPacketBuffer);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean shouldRenderInPass(int pass) {
        return true;
    }

    public String getInventoryName() {
        return "Molecular Transformer";
    }

    @Override
    public void func_145839_a(NBTTagCompound nbttagcompound) {
        super.func_145839_a(nbttagcompound);
        this.queue = nbttagcompound.func_74767_n("queue");
        this.redstoneMode = nbttagcompound.func_74771_c("redstoneMode");
        this.progress = nbttagcompound.func_74769_h("progress");
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbttagcompound) {
        super.func_189515_b(nbttagcompound);
        nbttagcompound.func_74774_a("redstoneMode", this.redstoneMode);
        nbttagcompound.func_74757_a("queue", this.queue);
        nbttagcompound.func_74780_a("progress", this.progress);
        return nbttagcompound;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiScreen getGui(EntityPlayer entityPlayer, boolean isAdmin) {
        return new GuiMolecularTransformer(new ContainerBaseMolecular(entityPlayer, this));
    }

    @Override
    public void updateTileServer(EntityPlayer player, double event) {
        if (this.func_145831_w().field_72995_K) {
            return;
        }
        if (event == 0.0) {
            this.redstoneMode = (byte)(this.redstoneMode + 1);
            if (this.redstoneMode >= 8) {
                this.redstoneMode = 0;
            }
            new PacketUpdateFieldTile(this, "redstoneMode", this.redstoneMode);
        }
        if (event == 1.0) {
            boolean bl = this.queue = !this.queue;
            if (this.need) {
                this.queue = false;
            }
            this.setOverclockRates();
        }
    }

    @Override
    public void func_70296_d() {
        super.func_70296_d();
        if (IUCore.proxy.isSimulating()) {
            this.setOverclockRates();
        }
    }

    public void operate(MachineRecipe output) {
        List<ItemStack> processResult = output.getRecipe().output.items;
        this.operateOnce(processResult);
    }

    public void operate(MachineRecipe output, int size) {
        List<ItemStack> processResult = output.getRecipe().output.items;
        this.operateOnce(processResult, size);
    }

    public void operateOnce(List<ItemStack> processResult) {
        this.inputSlot.consume();
        this.outputSlot.add(processResult);
        if (!this.inputSlot.continue_process(this.output) || !this.outputSlot.canAdd(this.output.getRecipe().output.items)) {
            this.getOutput();
        }
    }

    public void operateOnce(List<ItemStack> processResult, int size) {
        for (int i = 0; i < size; ++i) {
            this.inputSlot.consume();
            this.outputSlot.add(processResult);
        }
        if (!this.inputSlot.continue_process(this.output) || !this.outputSlot.canAdd(this.output.getRecipe().output.items)) {
            this.getOutput();
        }
    }

    @Override
    public int getMode() {
        return this.redstoneMode;
    }

    @Override
    public ItemStack getItemStack() {
        return this.output_stack;
    }

    @Override
    public TileEntityBlock getEntityBlock() {
        return this;
    }

    @Override
    public void onLoaded() {
        super.onLoaded();
        if (IUCore.proxy.isSimulating()) {
            this.inputSlot.load();
            this.setOverclockRates();
            new PacketUpdateFieldTile(this, "redstoneMode", this.redstoneMode);
        }
    }

    @Override
    public void updateField(String name, CustomPacketBuffer is) {
        if (name.equals("redstoneMode")) {
            try {
                this.redstoneMode = (Byte)DecoderHandler.decode(is);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        super.updateField(name, is);
    }

    public void setOverclockRates() {
        MachineRecipe output;
        MachineRecipe machineRecipe = output = this.getRecipeOutput() == null ? this.getOutput() : this.getRecipeOutput();
        if (!this.queue) {
            if (this.inputSlot.isEmpty() || !this.inputSlot.continue_proccess(this.outputSlot)) {
                this.energy.setCapacity(0.0);
            } else if (output != null) {
                this.energy.setCapacity(output.getRecipe().output.metadata.func_74769_h("energy"));
            } else {
                this.energy.setCapacity(0.0);
            }
        } else if (this.inputSlot.isEmpty() || !this.inputSlot.continue_proccess(this.outputSlot)) {
            this.energy.setCapacity(0.0);
        } else if (output != null) {
            ItemStack output1 = this.output.getRecipe().output.items.get(0);
            int size = this.output.getRecipe().input.getInputs().get(0).getInputs().get(0).func_190916_E();
            size = (int)Math.floor((float)this.inputSlot.get().func_190916_E() / (float)size);
            int size1 = !this.outputSlot.isEmpty() ? (64 - this.outputSlot.get().func_190916_E()) / output1.func_190916_E() : 64 / output1.func_190916_E();
            size = Math.min(size1, size);
            size = Math.min(size, output1.func_77976_d());
            this.size_recipe = size;
            this.energy.setCapacity(output.getRecipe().output.metadata.func_74769_h("energy") * (double)size);
        } else {
            this.energy.setCapacity(0.0);
        }
    }

    @Override
    public void updateEntityServer() {
        super.updateEntityServer();
        MachineRecipe output = this.getRecipeOutput();
        if (!this.queue) {
            if (output != null && this.outputSlot.canAdd(output.getRecipe().output.items)) {
                this.differenceenergy = this.energy.getEnergy() - this.perenergy;
                this.perenergy = this.energy.getEnergy();
                if (!this.getActive()) {
                    if (this.field_145850_b.field_73011_w.getWorldTime() % 2L == 0L) {
                        this.initiate(0);
                    }
                    this.setActive(true);
                    this.setOverclockRates();
                }
                try {
                    this.guiProgress = this.energy.getEnergy() / this.energy.getCapacity();
                }
                catch (Exception e) {
                    this.guiProgress = 0.0;
                }
                if (this.guiProgress >= 1.0) {
                    this.operate(output);
                    this.progress = 0.0;
                    this.energy.useEnergy(this.energy.getEnergy());
                    if (this.field_145850_b.field_73011_w.getWorldTime() % 2L == 0L) {
                        this.initiate(2);
                    }
                }
            } else {
                if (this.energy.getEnergy() != 0.0 && this.getActive() && this.field_145850_b.field_73011_w.getWorldTime() % 2L == 0L) {
                    this.initiate(1);
                }
                this.energy.useEnergy(this.energy.getEnergy());
                this.energy.setCapacity(0.0);
                this.setActive(false);
            }
        } else if (output != null && this.inputSlot.continue_proccess(this.outputSlot)) {
            this.differenceenergy = this.energy.getEnergy() - this.perenergy;
            this.perenergy = this.energy.getEnergy();
            if (!this.getActive()) {
                if (this.field_145850_b.field_73011_w.getWorldTime() % 2L == 0L) {
                    this.initiate(0);
                }
                this.setActive(true);
                this.setOverclockRates();
            }
            ItemStack output1 = this.output.getRecipe().output.items.get(0);
            int size = this.output.getRecipe().input.getInputs().get(0).getInputs().get(0).func_190916_E();
            size = (int)Math.floor((float)this.inputSlot.get().func_190916_E() / (float)size);
            int size1 = !this.outputSlot.isEmpty() ? (64 - this.outputSlot.get().func_190916_E()) / output1.func_190916_E() : 64 / output1.func_190916_E();
            size = Math.min(size1, size);
            if (this.size_recipe != (double)(size = Math.min(size, output1.func_77976_d()))) {
                this.setOverclockRates();
            }
            try {
                this.guiProgress = this.energy.getEnergy() / this.energy.getCapacity();
            }
            catch (Exception e) {
                this.guiProgress = 0.0;
            }
            if (this.guiProgress >= 1.0) {
                this.operate(output, size);
                this.progress = 0.0;
                this.energy.useEnergy(this.energy.getEnergy());
                this.initiate(2);
            }
        } else {
            if (this.energy.getEnergy() != 0.0 && this.getActive()) {
                this.initiate(1);
            }
            this.energy.useEnergy(this.energy.getEnergy());
            this.energy.setCapacity(0.0);
            this.setActive(false);
        }
        if (this.getActive() && output == null) {
            this.setActive(false);
        }
        if (!this.outputSlot.isEmpty() && this.func_145831_w().field_73011_w.getWorldTime() % 10L == 0L) {
            ModUtils.tick(this.outputSlot, this);
        }
    }

    public MachineRecipe getOutput() {
        this.output = this.inputSlot.process();
        this.output_stack = this.output != null ? this.output.getRecipe().output.items.get(0) : new ItemStack(Items.field_190931_a);
        return this.output;
    }

    public double getProgress() {
        return Math.min(this.guiProgress, 1.0);
    }

    public String getStartSoundFile() {
        return "Machines/molecular.ogg";
    }

    @Override
    public void onUpdate() {
        for (int i = 0; i < this.inputSlot.size(); ++i) {
            if (this.inputSlot.get(i).func_77973_b() instanceof ItemEnchantedBook) {
                this.need = true;
                return;
            }
            if (!(this.inputSlot.get(i).func_77973_b() instanceof ItemPotion)) continue;
            this.need = true;
            return;
        }
        this.need = false;
    }

    @Override
    public MachineRecipe getRecipeOutput() {
        return this.output;
    }

    @Override
    public void setRecipeOutput(MachineRecipe output) {
        this.output = output;
        this.output_stack = this.output != null ? this.output.getRecipe().output.items.get(0) : new ItemStack(Items.field_190931_a);
        this.setOverclockRates();
    }

    @Override
    public SoundEvent getSound() {
        return EnumSound.molecular.getSoundEvent();
    }
}

