/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.tiles.base;

import com.denfop.IUCore;
import com.denfop.IUItem;
import com.denfop.api.tile.IMultiTileBlock;
import com.denfop.audio.EnumSound;
import com.denfop.blocks.BlockTileEntity;
import com.denfop.blocks.mechanism.BlockBaseMachine3;
import com.denfop.network.DecoderHandler;
import com.denfop.network.EncoderHandler;
import com.denfop.network.packet.CustomPacketBuffer;
import com.denfop.network.packet.PacketUpdateFieldTile;
import com.denfop.tiles.base.TileElectricMachine;
import com.denfop.utils.ModUtils;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.boss.EntityDragon;
import net.minecraft.entity.boss.EntityWither;
import net.minecraft.entity.item.EntityBoat;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.entity.monster.EntityGhast;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileEntityTeleporter
extends TileElectricMachine {
    private BlockPos target;
    private int targetCheckTicker = IUCore.random.nextInt(1024);
    private int cooldown = 0;

    public TileEntityTeleporter() {
        super(500000.0, 14, 0);
    }

    private static int getStackCost(ItemStack stack) {
        return ModUtils.isEmpty(stack) ? 0 : 100 * ModUtils.getSize(stack) / stack.func_77976_d();
    }

    @Override
    public IMultiTileBlock getTeBlock() {
        return BlockBaseMachine3.teleporter_iu;
    }

    @Override
    public BlockTileEntity getBlock() {
        return IUItem.basemachine2;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        if (nbt.func_74764_b("targetX")) {
            this.target = new BlockPos(nbt.func_74762_e("targetX"), nbt.func_74762_e("targetY"), nbt.func_74762_e("targetZ"));
        }
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        if (this.target != null) {
            nbt.func_74768_a("targetX", this.target.func_177958_n());
            nbt.func_74768_a("targetY", this.target.func_177956_o());
            nbt.func_74768_a("targetZ", this.target.func_177952_p());
        }
        return nbt;
    }

    @Override
    public void onLoaded() {
        super.onLoaded();
    }

    @Override
    public void updateEntityServer() {
        World world;
        boolean coolingDown;
        super.updateEntityServer();
        boolean bl = coolingDown = this.cooldown > 0;
        if (coolingDown) {
            --this.cooldown;
            new PacketUpdateFieldTile(this, "cooldown", this.cooldown);
        }
        if ((world = this.func_145831_w()).func_175640_z(this.field_174879_c) && this.target != null) {
            this.setActive(true);
            List entitiesNearby = coolingDown ? Collections.emptyList() : world.func_72872_a(Entity.class, new AxisAlignedBB((double)(this.field_174879_c.func_177958_n() - 1), (double)this.field_174879_c.func_177956_o(), (double)(this.field_174879_c.func_177952_p() - 1), (double)(this.field_174879_c.func_177958_n() + 2), (double)(this.field_174879_c.func_177956_o() + 3), (double)(this.field_174879_c.func_177952_p() + 2)));
            if (!entitiesNearby.isEmpty() && this.verifyTarget()) {
                double minDistanceSquared = Double.MAX_VALUE;
                Entity closestEntity = null;
                for (Object o : entitiesNearby) {
                    double distSquared;
                    Entity entity = (Entity)o;
                    if (entity.func_184187_bx() != null || !((distSquared = this.field_174879_c.func_177957_d(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v)) < minDistanceSquared)) continue;
                    minDistanceSquared = distSquared;
                    closestEntity = entity;
                }
                assert (closestEntity != null);
                world.func_184133_a(null, this.field_174879_c, EnumSound.teleporter.getSoundEvent(), SoundCategory.BLOCKS, 1.0f, 1.0f);
                this.teleport(closestEntity, Math.sqrt(this.field_174879_c.func_177951_i((Vec3i)this.target)));
            } else if (++this.targetCheckTicker % 1024 == 0) {
                this.verifyTarget();
            }
        } else {
            this.setActive(false);
        }
    }

    private boolean verifyTarget() {
        if (this.func_145831_w().func_175625_s(this.target) instanceof TileEntityTeleporter) {
            return true;
        }
        this.target = null;
        this.setActive(false);
        return false;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void updateEntityClient() {
        super.updateEntityClient();
        if (this.getActive()) {
            if (this.cooldown > 0) {
                this.spawnGreenParticles(2, this.field_174879_c);
            } else {
                this.spawnBlueParticles(2, this.field_174879_c);
            }
        }
    }

    public void teleport(Entity user, double distance) {
        int energyCost;
        int weight = this.getWeightOf(user);
        if (weight != 0 && (energyCost = (int)((double)weight * Math.pow(distance + 10.0, 0.7) * 5.0)) <= this.getAvailableEnergy()) {
            this.consumeEnergy(energyCost);
            if (user instanceof EntityPlayerMP) {
                user.func_70634_a((double)this.target.func_177958_n() + 0.5, (double)this.target.func_177956_o() + 1.5 + user.func_70033_W(), (double)this.target.func_177952_p() + 0.5);
            } else {
                user.func_70080_a((double)this.target.func_177958_n() + 0.5, (double)this.target.func_177956_o() + 1.5 + user.func_70033_W(), (double)this.target.func_177952_p() + 0.5, user.field_70177_z, user.field_70125_A);
            }
            TileEntity te = this.func_145831_w().func_175625_s(this.target);
            assert (te instanceof TileEntityTeleporter);
            ((TileEntityTeleporter)te).onTeleportTo();
        }
    }

    public void spawnBlueParticles(int n, BlockPos pos) {
        this.spawnParticles(n, pos, 0, 1);
    }

    public void spawnGreenParticles(int n, BlockPos pos) {
        this.spawnParticles(n, pos, 1, 0);
    }

    private void spawnParticles(int n, BlockPos pos, int green, int blue) {
        World world = this.func_145831_w();
        Random rnd = world.field_73012_v;
        for (int i = 0; i < n; ++i) {
            world.func_175688_a(EnumParticleTypes.REDSTONE, (double)((float)pos.func_177958_n() + rnd.nextFloat()), (double)((float)(pos.func_177956_o() + 1) + rnd.nextFloat()), (double)((float)pos.func_177952_p() + rnd.nextFloat()), -1.0, (double)green, (double)blue, new int[0]);
            world.func_175688_a(EnumParticleTypes.REDSTONE, (double)((float)pos.func_177958_n() + rnd.nextFloat()), (double)((float)(pos.func_177956_o() + 2) + rnd.nextFloat()), (double)((float)pos.func_177952_p() + rnd.nextFloat()), -1.0, (double)green, (double)blue, new int[0]);
        }
    }

    public void consumeEnergy(int energy) {
        this.energy.useEnergy(energy);
    }

    public int getAvailableEnergy() {
        return (int)this.energy.getEnergy();
    }

    public int getWeightOf(Entity user) {
        boolean teleporterUseInventoryWeight = true;
        int weight = 0;
        if (user instanceof EntityItem) {
            ItemStack is = ((EntityItem)user).func_92059_d();
            weight += 100 * ModUtils.getSize(is) / is.func_77976_d();
        } else if (!(user instanceof EntityAnimal || user instanceof EntityMinecart || user instanceof EntityBoat)) {
            if (user instanceof EntityPlayer) {
                weight += 1000;
                if (teleporterUseInventoryWeight) {
                    for (ItemStack stack1 : ((EntityPlayer)user).field_71071_by.field_70462_a) {
                        weight += TileEntityTeleporter.getStackCost(stack1);
                    }
                }
            } else if (user instanceof EntityGhast) {
                weight += 2500;
            } else if (user instanceof EntityWither) {
                weight += 5000;
            } else if (user instanceof EntityDragon) {
                weight += 10000;
            } else if (user instanceof EntityCreature) {
                weight += 500;
            }
        } else {
            weight += 100;
        }
        if (user instanceof EntityLivingBase) {
            EntityLivingBase living = (EntityLivingBase)user;
            for (ItemStack stack : living.func_184209_aF()) {
                weight += TileEntityTeleporter.getStackCost(stack);
            }
            if (user instanceof EntityPlayer) {
                ItemStack stack;
                stack = living.func_184614_ca();
                weight -= TileEntityTeleporter.getStackCost(stack);
            }
        }
        for (Entity passenger : user.func_184188_bt()) {
            weight += this.getWeightOf(passenger);
        }
        return weight;
    }

    private void onTeleportTo() {
        this.cooldown = 20;
    }

    public boolean hasTarget() {
        return this.target != null;
    }

    public BlockPos getTarget() {
        return this.target;
    }

    public void setTarget(BlockPos pos) {
        this.target = pos;
        new PacketUpdateFieldTile(this, "target", this.target);
    }

    @Override
    public void updateField(String name, CustomPacketBuffer is) {
        if (name.equals("cooldown")) {
            try {
                this.cooldown = (Integer)DecoderHandler.decode(is);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        if (name.equals("target")) {
            try {
                this.target = (BlockPos)DecoderHandler.decode(is);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        super.updateField(name, is);
    }

    @Override
    public CustomPacketBuffer writePacket() {
        CustomPacketBuffer packet = super.writePacket();
        try {
            EncoderHandler.encode(packet, this.target);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return packet;
    }

    @Override
    public void readPacket(CustomPacketBuffer customPacketBuffer) {
        super.readPacket(customPacketBuffer);
        try {
            this.target = (BlockPos)DecoderHandler.decode(customPacketBuffer);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

