/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.tiles.base;

import com.denfop.IUCore;
import com.denfop.api.inv.IAdvInventory;
import com.denfop.api.tile.IMultiTileBlock;
import com.denfop.api.upgrades.IUpgradableBlock;
import com.denfop.api.upgrades.IUpgradeItem;
import com.denfop.blocks.BlockTileEntity;
import com.denfop.componets.AbstractComponent;
import com.denfop.componets.ComponentPrivate;
import com.denfop.componets.Redstone;
import com.denfop.componets.client.ComponentClientEffectRender;
import com.denfop.container.ContainerBase;
import com.denfop.invslot.InvSlot;
import com.denfop.invslot.InvSlotUpgrade;
import com.denfop.tiles.base.InfoInvSlots;
import com.denfop.tiles.base.TileEntityBlock;
import com.denfop.utils.ModUtils;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nonnull;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;
import net.minecraftforge.items.wrapper.SidedInvWrapper;
import org.jetbrains.annotations.NotNull;

public class TileEntityInventory
extends TileEntityBlock
implements ISidedInventory,
IAdvInventory<TileEntityInventory>,
ICapabilityProvider {
    protected final List<InvSlot> invSlots = new ArrayList<InvSlot>();
    protected final List<InfoInvSlots> infoInvSlotsList = new ArrayList<InfoInvSlots>();
    protected final IItemHandler[] itemHandler = new IItemHandler[EnumFacing.field_82609_l.length + 1];
    private final ComponentPrivate componentPrivate = this.addComponent(new ComponentPrivate(this));
    protected boolean isLoaded = false;
    protected int size_inventory;
    protected ComponentClientEffectRender componentClientEffectRender;
    private int[] slotsFace;

    public static int getIndex(int loc) {
        return loc >>> 16;
    }

    public void onNetworkEvent(int var1) {
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void updateEntityClient() {
        super.updateEntityClient();
        if (this.componentClientEffectRender != null) {
            this.componentClientEffectRender.render();
        }
        this.updateClientList.forEach(AbstractComponent::updateEntityClient);
    }

    public boolean canUpgradeBlock() {
        for (AbstractComponent abstractComponent : this.componentList) {
            if (!abstractComponent.canUpgradeBlock()) continue;
            return true;
        }
        return false;
    }

    @Override
    public void onUnloaded() {
        super.onUnloaded();
    }

    @Override
    public int getWeakPower(EnumFacing side) {
        return 0;
    }

    @Override
    public boolean canConnectRedstone(EnumFacing side) {
        return this.hasComp(Redstone.class);
    }

    @Override
    public int getComparatorInputOverride() {
        return 0;
    }

    @NotNull
    public BlockPos getBlockPos() {
        return this.field_174879_c;
    }

    @Override
    public boolean onActivated(EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (this.func_145831_w().field_72995_K) {
            return true;
        }
        boolean action = ForgeHooks.onRightClickBlock((EntityPlayer)player, (EnumHand)hand, (BlockPos)this.field_174879_c, (EnumFacing)side, (Vec3d)new Vec3d((double)hitX, (double)hitY, (double)hitZ)).isCanceled();
        if (!action) {
            IUpgradableBlock upgradableBlock;
            IUpgradeItem iUpgradeItem;
            AtomicBoolean end = new AtomicBoolean(false);
            this.componentList.forEach(abstractComponent -> end.set(end.get() || abstractComponent.onBlockActivated(player, hand)));
            if (end.get()) {
                return true;
            }
            ItemStack stack = player.func_184586_b(hand);
            if (!stack.func_190926_b() && stack.func_77973_b() instanceof IUpgradeItem && this instanceof IUpgradableBlock && (iUpgradeItem = (IUpgradeItem)stack.func_77973_b()).isSuitableFor(stack, (upgradableBlock = (IUpgradableBlock)((Object)this)).getUpgradableProperties())) {
                for (InvSlot invslot : this.invSlots) {
                    if (!(invslot instanceof InvSlotUpgrade)) continue;
                    InvSlotUpgrade upgrade = (InvSlotUpgrade)invslot;
                    if (!upgrade.add(stack)) break;
                    stack.func_190920_e(0);
                    player.field_71070_bA.func_75142_b();
                    this.func_70296_d();
                    return true;
                }
            }
            player.openGui((Object)IUCore.instance, -1, this.field_145850_b, this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p());
        }
        return true;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbtTagCompound) {
        super.func_145839_a(nbtTagCompound);
        NBTTagCompound invSlotsTag = nbtTagCompound.func_74775_l("InvSlots");
        for (InvSlot invSlot : this.invSlots) {
            invSlot.readFromNbt(invSlotsTag.func_74775_l(String.valueOf(this.invSlots.indexOf(invSlot))));
        }
    }

    @Override
    public void onLoaded() {
        super.onLoaded();
        this.infoInvSlotsList.clear();
        for (InvSlot slot : this.invSlots) {
            for (int k = 0; k < slot.size(); ++k) {
                this.infoInvSlotsList.add(new InfoInvSlots(slot, k));
            }
        }
        this.size_inventory = 0;
        for (InvSlot invSlot : this.invSlots) {
            this.size_inventory += invSlot.size();
        }
    }

    public List<InvSlot> getInvSlots() {
        return this.invSlots;
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        NBTTagCompound invSlotsTag = new NBTTagCompound();
        for (InvSlot invSlot : this.invSlots) {
            NBTTagCompound invSlotTag = new NBTTagCompound();
            invSlot.writeToNbt(invSlotTag);
            invSlotsTag.func_74782_a(String.valueOf(this.invSlots.indexOf(invSlot)), (NBTBase)invSlotTag);
        }
        nbt.func_74782_a("InvSlots", (NBTBase)invSlotsTag);
        return nbt;
    }

    public int func_70302_i_() {
        if (this.size_inventory == 0 && this.invSlots.size() != 0) {
            for (InvSlot invSlot : this.invSlots) {
                this.size_inventory += invSlot.size();
            }
        }
        return this.size_inventory;
    }

    public boolean func_191420_l() {
        return this.invSlots.isEmpty();
    }

    @Nonnull
    public ItemStack func_70301_a(int index) {
        InfoInvSlots loc = this.locateInfoInvSlot(index);
        return loc == null ? ModUtils.emptyStack : loc.getSlot().get(loc.getIndex());
    }

    @Nonnull
    public ItemStack func_70298_a(int index, int amount) {
        InfoInvSlots loc = this.locateInfoInvSlot(index);
        if (loc == null) {
            return ModUtils.emptyStack;
        }
        ItemStack stack = loc.getSlot().get(loc.getIndex());
        if (ModUtils.isEmpty(stack)) {
            return ModUtils.emptyStack;
        }
        if (amount >= ModUtils.getSize(stack)) {
            this.putStackAt(loc, ModUtils.emptyStack);
            return stack;
        }
        if (amount != 0) {
            if (amount < 0) {
                int space = Math.min(loc.getSlot().getStackSizeLimit(), stack.func_77976_d()) - ModUtils.getSize(stack);
                amount = Math.max(amount, -space);
            }
            this.putStackAt(loc, ModUtils.decSize(stack, amount));
        }
        ItemStack ret = stack.func_77946_l();
        ret = ModUtils.setSize(ret, amount);
        return ret;
    }

    @Nonnull
    public ItemStack func_70304_b(int index) {
        InfoInvSlots loc = this.locateInfoInvSlot(index);
        if (loc == null) {
            return ModUtils.emptyStack;
        }
        ItemStack ret = loc.getSlot().get(loc.getIndex());
        if (!ModUtils.isEmpty(ret)) {
            this.putStackAt(loc, ModUtils.emptyStack);
        }
        return ret;
    }

    public void func_70299_a(int index, @Nonnull ItemStack stack) {
        InfoInvSlots loc = this.locateInfoInvSlot(index);
        if (loc == null) {
            assert (false);
        } else {
            if (ModUtils.isEmpty(stack)) {
                stack = ModUtils.emptyStack;
            }
            this.putStackAt(loc, stack);
        }
    }

    @Override
    public void func_70296_d() {
        super.func_70296_d();
        for (InvSlot invSlot : this.invSlots) {
            invSlot.onChanged();
        }
    }

    @Nonnull
    public String func_70005_c_() {
        String name = this.teBlock == null ? "invalid" : this.teBlock.func_176610_l();
        return this.getBlockType().func_149739_a() + "." + name;
    }

    public boolean func_145818_k_() {
        return false;
    }

    @Override
    public IMultiTileBlock getTeBlock() {
        return null;
    }

    @Override
    public BlockTileEntity getBlock() {
        return null;
    }

    @Override
    @Nonnull
    public ITextComponent func_145748_c_() {
        return new TextComponentString(this.func_70005_c_());
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(@Nonnull EntityPlayer player) {
        return !this.func_145837_r() && player.func_174818_b(this.field_174879_c) <= 64.0;
    }

    public void func_174889_b(@Nonnull EntityPlayer player) {
    }

    public void func_174886_c(@Nonnull EntityPlayer player) {
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        if (stack.func_190926_b()) {
            return false;
        }
        InvSlot invSlot = this.getInventorySlot(index);
        return invSlot != null && invSlot.canInput() && invSlot.accepts(stack, this.locateInfoInvSlot(index).getIndex());
    }

    @Nonnull
    public int[] func_180463_a(@Nonnull EnumFacing side) {
        if (this.slotsFace == null) {
            this.slotsFace = new int[this.func_70302_i_()];
            for (int i = 0; i < this.func_70302_i_(); ++i) {
                this.slotsFace[i] = i;
            }
        }
        return this.slotsFace;
    }

    public boolean func_180462_a(int index, @Nonnull ItemStack stack, @Nonnull EnumFacing side) {
        if (ModUtils.isEmpty(stack)) {
            return false;
        }
        InvSlot targetSlot = this.getInventorySlot(index);
        if (targetSlot == null) {
            return false;
        }
        return targetSlot.canInput() && targetSlot.accepts(stack, this.locateInfoInvSlot(index).getIndex());
    }

    public boolean func_180461_b(int index, @Nonnull ItemStack stack, @Nonnull EnumFacing side) {
        InvSlot targetSlot = this.getInventorySlot(index);
        return targetSlot != null && targetSlot.canOutput();
    }

    public int func_174887_a_(int id) {
        return 0;
    }

    public void func_174885_b(int id, int value) {
    }

    public int func_174890_g() {
        return 0;
    }

    public void func_174888_l() {
    }

    @Override
    public int getBaseIndex(InvSlot invSlot) {
        int ret = 0;
        for (InvSlot slot : this.invSlots) {
            if (slot == invSlot) {
                return ret;
            }
            ret += slot.size();
        }
        return -1;
    }

    @Override
    public ContainerBase<?> getGuiContainer(EntityPlayer var1) {
        return null;
    }

    @Override
    public GuiScreen getGui(EntityPlayer var1, boolean var2) {
        return null;
    }

    @Override
    public TileEntityInventory getParent() {
        return this;
    }

    @Override
    public void addInventorySlot(InvSlot inventorySlot) {
        assert (this.invSlots.stream().noneMatch(slot -> slot.equals(inventorySlot)));
        this.invSlots.add(inventorySlot);
    }

    public InfoInvSlots locateInfoInvSlot(int extIndex) {
        try {
            return this.infoInvSlotsList.get(extIndex);
        }
        catch (Exception e) {
            return null;
        }
    }

    private void putStackAt(InfoInvSlots loc, ItemStack stack) {
        loc.getSlot().put(loc.getIndex(), stack);
        super.func_70296_d();
    }

    protected InvSlot getInventorySlot(int extIndex) {
        InfoInvSlots loc = this.locateInfoInvSlot(extIndex);
        return loc == null ? null : loc.getSlot();
    }

    @Override
    public void onPlaced(ItemStack stack, EntityLivingBase placer, EnumFacing facing) {
        super.onPlaced(stack, placer, facing);
    }

    @Override
    public List<ItemStack> getSelfDrops(int fortune, boolean wrench) {
        List<ItemStack> list = super.getSelfDrops(fortune, wrench);
        return list;
    }

    @Override
    public List<ItemStack> getAuxDrops(int fortune) {
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>(super.getAuxDrops(fortune));
        for (InvSlot slot : this.invSlots) {
            for (ItemStack stack : slot.gets()) {
                if (ModUtils.isEmpty(stack)) continue;
                ret.add(stack);
            }
        }
        for (AbstractComponent component : this.getComponentList()) {
            if (component.getDrops().isEmpty()) continue;
            ret.addAll(component.getDrops());
        }
        return ret;
    }

    @Override
    public <T> T getCapability(@NotNull Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            if (facing == null) {
                if (this.itemHandler[this.itemHandler.length - 1] == null) {
                    this.itemHandler[this.itemHandler.length - 1] = new InvWrapper((IInventory)this);
                }
                return (T)CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.cast((Object)this.itemHandler[this.itemHandler.length - 1]);
            }
            if (this.itemHandler[facing.ordinal()] == null) {
                this.itemHandler[facing.ordinal()] = new SidedInvWrapper((ISidedInventory)this, facing);
            }
            return (T)CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.cast((Object)this.itemHandler[facing.ordinal()]);
        }
        if (this.capabilityComponents == null) {
            return super.getCapability(capability, facing);
        }
        AbstractComponent comp = (AbstractComponent)this.capabilityComponents.get(capability);
        return comp == null ? super.getCapability(capability, facing) : comp.getCapability(capability, facing);
    }

    @Override
    public boolean hasCapability(@NotNull Capability<?> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return true;
        }
        if (super.hasCapability(capability, facing)) {
            return true;
        }
        if (this.capabilityComponents == null) {
            return false;
        }
        AbstractComponent comp = (AbstractComponent)this.capabilityComponents.get(capability);
        return comp != null && comp.getProvidedCapabilities(facing).contains(capability);
    }

    @Override
    public final <T extends AbstractComponent> T addComponent(T component) {
        if (component == null) {
            throw new NullPointerException("null component");
        }
        this.componentList.add(component);
        this.advComponentMap.put(component.toString(), component);
        if (component.isClient()) {
            this.updateClientList.add(component);
        }
        if (component.isServer()) {
            this.updateServerList.add(component);
        }
        for (Capability<?> capability : component.getProvidedCapabilities(null)) {
            this.addComponentCapability(capability, component);
        }
        return component;
    }

    @Override
    public final <T extends AbstractComponent> void removeComponent(T component) {
        if (component == null) {
            throw new NullPointerException("null component");
        }
        this.componentList.remove(component);
        this.advComponentMap.remove(component.toString(), component);
        if (component.isClient()) {
            this.updateClientList.remove(component);
        }
        if (component.isServer()) {
            this.updateServerList.remove(component);
        }
        for (Capability<?> capability : component.getProvidedCapabilities(null)) {
            this.removeComponentCapability(capability, component);
        }
    }

    @Override
    public void addComponentCapability(Capability<?> cap, AbstractComponent component) {
        if (this.capabilityComponents == null) {
            this.capabilityComponents = new IdentityHashMap();
        }
        AbstractComponent prev = this.capabilityComponents.put(cap, component);
        assert (prev == null);
    }

    @Override
    public void removeComponentCapability(Capability<?> cap, AbstractComponent component) {
        if (this.capabilityComponents == null) {
            this.capabilityComponents = new IdentityHashMap();
        }
        this.capabilityComponents.remove(cap, component);
    }

    public boolean hasComp(Class<? extends AbstractComponent> cls) {
        for (AbstractComponent component : this.componentList) {
            if (component.getClass() != cls) continue;
            return true;
        }
        return false;
    }

    @Override
    public List<AbstractComponent> getComponentList() {
        return this.componentList;
    }

    public ComponentClientEffectRender getComponentClientEffectRender() {
        return this.componentClientEffectRender;
    }

    @Override
    public <T extends AbstractComponent> T getComp(String cls) {
        for (AbstractComponent component : this.componentList) {
            if (!component.toString().trim().equals(cls)) continue;
            return (T)component;
        }
        return null;
    }

    @Override
    public Map<Capability<?>, AbstractComponent> getCapabilityComponents() {
        return this.capabilityComponents;
    }

    @Override
    public <T extends AbstractComponent> T getComp(Class<T> cls) {
        for (AbstractComponent component : this.componentList) {
            if (component.getClass() != cls) continue;
            return (T)component;
        }
        return null;
    }

    @Override
    public final Iterable<? extends AbstractComponent> getComps() {
        return this.componentList;
    }
}

