/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.tiles.base;

import com.denfop.IUCore;
import com.denfop.IUItem;
import com.denfop.api.tile.IMultiTileBlock;
import com.denfop.blocks.BlockResource;
import com.denfop.blocks.BlockTileEntity;
import com.denfop.blocks.state.TileEntityBlockStateContainer;
import com.denfop.componets.AbstractComponent;
import com.denfop.componets.Redstone;
import com.denfop.events.TickHandlerIU;
import com.denfop.invslot.InvSlot;
import com.denfop.network.DecoderHandler;
import com.denfop.network.packet.CustomPacketBuffer;
import com.denfop.network.packet.PacketRemoveUpdateTile;
import com.denfop.network.packet.PacketStopSound;
import com.denfop.network.packet.PacketUpdateFieldTile;
import com.denfop.network.packet.PacketUpdateTile;
import com.denfop.utils.ModUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jetbrains.annotations.Nullable;

public abstract class TileEntityBlock
extends TileEntity
implements ITickable {
    public static final List<AxisAlignedBB> defaultAabbs = Collections.singletonList(new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 1.0));
    public final IMultiTileBlock teBlock;
    public final BlockTileEntity block;
    public Map<Capability<?>, AbstractComponent> capabilityComponents;
    public IBlockState blockState = null;
    public List<AbstractComponent> componentList = new ArrayList<AbstractComponent>();
    public List<AbstractComponent> updateServerList = new ArrayList<AbstractComponent>();
    public List<AbstractComponent> updateClientList = new ArrayList<AbstractComponent>();
    public Map<String, AbstractComponent> advComponentMap = new HashMap<String, AbstractComponent>();
    public String active = "";
    public byte facing = (byte)EnumFacing.DOWN.ordinal();
    public boolean isLoaded;
    private boolean isClientLoaded;

    public TileEntityBlock() {
        this.teBlock = this.getTeBlock();
        this.block = this.getBlock();
    }

    public static <T extends TileEntityBlock> T instantiate(Class<T> cls) {
        try {
            return (T)((Object)((TileEntityBlock)((Object)cls.newInstance())));
        }
        catch (Exception var2) {
            throw new RuntimeException(var2);
        }
    }

    public static boolean checkSide(List<AxisAlignedBB> aabbs, EnumFacing side, boolean strict) {
        AxisAlignedBB aabb2;
        if (aabbs == defaultAabbs) {
            return true;
        }
        int dx = side.func_82601_c();
        int dy = side.func_96559_d();
        int dz = side.func_82599_e();
        int xS = (dx + 1) / 2;
        int yS = (dy + 1) / 2;
        int zS = (dz + 1) / 2;
        int xE = (dx + 2) / 2;
        int yE = (dy + 2) / 2;
        int zE = (dz + 2) / 2;
        if (strict) {
            for (AxisAlignedBB aabb2 : aabbs) {
                switch (side) {
                    case DOWN: {
                        if (!(aabb2.field_72338_b < 0.0)) break;
                        return false;
                    }
                    case UP: {
                        if (!(aabb2.field_72337_e > 1.0)) break;
                        return false;
                    }
                    case NORTH: {
                        if (!(aabb2.field_72339_c < 0.0)) break;
                        return false;
                    }
                    case SOUTH: {
                        if (!(aabb2.field_72334_f > 1.0)) break;
                        return false;
                    }
                    case WEST: {
                        if (!(aabb2.field_72340_a < 0.0)) break;
                        return false;
                    }
                    case EAST: {
                        if (!(aabb2.field_72336_d > 1.0)) break;
                        return false;
                    }
                }
            }
        }
        Iterator<AxisAlignedBB> var12 = aabbs.iterator();
        do {
            if (!var12.hasNext()) {
                return false;
            }
            aabb2 = var12.next();
        } while (!(aabb2.field_72340_a <= (double)xS) || !(aabb2.field_72338_b <= (double)yS) || !(aabb2.field_72339_c <= (double)zS) || !(aabb2.field_72336_d >= (double)xE) || !(aabb2.field_72337_e >= (double)yE) || !(aabb2.field_72334_f >= (double)zE));
        return true;
    }

    public void func_145834_a(World worldIn) {
        super.func_145834_a(worldIn);
    }

    public void func_174878_a(BlockPos posIn) {
        super.func_174878_a(posIn);
    }

    public NBTTagCompound getNBTFromSlot(CustomPacketBuffer customPacketBuffer) {
        try {
            InvSlot slot = (InvSlot)DecoderHandler.decode(customPacketBuffer);
            return slot.writeToNbt(new NBTTagCompound());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newSate) {
        if (oldState.func_177230_c() instanceof BlockTileEntity) {
            return false;
        }
        return newSate.func_177230_c() != oldState.func_177230_c();
    }

    public boolean onSneakingActivated(EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        return this.func_145831_w().field_72995_K;
    }

    public void updateField(String name, CustomPacketBuffer is) {
        if (name.equals("active")) {
            try {
                this.active = (String)DecoderHandler.decode(is);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        if (name.equals("facing")) {
            is.readUnsignedByte();
            this.facing = is.readByte();
        }
        this.onNetworkUpdate(name);
    }

    public boolean hasCustomName() {
        return false;
    }

    public abstract IMultiTileBlock getTeBlock();

    public abstract BlockTileEntity getBlock();

    @Nonnull
    public ITextComponent func_145748_c_() {
        return new TextComponentString(this.getName());
    }

    public final BlockTileEntity getBlockType() {
        return this.block;
    }

    public final IBlockState getBlockState() {
        if (this.blockState == null) {
            if (!this.teBlock.hasActive() && this.active.contains("active")) {
                this.active = "";
            }
            try {
                this.blockState = this.block.func_176223_P().func_177226_a((IProperty)this.block.typeProperty, (Comparable)this.block.typeProperty.getState(this.teBlock, this.active)).func_177226_a(BlockTileEntity.facingProperty, (Comparable)this.getFacing());
            }
            catch (Exception e) {
                this.blockState = this.block.func_176223_P();
            }
            return this.blockState;
        }
        return this.blockState;
    }

    public final void func_145843_s() {
        this.onUnloaded();
        super.func_145843_s();
    }

    public final void onChunkUnload() {
        this.onUnloaded();
        super.onChunkUnload();
    }

    public final void func_145829_t() {
        super.func_145829_t();
        World world = this.func_145831_w();
        if (this.field_174879_c != null) {
            TickHandlerIU.requestSingleWorldTick(world, world1 -> this.onLoaded());
        }
    }

    public void onLoaded() {
        this.componentList.forEach(AbstractComponent::onLoaded);
        this.rerender();
        if (!this.func_145831_w().field_72995_K && this.needUpdate()) {
            IUCore.network.getServer().addTileToOvertimeUpdate(this);
        }
    }

    public void onUnloaded() {
        IUCore.network.getServer().removeTileToOvertimeUpdate(this);
        this.componentList.forEach(AbstractComponent::onUnloaded);
        try {
            new PacketStopSound(this.func_145831_w(), this.field_174879_c);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (!this.func_145831_w().field_72995_K) {
            new PacketRemoveUpdateTile(this);
        }
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        if (!this.getSupportedFacings().isEmpty()) {
            byte facingValue = nbt.func_74771_c("facing");
            this.facing = facingValue >= 0 && facingValue < EnumFacing.field_82609_l.length && this.getSupportedFacings().contains(EnumFacing.field_82609_l[facingValue]) ? facingValue : (!this.getSupportedFacings().isEmpty() ? (byte)this.getSupportedFacings().iterator().next().ordinal() : (byte)EnumFacing.DOWN.ordinal());
        }
        this.active = nbt.func_74779_i("active");
        if (!this.componentList.isEmpty() && nbt.func_150297_b("components", 10)) {
            NBTTagCompound componentsNbt = nbt.func_74775_l("components");
            for (int i = 0; i < this.componentList.size(); ++i) {
                AbstractComponent component = this.componentList.get(i);
                NBTTagCompound componentNbt = componentsNbt.func_74775_l("component_" + i);
                component.readFromNbt(componentNbt);
            }
        }
    }

    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        if (!this.getSupportedFacings().isEmpty()) {
            nbt.func_74774_a("facing", this.facing);
        }
        nbt.func_74778_a("active", this.active);
        if (!this.componentList.isEmpty()) {
            NBTTagCompound componentsNbt = new NBTTagCompound();
            for (int i = 0; i < this.componentList.size(); ++i) {
                AbstractComponent component = this.componentList.get(i);
                NBTTagCompound nbt1 = component.writeToNbt();
                if (nbt1 == null) {
                    nbt1 = new NBTTagCompound();
                }
                componentsNbt.func_74782_a("component_" + i, (NBTBase)nbt1);
            }
            nbt.func_74782_a("components", (NBTBase)componentsNbt);
        }
        return nbt;
    }

    public NBTTagCompound func_189517_E_() {
        new PacketUpdateTile(this);
        return new NBTTagCompound();
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        new PacketUpdateTile(this);
        return null;
    }

    public final void func_73660_a() {
        if (this.func_145831_w().field_72995_K) {
            this.updateEntityClient();
        } else {
            this.updateEntityServer();
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void updateEntityClient() {
        this.updateClientList.forEach(AbstractComponent::updateEntityClient);
        if (!this.isClientLoaded) {
            this.loadBeforeFirstClientUpdate();
        }
    }

    public void loadBeforeFirstClientUpdate() {
        this.isClientLoaded = true;
    }

    public void updateEntityServer() {
        for (AbstractComponent component : this.updateServerList) {
            component.updateEntityServer();
        }
        if (!this.isLoaded) {
            this.loadBeforeFirstUpdate();
        }
    }

    public void loadBeforeFirstUpdate() {
        this.isLoaded = true;
        try {
            this.rerender();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void func_70296_d() {
        super.func_70296_d();
        if (IUCore.proxy.isSimulating()) {
            for (AbstractComponent abstractComponent : this.componentList) {
                abstractComponent.markDirty();
            }
        }
    }

    public void onNetworkUpdate(String field) {
        if (field.equals("active") || field.equals("facing")) {
            this.rerender();
        }
    }

    public boolean canEntityDestroy(Entity entity) {
        for (AbstractComponent component : this.componentList) {
            if (component.canEntityDestroy(entity)) continue;
            return false;
        }
        return true;
    }

    public List<ItemStack> getSelfDrops(int fortune, boolean wrench) {
        ItemStack drop = this.getPickBlock(null, null);
        if (!(drop = this.adjustDrop(drop, wrench)).func_190926_b()) {
            for (AbstractComponent component : this.componentList) {
                if (!component.needWriteNBTToDrops()) continue;
                NBTTagCompound tagCompound = ModUtils.nbt(drop);
                tagCompound.func_74782_a(component.toString(), (NBTBase)component.writeNBTToDrops(new NBTTagCompound()));
            }
        }
        return Collections.singletonList(drop);
    }

    public boolean wrenchCanRemove(EntityPlayer player) {
        for (AbstractComponent component : this.componentList) {
            if (component.wrenchCanRemove(player)) continue;
            return false;
        }
        return true;
    }

    public void onPlaced(ItemStack stack, EntityLivingBase placer, EnumFacing facing) {
        World world = this.func_145831_w();
        if ((facing = this.getPlacementFacing(placer, facing)) != this.getFacing()) {
            this.setFacing(facing);
        }
        if (world.field_72995_K) {
            this.rerender();
        }
        for (AbstractComponent component : this.componentList) {
            if (component.needWriteNBTToDrops()) {
                NBTTagCompound tagCompound = ModUtils.nbt(stack);
                NBTTagCompound tag = tagCompound.func_74775_l(component.toString());
                component.readFromNbt(tag);
            }
            component.onPlaced(stack, placer, facing);
        }
    }

    public AxisAlignedBB getVisualBoundingBox() {
        return this.getAabb(false);
    }

    public AxisAlignedBB getPhysicsBoundingBox() {
        return this.getAabb(true);
    }

    public AxisAlignedBB getOutlineBoundingBox() {
        return this.getVisualBoundingBox();
    }

    public void addCollisionBoxesToList(AxisAlignedBB mask, List<AxisAlignedBB> list, Entity collidingEntity) {
        AxisAlignedBB maskNormalized = mask.func_72317_d((double)(-this.field_174879_c.func_177958_n()), (double)(-this.field_174879_c.func_177956_o()), (double)(-this.field_174879_c.func_177952_p()));
        for (AxisAlignedBB aabb : this.getAabbs(true)) {
            if (!aabb.func_72326_a(maskNormalized)) continue;
            list.add(aabb.func_186670_a(this.field_174879_c));
        }
    }

    public AxisAlignedBB getAabb(boolean forCollision) {
        List<AxisAlignedBB> aabbs = this.getAabbs(forCollision);
        if (aabbs.isEmpty()) {
            throw new RuntimeException("No AABBs for " + (Object)((Object)this));
        }
        if (aabbs.size() == 1) {
            return aabbs.get(0);
        }
        double zS = Double.POSITIVE_INFINITY;
        double yS = Double.POSITIVE_INFINITY;
        double xS = Double.POSITIVE_INFINITY;
        double zE = Double.NEGATIVE_INFINITY;
        double yE = Double.NEGATIVE_INFINITY;
        double xE = Double.NEGATIVE_INFINITY;
        for (AxisAlignedBB aabb : aabbs) {
            xS = Math.min(xS, aabb.field_72340_a);
            yS = Math.min(yS, aabb.field_72338_b);
            zS = Math.min(zS, aabb.field_72339_c);
            xE = Math.max(xE, aabb.field_72336_d);
            yE = Math.max(yE, aabb.field_72337_e);
            zE = Math.max(zE, aabb.field_72334_f);
        }
        return new AxisAlignedBB(xS, yS, zS, xE, yE, zE);
    }

    public void onEntityCollision(Entity entity) {
    }

    @SideOnly(value=Side.CLIENT)
    public boolean shouldSideBeRendered(EnumFacing side, BlockPos otherPos) {
        World world;
        AxisAlignedBB aabb = this.getVisualBoundingBox();
        if (aabb != defaultAabbs) {
            switch (side) {
                case DOWN: {
                    if (!(aabb.field_72338_b > 0.0)) break;
                    return true;
                }
                case UP: {
                    if (!(aabb.field_72337_e < 1.0)) break;
                    return true;
                }
                case NORTH: {
                    if (!(aabb.field_72339_c > 0.0)) break;
                    return true;
                }
                case SOUTH: {
                    if (!(aabb.field_72334_f < 1.0)) break;
                    return true;
                }
                case WEST: {
                    if (!(aabb.field_72340_a > 0.0)) break;
                    return true;
                }
                case EAST: {
                    if (!(aabb.field_72336_d < 1.0)) break;
                    return true;
                }
            }
        }
        return !(world = this.func_145831_w()).func_180495_p(otherPos).doesSideBlockRendering((IBlockAccess)world, otherPos, side.func_176734_d());
    }

    public boolean doesSideBlockRendering(EnumFacing side) {
        return TileEntityBlock.checkSide(this.getAabbs(false), side, false);
    }

    public boolean isNormalCube() {
        List<AxisAlignedBB> aabbs = this.getAabbs(false);
        if (aabbs == defaultAabbs) {
            return true;
        }
        if (aabbs.size() != 1) {
            return false;
        }
        AxisAlignedBB aabb = aabbs.get(0);
        return aabb.field_72340_a <= 0.0 && aabb.field_72338_b <= 0.0 && aabb.field_72339_c <= 0.0 && aabb.field_72336_d >= 1.0 && aabb.field_72337_e >= 1.0 && aabb.field_72334_f >= 1.0;
    }

    public boolean isSideSolid(EnumFacing side) {
        return TileEntityBlock.checkSide(this.getAabbs(false), side, true);
    }

    public BlockFaceShape getFaceShape(EnumFacing face) {
        return this.isSideSolid(face) ? BlockFaceShape.SOLID : BlockFaceShape.UNDEFINED;
    }

    public int getLightOpacity() {
        return this.isNormalCube() ? 255 : 0;
    }

    public int getLightValue() {
        return 0;
    }

    public boolean onActivated(EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        return false;
    }

    public CustomPacketBuffer writeUpdatePacket() {
        return new CustomPacketBuffer();
    }

    public void readUpdatePacket(CustomPacketBuffer packetBuffer) {
    }

    public boolean needUpdate() {
        return false;
    }

    public CustomPacketBuffer writeContainerPacket() {
        return new CustomPacketBuffer();
    }

    public void readContainerPacket(CustomPacketBuffer customPacketBuffer) {
    }

    public CustomPacketBuffer writePacket() {
        CustomPacketBuffer packet = new CustomPacketBuffer();
        packet.writeString(this.teBlock.getIdentifier() + "=" + this.teBlock.func_176610_l());
        packet.writeString(this.active);
        packet.writeByte(this.facing);
        return packet;
    }

    public void readPacket(CustomPacketBuffer customPacketBuffer) {
        this.active = customPacketBuffer.readString();
        this.facing = customPacketBuffer.readByte();
        this.rerender();
    }

    public void onClicked(EntityPlayer player) {
    }

    public void onNeighborChange(Block neighbor, BlockPos neighborPos) {
        if (this.componentList != null) {
            for (AbstractComponent component : this.componentList) {
                component.onNeighborChange(neighbor, neighborPos);
            }
        }
    }

    public int getWeakPower(EnumFacing side) {
        return 0;
    }

    public boolean canConnectRedstone(EnumFacing side) {
        return this.hasComponent(Redstone.class);
    }

    public int getComparatorInputOverride() {
        return 0;
    }

    public <T extends AbstractComponent> T getComp(Class<T> cls) {
        for (AbstractComponent component : this.componentList) {
            if (component.getClass() != cls) continue;
            return (T)component;
        }
        return null;
    }

    public boolean hasComponent(Class<? extends AbstractComponent> cls) {
        for (AbstractComponent component : this.componentList) {
            if (component.getClass() != cls) continue;
            return true;
        }
        return false;
    }

    public List<AbstractComponent> getComponentList() {
        return this.componentList;
    }

    public <T extends AbstractComponent> T getComponent(String cls) {
        for (AbstractComponent component : this.componentList) {
            if (!component.toString().trim().equals(cls)) continue;
            return (T)component;
        }
        return null;
    }

    public void addComponentCapability(Capability<?> cap, AbstractComponent component) {
        if (this.capabilityComponents == null) {
            this.capabilityComponents = new IdentityHashMap();
        }
        AbstractComponent prev = this.capabilityComponents.put(cap, component);
        assert (prev == null);
    }

    public void removeComponentCapability(Capability<?> cap, AbstractComponent component) {
        if (this.capabilityComponents == null) {
            this.capabilityComponents = new IdentityHashMap();
        }
        this.capabilityComponents.remove(cap, component);
    }

    @Nullable
    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        if (this.capabilityComponents == null) {
            return (T)super.getCapability(capability, facing);
        }
        AbstractComponent comp = this.capabilityComponents.get(capability);
        return (T)(comp == null ? super.getCapability(capability, facing) : comp.getCapability(capability, facing));
    }

    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        if (this.capabilityComponents == null) {
            return false;
        }
        AbstractComponent comp = this.capabilityComponents.get(capability);
        return comp != null && comp.getProvidedCapabilities(facing).contains(capability);
    }

    public <T extends AbstractComponent> T addComponent(T component) {
        if (component == null) {
            throw new NullPointerException("null component");
        }
        this.componentList.add(component);
        this.advComponentMap.put(component.toString(), component);
        if (component.isClient()) {
            this.updateClientList.add(component);
        }
        if (component.isServer()) {
            this.updateServerList.add(component);
        }
        for (Capability<?> capability : component.getProvidedCapabilities(null)) {
            this.addComponentCapability(capability, component);
        }
        return component;
    }

    public <T extends AbstractComponent> void removeComponent(T component) {
        if (component == null) {
            throw new NullPointerException("null component");
        }
        this.componentList.remove(component);
        this.advComponentMap.remove(component.toString(), component);
        if (component.isClient()) {
            this.updateClientList.remove(component);
        }
        if (component.isServer()) {
            this.updateServerList.remove(component);
        }
        for (Capability<?> capability : component.getProvidedCapabilities(null)) {
            this.removeComponentCapability(capability, component);
        }
    }

    public Map<Capability<?>, AbstractComponent> getCapabilityComponents() {
        return this.capabilityComponents;
    }

    public <T extends AbstractComponent> T getComponent(Class<T> cls) {
        for (AbstractComponent component : this.componentList) {
            if (component.getClass() != cls) continue;
            return (T)component;
        }
        return null;
    }

    public Iterable<? extends AbstractComponent> getComps() {
        return this.componentList;
    }

    public void onExploded(Explosion explosion) {
    }

    public void onBlockBreak(boolean wrench) {
        for (AbstractComponent component : this.componentList) {
            component.blockBreak();
        }
    }

    public void wrenchBreak() {
        this.onBlockBreak(true);
    }

    public boolean onRemovedByPlayer(EntityPlayer player, boolean willHarvest) {
        return true;
    }

    public ItemStack getPickBlock(EntityPlayer player, RayTraceResult target) {
        return this.block.getItemStack(this.teBlock);
    }

    public List<ItemStack> getAuxDrops(int fortune) {
        return Collections.emptyList();
    }

    public float getHardness() {
        return this.teBlock.getHardness();
    }

    public EnumFacing getFacing() {
        return EnumFacing.field_82609_l[this.facing];
    }

    public void setFacing(EnumFacing facing) {
        if (facing == null) {
            throw new NullPointerException("null facing");
        }
        if (this.facing == facing.ordinal()) {
            throw new IllegalArgumentException("unchanged facing");
        }
        if (!this.getSupportedFacings().contains(facing)) {
            throw new IllegalArgumentException("invalid facing: " + facing + ", supported: " + this.getSupportedFacings());
        }
        this.facing = (byte)facing.ordinal();
        if (!this.func_145831_w().field_72995_K) {
            new PacketUpdateFieldTile(this, "facing", this.facing);
        }
    }

    public boolean canSetFacingWrench(EnumFacing facing, EntityPlayer player) {
        if (!this.teBlock.allowWrenchRotating()) {
            return false;
        }
        if (facing == this.getFacing()) {
            return false;
        }
        return this.getSupportedFacings().contains(facing);
    }

    public boolean setFacingWrench(EnumFacing facing, EntityPlayer player) {
        if (!this.canSetFacingWrench(facing, player)) {
            return false;
        }
        this.setFacing(facing);
        return true;
    }

    public List<ItemStack> getWrenchDrops(EntityPlayer player, int fortune) {
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        ret.addAll(this.getSelfDrops(fortune, true));
        ret.addAll(this.getAuxDrops(fortune));
        return ret;
    }

    public SoundType getBlockSound(Entity entity) {
        return SoundType.field_185851_d;
    }

    public EnumFacing getPlacementFacing(EntityLivingBase placer, EnumFacing facing) {
        Set<EnumFacing> supportedFacings = this.getSupportedFacings();
        if (supportedFacings.isEmpty()) {
            return EnumFacing.DOWN;
        }
        if (placer != null) {
            Vec3d dir = placer.func_70040_Z();
            EnumFacing bestFacing = null;
            double maxMatch = Double.NEGATIVE_INFINITY;
            for (EnumFacing cFacing : supportedFacings) {
                double match = dir.func_72430_b(new Vec3d(cFacing.func_176734_d().func_176730_m()));
                if (!(match > maxMatch)) continue;
                maxMatch = match;
                bestFacing = cFacing;
            }
            return bestFacing;
        }
        return facing != null && supportedFacings.contains(facing.func_176734_d()) ? facing.func_176734_d() : this.getSupportedFacings().iterator().next();
    }

    @Nonnull
    public String getName() {
        String name = this.teBlock == null ? "invalid" : this.teBlock.func_176610_l();
        return this.getBlockType().func_149739_a() + "." + name;
    }

    public List<AxisAlignedBB> getAabbs(boolean forCollision) {
        return defaultAabbs;
    }

    public ItemStack adjustDrop(ItemStack drop, boolean wrench) {
        if (!wrench) {
            switch (this.teBlock.getDefaultDrop()) {
                default: {
                    break;
                }
                case Generator: {
                    drop = new ItemStack((Block)IUItem.basemachine2, 1, 78);
                    break;
                }
                case None: {
                    drop = null;
                    break;
                }
                case Machine: {
                    return IUItem.blockResource.getItemStack(BlockResource.Type.machine);
                }
                case AdvMachine: {
                    return IUItem.blockResource.getItemStack(BlockResource.Type.advanced_machine);
                }
            }
        }
        return drop;
    }

    public Set<EnumFacing> getSupportedFacings() {
        return this.teBlock.getSupportedFacings();
    }

    public boolean getActive() {
        return this.active.contains("active");
    }

    public void setActive(boolean active) {
        if (!active && this.active.equals("")) {
            return;
        }
        if (active) {
            if (!this.active.equals("active")) {
                this.active = "active";
                new PacketUpdateFieldTile(this, "active", this.active);
            }
        } else {
            this.active = "";
            new PacketUpdateFieldTile(this, "active", this.active);
        }
    }

    public void setActive(String active) {
        if (this.active.equals(active)) {
            return;
        }
        this.active = active;
        new PacketUpdateFieldTile(this, "active", this.active);
    }

    @SideOnly(value=Side.CLIENT)
    public void addInformation(ItemStack stack, List<String> tooltip, ITooltipFlag advanced) {
    }

    public final void rerender() {
        IBlockState state1 = this.blockState;
        this.blockState = null;
        IBlockState state = this.getBlockState();
        if (state1 == null) {
            state1 = state;
        }
        this.func_145831_w().func_184138_a(this.field_174879_c, state1, state, 2);
    }

    public boolean clientNeedsExtraModelInfo() {
        return false;
    }

    public ItemStack getItem(EntityPlayer player, RayTraceResult target) {
        return this.block.getItemStack(this.teBlock);
    }

    public <T extends AbstractComponent> T getComp(String cls) {
        for (AbstractComponent component : this.componentList) {
            if (!component.toString().trim().equals(cls)) continue;
            return (T)component;
        }
        return null;
    }

    public TileEntityBlockStateContainer.PropertiesStateInstance getExtendedState(TileEntityBlockStateContainer.PropertiesStateInstance state) {
        return state;
    }

    public boolean hasSpecialModel() {
        return false;
    }
}

