/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.tiles.base;

import com.denfop.IUItem;
import com.denfop.Localization;
import com.denfop.api.tile.IMultiTileBlock;
import com.denfop.audio.EnumSound;
import com.denfop.blocks.BlockTileEntity;
import com.denfop.blocks.FluidName;
import com.denfop.blocks.mechanism.BlockBaseMachine2;
import com.denfop.container.ContainerElectrolyzer;
import com.denfop.gui.GuiElectrolyzer;
import com.denfop.invslot.InvSlotElectrolyzer;
import com.denfop.tiles.base.IManufacturerBlock;
import com.denfop.tiles.base.TileBaseLiquedMachine;
import java.util.List;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Keyboard;

public class TileElectrolyzer
extends TileBaseLiquedMachine
implements IManufacturerBlock {
    public final InvSlotElectrolyzer cathodeslot = new InvSlotElectrolyzer(this, 1);
    public final InvSlotElectrolyzer anodeslot = new InvSlotElectrolyzer(this, 0);

    public TileElectrolyzer() {
        super(24000.0, 14, 2, 3, new boolean[]{false, true, true}, new boolean[]{true, false, false}, new Fluid[]{FluidRegistry.WATER, FluidName.fluidhyd.getInstance(), FluidName.fluidoxy.getInstance()});
    }

    @Override
    public IMultiTileBlock getTeBlock() {
        return BlockBaseMachine2.electrolyzer_iu;
    }

    @Override
    public BlockTileEntity getBlock() {
        return IUItem.basemachine1;
    }

    public ContainerElectrolyzer getGuiContainer(EntityPlayer entityPlayer) {
        return new ContainerElectrolyzer(entityPlayer, this);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiScreen getGui(EntityPlayer entityPlayer, boolean isAdmin) {
        return new GuiElectrolyzer(new ContainerElectrolyzer(entityPlayer, this));
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void addInformation(ItemStack stack, List<String> tooltip, ITooltipFlag advanced) {
        if (!Keyboard.isKeyDown((int)42)) {
            tooltip.add(Localization.translate("press.lshift"));
        }
        if (Keyboard.isKeyDown((int)42)) {
            tooltip.add(Localization.translate("iu.machines_work_energy") + 25 + Localization.translate("iu.machines_work_energy_type_eu"));
        }
        super.addInformation(stack, tooltip, advanced);
    }

    @Override
    public void updateEntityServer() {
        super.updateEntityServer();
        if (this.cathodeslot.isEmpty() || this.anodeslot.isEmpty()) {
            if (this.getActive()) {
                this.setActive(false);
                this.initiate(2);
            }
            return;
        }
        boolean drain = false;
        boolean drain1 = false;
        if (this.getFluidTank(0).getFluidAmount() >= 3 && this.energy.getEnergy() >= 25.0) {
            int size = this.getFluidTank(0).getFluidAmount() / 3;
            size = Math.min(this.level + 1, size);
            int cap = this.fluidTank[1].getCapacity() - this.fluidTank[1].getFluidAmount();
            cap /= 2;
            cap = Math.min(cap, size);
            int cap1 = this.fluidTank[2].getCapacity() - this.fluidTank[2].getFluidAmount();
            cap1 = Math.min(cap1, size);
            if (this.fluidTank[1].getCapacity() - this.fluidTank[1].getFluidAmount() >= 3) {
                this.fill(new FluidStack(FluidName.fluidhyd.getInstance(), cap * 2), true);
                drain = true;
            }
            if (this.fluidTank[2].getCapacity() - this.fluidTank[2].getFluidAmount() >= 2) {
                this.fill(new FluidStack(FluidName.fluidoxy.getInstance(), cap1), true);
                drain1 = true;
            }
            if (drain || drain1) {
                int drains = 0;
                drains = drain ? drains + 2 * cap : drains;
                drains = drain1 ? drains + cap1 : drains;
                this.getFluidTank(0).drain(drains, true);
                if (!this.getActive()) {
                    this.setActive(true);
                    this.initiate(0);
                }
                this.energy.useEnergy(25.0);
                this.setActive(true);
                ItemStack cathode = this.cathodeslot.get();
                ItemStack anode = this.anodeslot.get();
                if (cathode.func_77952_i() < cathode.func_77958_k()) {
                    cathode.func_77964_b(cathode.func_77952_i() + 1);
                }
                if (anode.func_77952_i() < anode.func_77958_k()) {
                    anode.func_77964_b(anode.func_77952_i() + 1);
                }
                if (cathode.func_77952_i() == cathode.func_77958_k()) {
                    this.cathodeslot.consume(1);
                }
                if (anode.func_77952_i() == anode.func_77958_k()) {
                    this.anodeslot.consume(1);
                }
            } else {
                this.setActive(false);
            }
        } else {
            this.setActive(false);
        }
    }

    @Override
    public int getLevel() {
        return this.level;
    }

    @Override
    public void setLevel(int level) {
        this.level = level;
    }

    @Override
    public void removeLevel(int level) {
        this.level -= level;
    }

    @Override
    public SoundEvent getSound() {
        return EnumSound.electrolyzer.getSoundEvent();
    }
}

