/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.tiles.base;

import com.denfop.IUItem;
import com.denfop.api.Recipes;
import com.denfop.api.recipe.BaseMachineRecipe;
import com.denfop.api.recipe.IHasRecipe;
import com.denfop.api.recipe.IUpdateTick;
import com.denfop.api.recipe.Input;
import com.denfop.api.recipe.InvSlotRecipes;
import com.denfop.api.recipe.MachineRecipe;
import com.denfop.api.recipe.RecipeOutput;
import com.denfop.api.tile.IMultiTileBlock;
import com.denfop.api.upgrades.IUpgradableBlock;
import com.denfop.api.upgrades.UpgradableProperty;
import com.denfop.blocks.BlockTileEntity;
import com.denfop.blocks.mechanism.BlockConverterMatter;
import com.denfop.container.ContainerConverterSolidMatter;
import com.denfop.gui.GuiConverterSolidMatter;
import com.denfop.invslot.InvSlotConverterSolidMatter;
import com.denfop.invslot.InvSlotUpgrade;
import com.denfop.network.DecoderHandler;
import com.denfop.network.EncoderHandler;
import com.denfop.network.packet.CustomPacketBuffer;
import com.denfop.recipe.IInputHandler;
import com.denfop.tiles.base.TileElectricMachine;
import com.denfop.tiles.base.TileEntityInventory;
import com.denfop.utils.ModUtils;
import com.denfop.utils.Precision;
import java.io.IOException;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.OreDictionary;

public class TileConverterSolidMatter
extends TileElectricMachine
implements IUpgradableBlock,
IUpdateTick,
IHasRecipe {
    public final InvSlotConverterSolidMatter MatterSlot;
    public final InvSlotRecipes inputSlot;
    public final InvSlotUpgrade upgradeSlot;
    public final int defaultOperationLength;
    public final int defaultEnergyConsume;
    public double[] quantitysolid = new double[8];
    public int energyConsume = 2;
    public double defaultEnergyStorage = 50000.0;
    public double progress = 0.0;
    public double guiProgress = 0.0;
    public int operationLength = 100;
    public int operationsPerTick;
    public MachineRecipe output;
    public boolean required = false;
    public double[] outputmatter = new double[9];

    public TileConverterSolidMatter() {
        super(50000.0, 14, 1);
        this.MatterSlot = new InvSlotConverterSolidMatter(this);
        this.upgradeSlot = new InvSlotUpgrade(this, 3);
        this.inputSlot = new InvSlotRecipes((TileEntityInventory)this, "converter", (IUpdateTick)this);
        this.defaultOperationLength = 100;
        this.defaultEnergyConsume = 2;
        Recipes.recipes.addInitRecipes(this);
    }

    public static void addrecipe(ItemStack stack, double matter, double sunmatter, double aquamatter, double nethermatter, double nightmatter, double earthmatter, double endmatter, double aermatter) {
        NBTTagCompound nbt = new NBTTagCompound();
        double[] quantitysolid = new double[]{Precision.round(matter, 2), Precision.round(sunmatter, 2), Precision.round(aquamatter, 2), Precision.round(nethermatter, 2), Precision.round(nightmatter, 2), Precision.round(earthmatter, 2), Precision.round(endmatter, 2), Precision.round(aermatter, 2)};
        for (int i = 0; i < quantitysolid.length; ++i) {
            ModUtils.SetDoubleWithoutItem(nbt, "quantitysolid_" + i, quantitysolid[i]);
        }
        IInputHandler input = Recipes.inputFactory;
        if (stack.func_190926_b()) {
            return;
        }
        int[] i = OreDictionary.getOreIDs((ItemStack)stack);
        if (i.length < 1) {
            Recipes.recipes.addRecipe("converter", new BaseMachineRecipe(new Input(input.getInput(stack)), new RecipeOutput(nbt, stack)));
        } else {
            Recipes.recipes.addRecipe("converter", new BaseMachineRecipe(new Input(input.getInput(OreDictionary.getOreName((int)i[0]))), new RecipeOutput(nbt, stack)));
        }
    }

    @Override
    public void readContainerPacket(CustomPacketBuffer customPacketBuffer) {
        super.readContainerPacket(customPacketBuffer);
        try {
            this.progress = (Double)DecoderHandler.decode(customPacketBuffer);
            this.quantitysolid = (double[])DecoderHandler.decode(customPacketBuffer);
            this.guiProgress = (Double)DecoderHandler.decode(customPacketBuffer);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public CustomPacketBuffer writeContainerPacket() {
        CustomPacketBuffer packet = super.writeContainerPacket();
        try {
            EncoderHandler.encode(packet, this.progress);
            EncoderHandler.encode(packet, this.quantitysolid);
            EncoderHandler.encode(packet, this.guiProgress);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return packet;
    }

    @Override
    public IMultiTileBlock getTeBlock() {
        return BlockConverterMatter.converter_matter;
    }

    @Override
    public BlockTileEntity getBlock() {
        return IUItem.convertersolidmatter;
    }

    @Override
    public boolean func_94041_b(int index, ItemStack stack) {
        return super.func_94041_b(index, stack);
    }

    @Override
    public boolean func_180462_a(int index, @Nonnull ItemStack stack, @Nonnull EnumFacing side) {
        return super.func_180462_a(index, stack, side);
    }

    @Override
    public void init() {
        int i;
        TileConverterSolidMatter.addrecipe(new ItemStack(Blocks.field_150348_b), 0.2, 0.0, 0.0, 0.0, 0.0, 0.15, 0.0, 0.0);
        TileConverterSolidMatter.addrecipe(new ItemStack(Blocks.field_150347_e), 0.1, 0.0, 0.0, 0.0, 0.0, 0.05, 0.0, 0.0);
        TileConverterSolidMatter.addrecipe(new ItemStack(Blocks.field_150424_aL), 0.1, 0.0, 0.0, 0.05, 0.0, 0.0, 0.0, 0.0);
        TileConverterSolidMatter.addrecipe(new ItemStack((Block)Blocks.field_150349_c), 0.5, 0.0, 0.0, 0.0, 0.0, 4.0, 0.0, 1.0);
        TileConverterSolidMatter.addrecipe(new ItemStack(Blocks.field_150351_n), 0.5, 0.0, 0.0, 0.0, 0.0, 0.5, 0.0, 0.0);
        TileConverterSolidMatter.addrecipe(new ItemStack(Blocks.field_150352_o), 1.0, 0.0, 0.0, 0.0, 0.0, 4.0, 0.0, 0.0);
        TileConverterSolidMatter.addrecipe(new ItemStack(Blocks.field_150365_q), 1.0, 0.0, 0.0, 0.0, 0.0, 2.0, 0.0, 0.0);
        TileConverterSolidMatter.addrecipe(new ItemStack(Blocks.field_150340_R), 180.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
        TileConverterSolidMatter.addrecipe(new ItemStack(Blocks.field_150339_S), 24.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
        TileConverterSolidMatter.addrecipe(new ItemStack(Items.field_151043_k), 20.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
        TileConverterSolidMatter.addrecipe(new ItemStack(Items.field_151042_j), 2.67, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
        TileConverterSolidMatter.addrecipe(new ItemStack(Items.field_151045_i), 50.0, 0.0, 10.0, 0.0, 0.0, 40.0, 0.0, 0.0);
        TileConverterSolidMatter.addrecipe(new ItemStack(Items.field_151166_bC), 70.0, 0.0, 10.0, 0.0, 0.0, 40.0, 0.0, 200.0);
        TileConverterSolidMatter.addrecipe(new ItemStack(Blocks.field_150484_ah), 500.0, 0.0, 100.0, 0.0, 0.0, 400.0, 0.0, 0.0);
        TileConverterSolidMatter.addrecipe(new ItemStack(Blocks.field_150475_bE), 700.0, 0.0, 100.0, 0.0, 0.0, 400.0, 0.0, 200.0);
        TileConverterSolidMatter.addrecipe(new ItemStack(Items.field_151044_h), 1.5, 0.0, 0.0, 0.0, 0.0, 0.55, 0.0, 0.0);
        TileConverterSolidMatter.addrecipe(new ItemStack(Items.field_151100_aR, 1, 4), 5.0, 0.0, 0.0, 0.0, 1.0, 7.0, 0.0, 0.0);
        TileConverterSolidMatter.addrecipe(new ItemStack(Items.field_151137_ax, 1), 0.5, 0.5, 0.0, 0.0, 0.0, 1.7, 0.0, 0.0);
        TileConverterSolidMatter.addrecipe(new ItemStack(Blocks.field_150402_ci), 15.0, 0.0, 0.0, 0.0, 0.0, 4.0, 0.0, 0.0);
        TileConverterSolidMatter.addrecipe(new ItemStack(Items.field_151007_F), 150.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 200.0);
        TileConverterSolidMatter.addrecipe(new ItemStack(Items.field_151116_aA), 150.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 50.0);
        TileConverterSolidMatter.addrecipe(new ItemStack(Items.field_151123_aH), 100.0, 0.0, 200.0, 0.0, 0.0, 0.0, 0.0, 0.0);
        TileConverterSolidMatter.addrecipe(new ItemStack(Items.field_151072_bj), 100.0, 0.0, 0.0, 1000.0, 500.0, 0.0, 0.0, 0.0);
        TileConverterSolidMatter.addrecipe(new ItemStack(Items.field_151103_aS), 20.0, 0.0, 0.0, 0.0, 100.0, 0.0, 0.0, 0.0);
        TileConverterSolidMatter.addrecipe(new ItemStack(Items.field_151100_aR), 20.0, 40.0, 40.0, 0.0, 0.0, 0.0, 0.0, 0.0);
        TileConverterSolidMatter.addrecipe(new ItemStack(Items.field_151145_ak), 1.0, 0.0, 0.0, 0.0, 0.0, 0.25, 0.0, 0.0);
        TileConverterSolidMatter.addrecipe(new ItemStack(Blocks.field_150425_aM), 0.0, 0.0, 0.0, 150.0, 50.0, 0.0, 0.0, 0.0);
        TileConverterSolidMatter.addrecipe(new ItemStack(Blocks.field_150385_bj), 0.0, 0.0, 0.0, 250.0, 100.0, 0.0, 0.0, 0.0);
        TileConverterSolidMatter.addrecipe(new ItemStack(Items.field_151119_aD), 0.0, 0.0, 40.0, 0.0, 0.0, 0.0, 0.0, 20.0);
        TileConverterSolidMatter.addrecipe(new ItemStack(Items.field_151118_aC), 0.0, 0.0, 40.0, 0.0, 0.0, 0.0, 0.0, 20.0);
        TileConverterSolidMatter.addrecipe(new ItemStack(Items.field_151130_bT), 0.0, 0.0, 40.0, 40.0, 0.0, 0.0, 0.0, 20.0);
        TileConverterSolidMatter.addrecipe(new ItemStack(Items.field_151016_H), 4.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
        TileConverterSolidMatter.addrecipe(new ItemStack(Blocks.field_150368_y), 50.0, 0.0, 0.0, 0.0, 10.0, 60.0, 0.0, 0.0);
        TileConverterSolidMatter.addrecipe(new ItemStack(Blocks.field_150451_bX), 5.0, 5.0, 0.0, 0.0, 0.0, 15.0, 0.0, 0.0);
        TileConverterSolidMatter.addrecipe(new ItemStack(Blocks.field_150371_ca), 30.0, 0.0, 0.0, 300.0, 20.0, 0.0, 0.0, 0.0);
        TileConverterSolidMatter.addrecipe(new ItemStack(Items.field_151128_bU), 7.5, 0.0, 0.0, 75.0, 5.0, 0.0, 0.0, 0.0);
        TileConverterSolidMatter.addrecipe(new ItemStack(Items.field_151055_y), 2.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
        TileConverterSolidMatter.addrecipe(new ItemStack(Blocks.field_150344_f), 10.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 2.0);
        TileConverterSolidMatter.addrecipe(new ItemStack(Blocks.field_150344_f, 1, 1), 10.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 2.0);
        TileConverterSolidMatter.addrecipe(new ItemStack(Blocks.field_150344_f, 1, 2), 10.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 2.0);
        TileConverterSolidMatter.addrecipe(new ItemStack(Blocks.field_150344_f, 1, 3), 10.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 2.0);
        TileConverterSolidMatter.addrecipe(new ItemStack(Blocks.field_150344_f, 1, 4), 10.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 2.0);
        TileConverterSolidMatter.addrecipe(new ItemStack(Blocks.field_150344_f, 1, 5), 10.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 2.0);
        TileConverterSolidMatter.addrecipe(new ItemStack(Blocks.field_150423_aK), 1000.0, 1000.0, 1000.0, 0.0, 0.0, 0.0, 0.0, 2000.0);
        TileConverterSolidMatter.addrecipe(new ItemStack(Blocks.field_150440_ba), 1000.0, 1000.0, 1000.0, 0.0, 0.0, 0.0, 0.0, 2000.0);
        TileConverterSolidMatter.addrecipe(new ItemStack(Items.field_151015_O), 1000.0, 2000.0, 500.0, 0.0, 0.0, 0.0, 0.0, 2000.0);
        TileConverterSolidMatter.addrecipe(new ItemStack(Items.field_151120_aE), 300.0, 200.0, 500.0, 0.0, 0.0, 0.0, 0.0, 500.0);
        TileConverterSolidMatter.addrecipe(new ItemStack(Items.field_151008_G), 300.0, 200.0, 500.0, 0.0, 0.0, 0.0, 0.0, 500.0);
        TileConverterSolidMatter.addrecipe(new ItemStack(Blocks.field_150325_L), 600.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 800.0);
        TileConverterSolidMatter.addrecipe(new ItemStack(Items.field_151075_bm), 1000.0, 0.0, 0.0, 2500.0, 2000.0, 0.0, 0.0, 0.0);
        TileConverterSolidMatter.addrecipe(new ItemStack(Blocks.field_150426_aN), 30.0, 20.0, 0.0, 300.0, 20.0, 0.0, 0.0, 0.0);
        TileConverterSolidMatter.addrecipe(new ItemStack(Blocks.field_150359_w), 2.0, 0.0, 0.5, 0.0, 0.0, 0.0, 0.0, 0.0);
        TileConverterSolidMatter.addrecipe(new ItemStack(Blocks.field_150377_bs), 0.5, 0.0, 0.0, 0.0, 0.0, 0.0, 0.25, 0.0);
        TileConverterSolidMatter.addrecipe(new ItemStack(Items.field_151114_aO), 7.5, 5.0, 0.0, 75.0, 5.0, 0.0, 0.0, 0.0);
        TileConverterSolidMatter.addrecipe(IUItem.copperBlock, 8.0, 0.0, 0.0, 0.0, 0.0, 4.0, 0.0, 0.0);
        TileConverterSolidMatter.addrecipe(IUItem.tinBlock, 10.0, 0.0, 0.0, 0.0, 0.0, 4.0, 0.0, 0.0);
        TileConverterSolidMatter.addrecipe(IUItem.bronzeBlock, 10.0, 0.0, 0.0, 0.0, 0.0, 4.0, 0.0, 0.0);
        TileConverterSolidMatter.addrecipe(IUItem.advironblock, 20.0, 0.0, 0.0, 0.0, 0.0, 8.0, 0.0, 0.0);
        TileConverterSolidMatter.addrecipe(IUItem.uraniumBlock, 15.0, 0.0, 0.0, 0.0, 0.0, 8.0, 0.0, 0.0);
        TileConverterSolidMatter.addrecipe(IUItem.leadBlock, 80.0, 0.0, 0.0, 0.0, 0.0, 40.0, 0.0, 0.0);
        TileConverterSolidMatter.addrecipe(IUItem.copperIngot, 0.8888888888888888, 0.0, 0.0, 0.0, 0.0, 0.4444444444444444, 0.0, 0.0);
        TileConverterSolidMatter.addrecipe(IUItem.tinIngot, 1.1111111111111112, 0.0, 0.0, 0.0, 0.0, 0.4444444444444444, 0.0, 0.0);
        TileConverterSolidMatter.addrecipe(IUItem.bronzeIngot, 1.1111111111111112, 0.0, 0.0, 0.0, 0.0, 0.4444444444444444, 0.0, 0.0);
        TileConverterSolidMatter.addrecipe(IUItem.advIronIngot, 2.2222222222222223, 0.0, 0.0, 0.0, 0.0, 0.8888888888888888, 0.0, 0.0);
        TileConverterSolidMatter.addrecipe(new ItemStack(IUItem.itemiu, 1, 2), 1.6666666666666667, 0.0, 0.0, 0.0, 0.0, 0.8888888888888888, 0.0, 0.0);
        TileConverterSolidMatter.addrecipe(IUItem.leadIngot, 8.88888888888889, 0.0, 0.0, 0.0, 0.0, 4.444444444444445, 0.0, 0.0);
        TileConverterSolidMatter.addrecipe(IUItem.platecopper, 0.8888888888888888, 0.0, 0.0, 0.0, 0.0, 0.4444444444444444, 0.0, 0.0);
        TileConverterSolidMatter.addrecipe(IUItem.platetin, 1.1111111111111112, 0.0, 0.0, 0.0, 0.0, 0.4444444444444444, 0.0, 0.0);
        TileConverterSolidMatter.addrecipe(IUItem.platebronze, 1.1111111111111112, 0.0, 0.0, 0.0, 0.0, 0.4444444444444444, 0.0, 0.0);
        TileConverterSolidMatter.addrecipe(IUItem.plateadviron, 2.2222222222222223, 0.0, 0.0, 0.0, 0.0, 0.8888888888888888, 0.0, 0.0);
        TileConverterSolidMatter.addrecipe(IUItem.platelead, 8.88888888888889, 0.0, 0.0, 0.0, 0.0, 4.444444444444445, 0.0, 0.0);
        TileConverterSolidMatter.addrecipe(IUItem.casingcopper, 0.4444444444444444, 0.0, 0.0, 0.0, 0.0, 0.2222222222222222, 0.0, 0.0);
        TileConverterSolidMatter.addrecipe(IUItem.casingtin, 0.5555555555555556, 0.0, 0.0, 0.0, 0.0, 0.2222222222222222, 0.0, 0.0);
        TileConverterSolidMatter.addrecipe(IUItem.casingbronze, 0.5555555555555556, 0.0, 0.0, 0.0, 0.0, 0.2222222222222222, 0.0, 0.0);
        TileConverterSolidMatter.addrecipe(IUItem.casingadviron, 1.1111111111111112, 0.0, 0.0, 0.0, 0.0, 0.4444444444444444, 0.0, 0.0);
        TileConverterSolidMatter.addrecipe(IUItem.casinglead, 4.444444444444445, 0.0, 0.0, 0.0, 0.0, 2.2222222222222223, 0.0, 0.0);
        TileConverterSolidMatter.addrecipe(IUItem.copperCableItem, 0.4444444444444444, 0.0, 0.0, 0.0, 0.0, 0.2222222222222222, 0.0, 0.0);
        TileConverterSolidMatter.addrecipe(IUItem.tinCableItem, 0.37037037037037035, 0.0, 0.0, 0.0, 0.0, 0.14814814814814814, 0.0, 0.0);
        TileConverterSolidMatter.addrecipe(IUItem.goldCableItem, 5.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
        TileConverterSolidMatter.addrecipe(IUItem.ironCableItem, 0.6675, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
        TileConverterSolidMatter.addrecipe(IUItem.plategold, 20.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
        TileConverterSolidMatter.addrecipe(IUItem.plateiron, 2.67, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
        TileConverterSolidMatter.addrecipe(IUItem.rubber, 150.0, 0.0, 40.0, 0.0, 0.0, 0.0, 0.0, 50.0);
        TileConverterSolidMatter.addrecipe(new ItemStack(Items.field_151079_bi), 0.0, 0.0, 0.0, 0.0, 250.0, 0.0, 2000.0, 0.0);
        TileConverterSolidMatter.addrecipe(new ItemStack(Blocks.field_150343_Z), 0.0, 0.0, 0.0, 0.0, 30.0, 10.0, 10.0, 0.0);
        for (i = 0; i < IUItem.name_mineral.size(); ++i) {
            TileConverterSolidMatter.addrecipe(new ItemStack(IUItem.iuingot, 1, i), 12.0, 0.0, 0.0, 0.0, 0.0, 36.0, 0.0, 0.0);
        }
        for (i = 0; i < IUItem.name_mineral.size(); ++i) {
            TileConverterSolidMatter.addrecipe(new ItemStack(IUItem.stik, 1, i), 6.0, 0.0, 0.0, 0.0, 0.0, 18.0, 0.0, 0.0);
        }
        for (i = 0; i < IUItem.name_mineral.size(); ++i) {
            TileConverterSolidMatter.addrecipe(new ItemStack(IUItem.plate, 1, i), 12.0, 0.0, 0.0, 0.0, 0.0, 36.0, 0.0, 0.0);
        }
        for (i = 0; i < IUItem.name_mineral.size(); ++i) {
            TileConverterSolidMatter.addrecipe(new ItemStack(IUItem.doubleplate, 1, i), 108.0, 0.0, 0.0, 0.0, 0.0, 288.0, 0.0, 0.0);
        }
        for (i = 0; i < IUItem.name_mineral.size(); ++i) {
            TileConverterSolidMatter.addrecipe(new ItemStack(IUItem.casing, 1, i), 6.0, 0.0, 0.0, 0.0, 0.0, 18.0, 0.0, 0.0);
        }
        IUItem.machineRecipe = Recipes.recipes.getRecipeStack("converter");
    }

    public void setOverclockRates() {
        this.operationsPerTick = this.upgradeSlot.getOperationsPerTick(this.defaultOperationLength);
        this.operationLength = this.upgradeSlot.getOperationLength(this.defaultOperationLength);
    }

    public double getProgress() {
        return this.guiProgress;
    }

    @Override
    public void updateEntityServer() {
        super.updateEntityServer();
        MachineRecipe output = this.output;
        if (output != null && this.outputSlot.canAdd(this.output.getRecipe().output.items) && !this.inputSlot.isEmpty() && this.required) {
            double p;
            if (!this.getActive()) {
                this.setActive(true);
            }
            if (this.field_145850_b.field_73011_w.getWorldTime() % 20L == 0L) {
                this.MatterSlot.getmatter();
            }
            if (this.useEnergy(this.energyConsume, false) && this.required) {
                this.progress += 1.0;
                this.useEnergy(this.energyConsume, true);
            }
            if ((p = this.progress / (double)this.operationLength) <= 1.0) {
                this.guiProgress = p;
            }
            if (p > 1.0) {
                this.guiProgress = 1.0;
            }
            if (this.progress >= (double)this.operationLength && this.required) {
                this.operate(output);
                this.progress = 0.0;
            }
        } else if (this.getActive()) {
            this.setActive(false);
        }
        if (this.upgradeSlot.tickNoMark()) {
            this.setOverclockRates();
        }
    }

    private void useMatter() {
        for (int i = 0; i < this.quantitysolid.length; ++i) {
            int n = i;
            this.quantitysolid[n] = this.quantitysolid[n] - this.outputmatter[i];
        }
    }

    public void getrequiredmatter(RecipeOutput output) {
        if (output == null) {
            this.required = false;
            return;
        }
        for (int i = 0; i < this.quantitysolid.length; ++i) {
            if (this.quantitysolid[i] >= this.outputmatter[i]) continue;
            this.required = false;
            return;
        }
        this.required = true;
    }

    public void operate(MachineRecipe output) {
        List<ItemStack> processResult = output.getRecipe().output.items;
        this.operateOnce(processResult);
    }

    public void operateOnce(List<ItemStack> processResult) {
        this.useMatter();
        this.outputSlot.add(processResult);
        this.getrequiredmatter(this.output.getRecipe().getOutput());
    }

    @Override
    public void onLoaded() {
        super.onLoaded();
        this.inputSlot.load();
        this.getOutput();
        if (this.output != null) {
            for (int i = 0; i < this.quantitysolid.length; ++i) {
                this.outputmatter[i] = this.output.getRecipe().output.metadata.func_74769_h("quantitysolid_" + i);
            }
            this.getrequiredmatter(this.output.getRecipe().getOutput());
        } else {
            this.getrequiredmatter(null);
        }
        this.MatterSlot.getmatter();
    }

    public MachineRecipe getOutput() {
        this.output = this.inputSlot.process();
        return this.output;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbttagcompound) {
        super.func_145839_a(nbttagcompound);
        this.progress = nbttagcompound.func_74769_h("progress");
        for (int i = 0; i < this.quantitysolid.length; ++i) {
            this.quantitysolid[i] = nbttagcompound.func_74769_h("quantitysolid" + i);
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean shouldSideBeRendered(EnumFacing side, BlockPos otherPos) {
        return false;
    }

    @Override
    public boolean isNormalCube() {
        return false;
    }

    @Override
    public boolean doesSideBlockRendering(EnumFacing side) {
        return false;
    }

    @Override
    public boolean isSideSolid(EnumFacing side) {
        return false;
    }

    @Override
    public boolean clientNeedsExtraModelInfo() {
        return true;
    }

    public boolean shouldRenderInPass(int pass) {
        return true;
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbttagcompound) {
        super.func_189515_b(nbttagcompound);
        nbttagcompound.func_74780_a("progress", this.progress);
        for (int i = 0; i < this.quantitysolid.length; ++i) {
            nbttagcompound.func_74780_a("quantitysolid" + i, this.quantitysolid[i]);
        }
        return nbttagcompound;
    }

    public boolean useEnergy(double amount, boolean consume) {
        if (this.energy.canUseEnergy(amount)) {
            if (consume) {
                this.energy.useEnergy(amount);
            }
            return true;
        }
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public GuiConverterSolidMatter getGui(EntityPlayer entityPlayer, boolean isAdmin) {
        return new GuiConverterSolidMatter(new ContainerConverterSolidMatter(entityPlayer, this));
    }

    public ContainerConverterSolidMatter getGuiContainer(EntityPlayer entityPlayer) {
        return new ContainerConverterSolidMatter(entityPlayer, this);
    }

    public float getWrenchDropRate() {
        return 0.85f;
    }

    @Override
    public Set<UpgradableProperty> getUpgradableProperties() {
        return EnumSet.of(UpgradableProperty.Processing, UpgradableProperty.Transformer, UpgradableProperty.EnergyStorage, UpgradableProperty.ItemConsuming, UpgradableProperty.ItemProducing);
    }

    @Override
    public void onUpdate() {
        if (this.output != null) {
            for (int i = 0; i < this.quantitysolid.length; ++i) {
                this.outputmatter[i] = this.output.getRecipe().output.metadata.func_74769_h("quantitysolid_" + i);
            }
        }
        if (this.output == null) {
            this.getrequiredmatter(null);
        } else {
            this.getrequiredmatter(this.output.getRecipe().getOutput());
        }
        this.MatterSlot.getmatter();
    }

    @Override
    public MachineRecipe getRecipeOutput() {
        return this.output;
    }

    @Override
    public void setRecipeOutput(MachineRecipe output) {
        this.output = output;
    }

    @Override
    public SoundEvent getSound() {
        return null;
    }
}

