/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.tiles.base;

import com.denfop.IUItem;
import com.denfop.Localization;
import com.denfop.api.upgrades.IUpgradableBlock;
import com.denfop.api.upgrades.UpgradableProperty;
import com.denfop.blocks.FluidName;
import com.denfop.blocks.MultiTileBlock;
import com.denfop.componets.Fluids;
import com.denfop.invslot.InvSlot;
import com.denfop.invslot.InvSlotDrainTank;
import com.denfop.invslot.InvSlotFluid;
import com.denfop.invslot.InvSlotTank;
import com.denfop.invslot.InvSlotUpgrade;
import com.denfop.network.DecoderHandler;
import com.denfop.network.packet.CustomPacketBuffer;
import com.denfop.network.packet.PacketUpdateFieldTile;
import com.denfop.tiles.base.TileElectricMachine;
import com.denfop.utils.ModUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class TileBaseLiquedMachine
extends TileElectricMachine
implements IFluidHandler,
IUpgradableBlock {
    public final boolean[] drain;
    public final boolean[] fill;
    public final InvSlotUpgrade upgradeSlot;
    public final Fluids fluids;
    public final InvSlotDrainTank[] containerslot;
    public final InvSlotTank[] fluidSlot;
    public final Fluid[] fluid;
    public final int[] old_amount;
    public FluidTank[] fluidTank;
    public int level;

    public TileBaseLiquedMachine(double MaxEnergy, int tier, int count, int count_tank, boolean[] drain, boolean[] fill, Fluid[] name1) {
        super(MaxEnergy, tier, count);
        int i;
        this.fluidTank = new FluidTank[count_tank];
        this.drain = drain;
        this.fill = fill;
        this.fluids = this.addComponent(new Fluids(this));
        this.old_amount = new int[count_tank];
        this.fluid = name1;
        this.tier = tier;
        this.level = 0;
        for (int i2 = 0; i2 < this.fluidTank.length; ++i2) {
            this.fluidTank[i2] = this.fluids.addTank("fluidTank" + i2, 8000, i2 == 0 ? InvSlot.TypeItemSlot.INPUT : InvSlot.TypeItemSlot.OUTPUT, i2 == 0 && name1[i2].getName().equals(FluidName.fluidneft.getInstance().getName()) ? Fluids.fluidPredicate(name1[i2], FluidRegistry.getFluid((String)"oil_heavy"), FluidRegistry.getFluid((String)"oil_heavy_heat_1"), FluidRegistry.getFluid((String)"oil_heavy_heat_2"), FluidRegistry.getFluid((String)"oil_heat_2"), FluidRegistry.getFluid((String)"oil_heat_1"), FluidRegistry.getFluid((String)"oil"), FluidRegistry.getFluid((String)"fluid_cride_oil"), FluidRegistry.getFluid((String)"refined_oil"), FluidRegistry.getFluid((String)"crude_oil")) : Fluids.fluidPredicate(name1[i2]));
        }
        this.upgradeSlot = new InvSlotUpgrade(this, 4);
        Fluid[] fluid = this.getFluids(drain, name1);
        this.containerslot = new InvSlotDrainTank[fluid.length];
        for (i = 0; i < fluid.length; ++i) {
            this.containerslot[i] = new InvSlotDrainTank(this, InvSlot.TypeItemSlot.INPUT, 1, InvSlotFluid.TypeFluidSlot.OUTPUT, fluid[i]);
        }
        this.fluidSlot = new InvSlotTank[1];
        for (i = 0; i < this.fluidSlot.length; ++i) {
            this.fluidSlot[i] = new InvSlotTank(this, InvSlot.TypeItemSlot.INPUT, 1, InvSlotFluid.TypeFluidSlot.INPUT, (IFluidTank)this.fluidTank[0]);
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void addInformation(ItemStack stack, List<String> tooltip, ITooltipFlag advanced) {
        if (stack.func_77942_o()) {
            NBTTagCompound nbt = ModUtils.nbt(stack);
            int size = nbt.func_74762_e("size");
            ArrayList<FluidStack> fluidStackList = new ArrayList<FluidStack>();
            for (int i = 0; i < size; ++i) {
                FluidStack fluidStack = FluidStack.loadFluidStackFromNBT((NBTTagCompound)((NBTTagCompound)stack.func_77978_p().func_74781_a("fluid" + i)));
                if (fluidStack == null) continue;
                fluidStackList.add(fluidStack);
            }
            if (fluidStackList.isEmpty()) {
                super.addInformation(stack, tooltip, advanced);
                return;
            }
            if (fluidStackList.size() == 1) {
                tooltip.add(Localization.translate("iu.fluid.info") + ((FluidStack)fluidStackList.get(0)).getLocalizedName());
                tooltip.add(Localization.translate("iu.fluid.info1") + ((FluidStack)fluidStackList.get((int)0)).amount / 1000 + " B");
            } else {
                tooltip.add(Localization.translate("iu.fluid.info2"));
                for (FluidStack fluidStack : fluidStackList) {
                    tooltip.add(fluidStack.getLocalizedName() + " " + fluidStack.amount / 1000 + " B");
                }
            }
            super.addInformation(stack, tooltip, advanced);
            return;
        }
        super.addInformation(stack, tooltip, advanced);
    }

    @Override
    public void onPlaced(ItemStack stack, EntityLivingBase placer, EnumFacing facing) {
        super.onPlaced(stack, placer, facing);
        if (stack.func_77942_o()) {
            NBTTagCompound nbt = ModUtils.nbt(stack);
            int size = nbt.func_74762_e("size");
            for (int i = 0; i < size; ++i) {
                FluidStack fluidStack = FluidStack.loadFluidStackFromNBT((NBTTagCompound)((NBTTagCompound)stack.func_77978_p().func_74781_a("fluid" + i)));
                if (fluidStack == null) continue;
                this.fluidTank[i].fill(fluidStack, true);
            }
            new PacketUpdateFieldTile(this, "fluidTank", this.fluidTank);
        }
    }

    @Override
    public void updateField(String name, CustomPacketBuffer is) {
        if (name.equals("fluidTank")) {
            try {
                FluidTank[] fluidTanks = (FluidTank[])DecoderHandler.decode(is);
                for (int i = 0; i < fluidTanks.length; ++i) {
                    this.fluidTank[i].readFromNBT(fluidTanks[i].writeToNBT(new NBTTagCompound()));
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        super.updateField(name, is);
    }

    @Override
    public ItemStack adjustDrop(ItemStack drop, boolean wrench) {
        drop = super.adjustDrop(drop, wrench);
        if (wrench || this.teBlock.getDefaultDrop() == MultiTileBlock.DefaultDrop.Self) {
            NBTTagCompound nbt = ModUtils.nbt(drop);
            nbt.func_74768_a("size", this.fluidTank.length);
            for (int i = 0; i < this.fluidTank.length; ++i) {
                if (this.fluidTank[i].getFluidAmount() <= 0) continue;
                nbt.func_74782_a("fluid" + i, (NBTBase)this.fluidTank[i].getFluid().writeToNBT(new NBTTagCompound()));
            }
        }
        return drop;
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbttagcompound) {
        super.func_189515_b(nbttagcompound);
        nbttagcompound.func_74768_a("level", this.level);
        return nbttagcompound;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbttagcompound) {
        super.func_145839_a(nbttagcompound);
        this.level = nbttagcompound.func_74762_e("level");
    }

    public FluidTank getFluidTank(int num) {
        return this.fluidTank[num];
    }

    public double gaugeLiquidScaled(double i, int num) {
        return this.fluidTank[num].getFluidAmount() <= 0 ? 0.0 : (double)this.fluidTank[num].getFluidAmount() * i / (double)this.fluidTank[num].getCapacity();
    }

    public Fluid[] getFluids(boolean[] drain, Fluid[] name) {
        ArrayList<Fluid> fluidlist = new ArrayList<Fluid>();
        for (boolean b : drain) {
            if (!b) continue;
            fluidlist.add(name[0]);
        }
        Fluid[] fluid = new Fluid[fluidlist.size()];
        for (int i = 0; i < fluidlist.size(); ++i) {
            fluid[i] = (Fluid)fluidlist.get(i);
        }
        return fluid;
    }

    @Override
    public void onLoaded() {
        super.onLoaded();
        if (!this.func_145831_w().field_72995_K) {
            this.setUpgradestat();
        }
    }

    @Override
    public void updateEntityServer() {
        super.updateEntityServer();
        boolean needsInvUpdate = false;
        for (FluidTank fluidTank : this.fluidTank) {
            if (fluidTank.equals(this.fluidTank[0])) continue;
            for (InvSlotDrainTank invSlotDrainTank : this.containerslot) {
                if (fluidTank.getFluidAmount() < 1000 || invSlotDrainTank.isEmpty()) continue;
                invSlotDrainTank.processFromTank((IFluidTank)fluidTank, this.outputSlot);
                needsInvUpdate = true;
            }
        }
        for (InvSlotTank invSlotTank : this.fluidSlot) {
            for (InvSlotDrainTank invSlotDrainTank : this.fluidTank) {
                if (!invSlotDrainTank.equals(this.fluidTank[0]) || invSlotDrainTank.getFluidAmount() + 1000 > invSlotDrainTank.getCapacity() || invSlotTank.get().func_190926_b() || !invSlotTank.processIntoTank((IFluidTank)invSlotDrainTank, this.outputSlot)) continue;
                needsInvUpdate = true;
            }
        }
        if (needsInvUpdate) {
            new PacketUpdateFieldTile(this, "fluidTank", this.fluidTank);
        }
        if (this.upgradeSlot.tickNoMark()) {
            this.setUpgradestat();
        }
    }

    public void setUpgradestat() {
        this.energy.setSinkTier(this.tier + this.upgradeSlot.extraTier);
    }

    public IFluidTankProperties[] getTankProperties() {
        IFluidTankProperties[] tankProperties = new IFluidTankProperties[this.fluidTank.length];
        for (int i = 0; i < this.fluidTank.length; ++i) {
            tankProperties[i] = this.fluidTank[i].getTankProperties()[0];
        }
        return tankProperties;
    }

    public int fill(FluidStack resource, boolean doFill) {
        for (int i = 0; i < this.fluidTank.length; ++i) {
            if (resource == null || !resource.getFluid().equals(this.fluid[i]) || this.fill[i] || this.fluidTank[i].getFluidAmount() < 0) continue;
            return this.fluidTank[i].fill(resource, doFill);
        }
        return 0;
    }

    @Override
    public boolean onActivated(EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (!this.func_145831_w().field_72995_K && FluidUtil.getFluidHandler((ItemStack)player.func_184586_b(hand)) != null) {
            return FluidUtil.interactWithFluidHandler((EntityPlayer)player, (EnumHand)hand, (IFluidHandler)((IFluidHandler)this.getComp(Fluids.class).getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, side)));
        }
        if (this.level < 10) {
            ItemStack stack = player.func_184586_b(hand);
            if (!stack.func_77973_b().equals(IUItem.upgrade_speed_creation)) {
                return super.onActivated(player, hand, side, hitX, hitY, hitZ);
            }
            stack.func_190918_g(1);
            ++this.level;
            return false;
        }
        return super.onActivated(player, hand, side, hitX, hitY, hitZ);
    }

    @Override
    public List<ItemStack> getWrenchDrops(EntityPlayer player, int fortune) {
        List<ItemStack> ret = super.getWrenchDrops(player, fortune);
        if (this.level != 0) {
            ret.add(new ItemStack((Item)IUItem.upgrade_speed_creation, this.level));
            this.level = 0;
        }
        return ret;
    }

    @Nullable
    public FluidStack drain(FluidStack resource, boolean doDrain) {
        for (int i = 1; i < this.fluidTank.length; ++i) {
            if (resource == null || !resource.isFluidEqual(this.fluidTank[i].getFluid()) || !this.drain[i] || this.fluidTank[i].getFluidAmount() <= 0) continue;
            return this.fluidTank[i].drain(resource.amount, doDrain);
        }
        return null;
    }

    @Nullable
    public FluidStack drain(int maxDrain, boolean doDrain) {
        for (int i = 1; i < this.fluidTank.length; ++i) {
            if (!this.drain[i] || this.fluidTank[i].getFluidAmount() <= 0) continue;
            return this.fluidTank[i].drain(maxDrain, doDrain);
        }
        return null;
    }

    @Override
    public Set<UpgradableProperty> getUpgradableProperties() {
        return EnumSet.of(UpgradableProperty.Transformer, UpgradableProperty.ItemConsuming, UpgradableProperty.ItemProducing, UpgradableProperty.FluidProducing, UpgradableProperty.FluidConsuming);
    }
}

