/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.tiles.base;

import com.denfop.componets.AdvEnergy;
import com.denfop.componets.Fluids;
import com.denfop.componets.HeatComponent;
import com.denfop.container.ContainerHeatMachine;
import com.denfop.gui.GuiHeatMachine;
import com.denfop.invslot.InvSlot;
import com.denfop.invslot.InvSlotFluid;
import com.denfop.invslot.InvSlotFluidByList;
import com.denfop.network.DecoderHandler;
import com.denfop.network.EncoderHandler;
import com.denfop.network.IUpdatableTileEvent;
import com.denfop.network.packet.CustomPacketBuffer;
import com.denfop.tiles.base.TileElectricMachine;
import com.denfop.tiles.base.TileEntityInventory;
import java.io.IOException;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.mutable.MutableObject;

public class TileBaseHeatMachine
extends TileElectricMachine
implements IUpdatableTileEvent {
    public final boolean hasFluid;
    public final HeatComponent heat;
    public short maxtemperature;
    public boolean auto;
    public FluidTank fluidTank;
    public Fluids fluids = null;
    public InvSlotFluid fluidSlot;
    public int coef = 1;
    public boolean work = true;

    public TileBaseHeatMachine(boolean hasFluid) {
        super(hasFluid ? 0.0 : 10000.0, 14, 1);
        this.hasFluid = hasFluid;
        this.fluidTank = new FluidTank(12000);
        if (this.hasFluid) {
            this.energy = this.addComponent(AdvEnergy.asBasicSink((TileEntityInventory)this, 0.0, 14));
        }
        if (this.hasFluid) {
            this.fluids = this.addComponent(new Fluids(this));
            this.fluidTank = this.fluids.addTank("fluidTank", 12000, InvSlot.TypeItemSlot.INPUT, Fluids.fluidPredicate(FluidRegistry.getFluid((String)"cryotheum"), FluidRegistry.getFluid((String)"petrotheum"), FluidRegistry.getFluid((String)"redstone"), FluidRegistry.getFluid((String)"ic2pahoehoe_lava"), FluidRegistry.LAVA, FluidRegistry.getFluid((String)"iufluiddizel"), FluidRegistry.getFluid((String)"iufluidbenz"), FluidRegistry.getFluid((String)"biocrude"), FluidRegistry.getFluid((String)"biofuel"), FluidRegistry.getFluid((String)"ic2biogas"), FluidRegistry.getFluid((String)"refined_biofuel"), FluidRegistry.getFluid((String)"ic2biomass"), FluidRegistry.getFluid((String)"biomass")));
            this.fluidSlot = new InvSlotFluidByList(this, InvSlot.TypeItemSlot.INPUT, 1, InvSlotFluid.TypeFluidSlot.INPUT, FluidRegistry.getFluid((String)"cryotheum"), FluidRegistry.getFluid((String)"petrotheum"), FluidRegistry.getFluid((String)"redstone"), FluidRegistry.getFluid((String)"ic2pahoehoe_lava"), FluidRegistry.LAVA, FluidRegistry.getFluid((String)"iufluiddizel"), FluidRegistry.getFluid((String)"iufluidbenz"), FluidRegistry.getFluid((String)"ic2biomass"), FluidRegistry.getFluid((String)"biocrude"), FluidRegistry.getFluid((String)"biofuel"), FluidRegistry.getFluid((String)"ic2biogas"), FluidRegistry.getFluid((String)"refined_biofuel"), FluidRegistry.getFluid((String)"biomass"));
        }
        this.maxtemperature = (short)1000;
        this.heat = this.addComponent(HeatComponent.asBasicSource(this, 1000.0));
        this.auto = false;
    }

    @Override
    public void readContainerPacket(CustomPacketBuffer customPacketBuffer) {
        super.readContainerPacket(customPacketBuffer);
        try {
            this.auto = (Boolean)DecoderHandler.decode(customPacketBuffer);
            this.maxtemperature = (Short)DecoderHandler.decode(customPacketBuffer);
            this.work = (Boolean)DecoderHandler.decode(customPacketBuffer);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public CustomPacketBuffer writeContainerPacket() {
        CustomPacketBuffer packet = super.writeContainerPacket();
        try {
            EncoderHandler.encode(packet, this.auto);
            EncoderHandler.encode(packet, this.maxtemperature);
            EncoderHandler.encode(packet, this.work);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return packet;
    }

    @Override
    public void onLoaded() {
        super.onLoaded();
        this.coef = (int)Math.max(Math.ceil(this.heat.storage / 2000.0), 1.0);
    }

    @Override
    public void updateTileServer(EntityPlayer entityPlayer, double i) {
        if (i == 0.0) {
            this.maxtemperature = (short)(this.maxtemperature + 1000);
            if (this.maxtemperature > 10000) {
                this.maxtemperature = (short)10000;
            }
            this.heat.setCapacity(this.maxtemperature);
        }
        if (i == 1.0) {
            this.maxtemperature = (short)(this.maxtemperature - 1000);
            if (this.maxtemperature < 1000) {
                this.maxtemperature = (short)1000;
            }
            this.heat.setCapacity(this.maxtemperature);
        }
        if (i == 2.0) {
            this.work = !this.work;
        }
    }

    @Override
    public void func_145839_a(NBTTagCompound nbttagcompound) {
        super.func_145839_a(nbttagcompound);
        this.fluidTank.readFromNBT(nbttagcompound.func_74775_l("fluidTank"));
        this.maxtemperature = nbttagcompound.func_74765_d("maxtemperature");
        this.auto = nbttagcompound.func_74767_n("auto");
        this.work = nbttagcompound.func_74767_n("work");
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbttagcompound) {
        super.func_189515_b(nbttagcompound);
        NBTTagCompound fluidTankTag = new NBTTagCompound();
        this.fluidTank.writeToNBT(fluidTankTag);
        nbttagcompound.func_74782_a("fluidTank", (NBTBase)fluidTankTag);
        nbttagcompound.func_74777_a("maxtemperature", this.maxtemperature);
        nbttagcompound.func_74757_a("auto", this.auto);
        nbttagcompound.func_74757_a("work", this.work);
        return nbttagcompound;
    }

    public boolean process() {
        if (!this.hasFluid ? this.energy != null && this.energy.getEnergy() < 50.0 : this.fluidTank.getFluid() == null || this.fluidTank.getFluidAmount() == 0) {
            return false;
        }
        short temp = (short)this.heat.getEnergy();
        if (temp >= this.maxtemperature) {
            return false;
        }
        if (this.heat.allow || this.work) {
            if (this.hasFluid) {
                if (this.getFluidTank().getFluidAmount() >= 1) {
                    this.heat.addEnergy(5.0);
                    this.getFluidTank().drain(this.coef, true);
                    return true;
                }
            } else if (this.energy.getEnergy() >= (double)(30 * this.coef)) {
                this.heat.addEnergy(5.0);
                this.energy.useEnergy(30 * this.coef);
                return true;
            }
        }
        return false;
    }

    @Override
    public void updateEntityServer() {
        boolean active;
        super.updateEntityServer();
        if (this.hasFluid) {
            MutableObject output = new MutableObject();
            if (this.fluidTank.getFluidAmount() + 1000 <= this.fluidTank.getCapacity() && this.fluidSlot.transferToTank((IFluidTank)this.fluidTank, (MutableObject<ItemStack>)output, true) && (output.getValue() == null || this.outputSlot.canAdd((ItemStack)output.getValue()))) {
                this.fluidSlot.transferToTank((IFluidTank)this.fluidTank, (MutableObject<ItemStack>)output, false);
                if (output.getValue() != null) {
                    this.outputSlot.add((ItemStack)output.getValue());
                }
            }
        }
        if ((active = this.process()) != this.getActive()) {
            this.setActive(active);
        }
        if (this.field_145850_b.field_73011_w.getWorldTime() % 60L == 0L && this.heat.getEnergy() > 0.0) {
            this.heat.useEnergy(1.0);
        }
    }

    public FluidTank getFluidTank() {
        return this.fluidTank;
    }

    public ContainerHeatMachine getGuiContainer(EntityPlayer entityPlayer) {
        return new ContainerHeatMachine(entityPlayer, this);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiScreen getGui(EntityPlayer entityPlayer, boolean b) {
        return new GuiHeatMachine(this.getGuiContainer(entityPlayer), b);
    }

    @Override
    public SoundEvent getSound() {
        return null;
    }
}

