/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.tiles.base;

import com.denfop.IUItem;
import com.denfop.Localization;
import com.denfop.api.tile.IMultiTileBlock;
import com.denfop.api.upgrade.UpgradeSystem;
import com.denfop.blocks.BlockTileEntity;
import com.denfop.blocks.mechanism.BlockBaseMachine3;
import com.denfop.container.ContainerAntiUpgrade;
import com.denfop.gui.GuiAntiUpgradeBlock;
import com.denfop.invslot.InvSlotAntiUpgradeBlock;
import com.denfop.network.DecoderHandler;
import com.denfop.network.EncoderHandler;
import com.denfop.network.IUpdatableTileEvent;
import com.denfop.network.packet.CustomPacketBuffer;
import com.denfop.tiles.base.TileElectricMachine;
import java.io.IOException;
import java.util.List;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Keyboard;

public class TileAntiUpgradeBlock
extends TileElectricMachine
implements IUpdatableTileEvent {
    public final InvSlotAntiUpgradeBlock input = new InvSlotAntiUpgradeBlock(this);
    public int index = 0;
    public int progress = 0;
    public boolean need = false;

    public TileAntiUpgradeBlock() {
        super(1000.0, 14, 4);
    }

    @Override
    public IMultiTileBlock getTeBlock() {
        return BlockBaseMachine3.antiupgradeblock;
    }

    @Override
    public BlockTileEntity getBlock() {
        return IUItem.basemachine2;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void addInformation(ItemStack stack, List<String> tooltip, ITooltipFlag advanced) {
        if (!Keyboard.isKeyDown((int)42)) {
            tooltip.add(Localization.translate("press.lshift"));
        }
        if (Keyboard.isKeyDown((int)42)) {
            tooltip.add(Localization.translate("iu.machines_work_energy") + 5 + Localization.translate("iu.machines_work_energy_type_eu"));
        }
        super.addInformation(stack, tooltip, advanced);
    }

    @Override
    public void readContainerPacket(CustomPacketBuffer customPacketBuffer) {
        super.readContainerPacket(customPacketBuffer);
        try {
            this.progress = (Integer)DecoderHandler.decode(customPacketBuffer);
            this.index = (Integer)DecoderHandler.decode(customPacketBuffer);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public CustomPacketBuffer writeContainerPacket() {
        CustomPacketBuffer packet = super.writeContainerPacket();
        try {
            EncoderHandler.encode(packet, this.progress);
            EncoderHandler.encode(packet, this.index);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return packet;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean shouldSideBeRendered(EnumFacing side, BlockPos otherPos) {
        return false;
    }

    @Override
    public boolean isNormalCube() {
        return false;
    }

    @Override
    public boolean doesSideBlockRendering(EnumFacing side) {
        return false;
    }

    @Override
    public boolean isSideSolid(EnumFacing side) {
        return false;
    }

    @Override
    public boolean clientNeedsExtraModelInfo() {
        return true;
    }

    public boolean shouldRenderInPass(int pass) {
        return true;
    }

    @Override
    public void updateEntityServer() {
        super.updateEntityServer();
        if (this.need && !this.input.isEmpty() && this.energy.canUseEnergy(5.0)) {
            ++this.progress;
            this.energy.useEnergy(5.0);
            if (this.progress >= 100) {
                List<ItemStack> list = UpgradeSystem.system.getListStack(this.input.get());
                if (this.outputSlot.canAdd(list.get(this.index))) {
                    this.outputSlot.add(list.get(this.index));
                }
                UpgradeSystem.system.removeUpdate(this.input.get(), this.func_145831_w(), this.index);
                this.need = false;
                this.progress = 0;
            }
        }
    }

    public ContainerAntiUpgrade getGuiContainer(EntityPlayer entityPlayer) {
        return new ContainerAntiUpgrade(entityPlayer, this);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiScreen getGui(EntityPlayer entityPlayer, boolean b) {
        return new GuiAntiUpgradeBlock(this.getGuiContainer(entityPlayer));
    }

    @Override
    public void func_145839_a(NBTTagCompound nbttagcompound) {
        super.func_145839_a(nbttagcompound);
        this.progress = nbttagcompound.func_74762_e("progress");
        this.need = nbttagcompound.func_74767_n("need");
        this.index = nbttagcompound.func_74762_e("index");
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbttagcompound) {
        super.func_189515_b(nbttagcompound);
        nbttagcompound.func_74768_a("progress", this.progress);
        nbttagcompound.func_74768_a("index", this.index);
        nbttagcompound.func_74757_a("need", this.need);
        return nbttagcompound;
    }

    @Override
    public void updateTileServer(EntityPlayer entityPlayer, double i) {
        List<ItemStack> list;
        if (i == 10.0) {
            super.updateTileServer(entityPlayer, i);
            return;
        }
        if (this.input.isEmpty()) {
            return;
        }
        if (this.need && i == 0.0) {
            return;
        }
        if (i >= 1.0 && !(list = UpgradeSystem.system.getListStack(this.input.get())).get((int)(i - 1.0)).func_190926_b()) {
            this.index = (int)(i - 1.0);
            return;
        }
        if (i == 0.0) {
            list = UpgradeSystem.system.getListStack(this.input.get());
            boolean need = false;
            ItemStack stack = list.get(this.index);
            if (!stack.func_190926_b() && this.outputSlot.canAdd(stack)) {
                need = true;
            }
            this.need = need;
        }
    }

    @Override
    public SoundEvent getSound() {
        return null;
    }
}

