/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.render.streak;

import com.denfop.network.packet.CustomPacketBuffer;
import com.denfop.render.streak.RGB;
import net.minecraft.nbt.NBTTagCompound;

public class PlayerStreakInfo {
    private RGB rgb;
    private boolean rainbow;

    public PlayerStreakInfo(RGB rgb, boolean rainbow) {
        this.rgb = rgb;
        this.rainbow = rainbow;
    }

    public PlayerStreakInfo(NBTTagCompound nbtTagCompound) {
        this.rgb = new RGB(nbtTagCompound.func_74765_d("red"), nbtTagCompound.func_74765_d("green"), nbtTagCompound.func_74765_d("blue"));
        this.rainbow = nbtTagCompound.func_74767_n("rainbow");
    }

    public PlayerStreakInfo(CustomPacketBuffer customPacketBuffer) {
        this.rgb = new RGB(customPacketBuffer.readShort(), customPacketBuffer.readShort(), customPacketBuffer.readShort());
        this.rainbow = customPacketBuffer.readBoolean();
    }

    public NBTTagCompound writeNBT() {
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74777_a("red", this.rgb.getRed());
        nbt.func_74777_a("blue", this.rgb.getBlue());
        nbt.func_74777_a("green", this.rgb.getGreen());
        nbt.func_74757_a("rainbow", this.rainbow);
        return nbt;
    }

    public CustomPacketBuffer writePacket() {
        CustomPacketBuffer packetBuffer = new CustomPacketBuffer();
        packetBuffer.writeShort(this.rgb.getRed());
        packetBuffer.writeShort(this.rgb.getBlue());
        packetBuffer.writeShort(this.rgb.getGreen());
        packetBuffer.writeBoolean(this.rainbow);
        return packetBuffer;
    }

    public boolean isRainbow() {
        return this.rainbow;
    }

    public void setRainbow(boolean rainbow) {
        this.rainbow = rainbow;
    }

    public RGB getRgb() {
        return this.rgb;
    }

    public void setRgb(RGB rgb) {
        this.rgb = rgb;
    }
}

