/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.render.base;

import com.denfop.tiles.base.IIsMolecular;
import com.denfop.tiles.base.TileEntityBlock;
import com.denfop.tiles.mechanism.worlcollector.TileCrystallize;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import javax.imageio.ImageIO;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.fml.client.FMLClientHandler;
import org.lwjgl.opengl.GL11;

public class RenderCoreProcess<T extends TileEntityBlock>
extends TileEntitySpecialRenderer<T> {
    private static final ResourceLocation plazmaTextloc = new ResourceLocation("industrialupgrade", "textures/models/plazma.png");
    private static final ResourceLocation particlesTextloc = new ResourceLocation("industrialupgrade", "textures/models/particles.png");
    private static final Map<List<Serializable>, Integer> textureSizeCache = new HashMap<List<Serializable>, Integer>();
    private final Random random = new Random();
    public int ticker;
    float rotation;
    float prevRotation;

    public static int getTextureSize(String s, int dv) {
        Integer textureSize = textureSizeCache.get(Arrays.asList(s, dv));
        if (textureSize != null) {
            return textureSize;
        }
        try {
            InputStream inputstream = Minecraft.func_71410_x().func_110442_L().func_110536_a(new ResourceLocation("industrialupgrade", s)).func_110527_b();
            BufferedImage bi = ImageIO.read(inputstream);
            int size = bi.getWidth() / dv;
            textureSizeCache.put(Arrays.asList(s, dv), size);
            return size;
        }
        catch (Exception var5) {
            var5.printStackTrace();
            return 16;
        }
    }

    public void renderCore(T te, double x, double y, double z) {
        ++this.ticker;
        if (this.ticker > 161) {
            this.ticker = 1;
        }
        int size1 = RenderCoreProcess.getTextureSize("textures/models/plazma.png", 64);
        int size2 = RenderCoreProcess.getTextureSize("textures/models/particles.png", 32);
        if (te instanceof IIsMolecular && ((IIsMolecular)te).getMode() != 0) {
            size2 = RenderCoreProcess.getTextureSize("textures/models/particles" + ((IIsMolecular)te).getMode() + ".png", 32);
        }
        float f1 = ActiveRenderInfo.func_178808_b();
        float f2 = ActiveRenderInfo.func_178809_c();
        float f3 = ActiveRenderInfo.func_178803_d();
        float f4 = ActiveRenderInfo.func_178805_e();
        float f5 = ActiveRenderInfo.func_178807_f();
        float scaleCore = 0.35f;
        float posX = (float)x + 0.5f;
        float posY = (float)y + 0.5f;
        float posZ = (float)z + 0.5f;
        Color color = new Color(0xC0FFFF);
        GL11.glPushMatrix();
        GL11.glDepthMask((boolean)false);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)1);
        FMLClientHandler.instance().getClient().field_71446_o.func_110577_a(plazmaTextloc);
        int i = this.ticker % 16;
        float size4 = size1 * 4;
        float float_sizeMinus0_01 = (float)size1 - 0.01f;
        float x0 = ((float)(i % 4 * size1) + 0.0f) / size4;
        float x1 = ((float)(i % 4 * size1) + float_sizeMinus0_01) / size4;
        float x2 = ((float)i / 4.0f * (float)size1 + 0.0f) / size4;
        float x3 = ((float)i / 4.0f * (float)size1 + float_sizeMinus0_01) / size4;
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        buffer.func_181668_a(7, DefaultVertexFormats.field_181709_i);
        buffer.func_181662_b((double)(posX - f1 * scaleCore - f4 * scaleCore), (double)(posY - f2 * scaleCore), (double)(posZ - f3 * scaleCore - f5 * scaleCore)).func_187315_a((double)x1, (double)x3).func_181669_b(color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha()).func_181675_d();
        buffer.func_181662_b((double)(posX - f1 * scaleCore + f4 * scaleCore), (double)(posY + f2 * scaleCore), (double)(posZ - f3 * scaleCore + f5 * scaleCore)).func_187315_a((double)x1, (double)x2).func_181669_b(color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha()).func_181675_d();
        buffer.func_181662_b((double)(posX + f1 * scaleCore + f4 * scaleCore), (double)(posY + f2 * scaleCore), (double)(posZ + f3 * scaleCore + f5 * scaleCore)).func_187315_a((double)x0, (double)x2).func_181669_b(color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha()).func_181675_d();
        buffer.func_181662_b((double)(posX + f1 * scaleCore - f4 * scaleCore), (double)(posY - f2 * scaleCore), (double)(posZ + f3 * scaleCore - f5 * scaleCore)).func_187315_a((double)x0, (double)x3).func_181669_b(color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha()).func_181675_d();
        tessellator.func_78381_a();
        GL11.glDisable((int)3042);
        GL11.glDepthMask((boolean)true);
        GL11.glPopMatrix();
        GL11.glPushMatrix();
        GL11.glDepthMask((boolean)false);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)1);
        if (te instanceof IIsMolecular) {
            if (((IIsMolecular)te).getMode() != 0) {
                FMLClientHandler.instance().getClient().field_71446_o.func_110577_a(new ResourceLocation("industrialupgrade", "textures/models/particles" + ((IIsMolecular)te).getMode() + ".png"));
            } else {
                FMLClientHandler.instance().getClient().field_71446_o.func_110577_a(particlesTextloc);
            }
        } else {
            FMLClientHandler.instance().getClient().field_71446_o.func_110577_a(particlesTextloc);
        }
        int qq = this.ticker % 16;
        i = 24 + qq;
        float size8 = size2 * 8;
        float_sizeMinus0_01 = (float)size2 - 0.01f;
        x0 = ((float)(i % 8 * size2) + 0.0f) / size8;
        x1 = ((float)(i % 8 * size2) + float_sizeMinus0_01) / size8;
        x2 = ((float)i / 8.0f * (float)size2 + 0.0f) / size8;
        x3 = ((float)i / 8.0f * (float)size2 + float_sizeMinus0_01) / size8;
        float var11 = MathHelper.func_76126_a((float)((float)this.ticker / 10.0f)) * 0.1f;
        scaleCore = 0.4f + var11;
        buffer = tessellator.func_178180_c();
        buffer.func_181668_a(7, DefaultVertexFormats.field_181709_i);
        buffer.func_181662_b((double)(posX - f1 * scaleCore - f4 * scaleCore), (double)(posY - f2 * scaleCore), (double)(posZ - f3 * scaleCore - f5 * scaleCore)).func_187315_a((double)x1, (double)x3).func_181669_b(color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha()).func_181675_d();
        buffer.func_181662_b((double)(posX - f1 * scaleCore + f4 * scaleCore), (double)(posY + f2 * scaleCore), (double)(posZ - f3 * scaleCore + f5 * scaleCore)).func_187315_a((double)x1, (double)x2).func_181669_b(color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha()).func_181675_d();
        buffer.func_181662_b((double)(posX + f1 * scaleCore + f4 * scaleCore), (double)(posY + f2 * scaleCore), (double)(posZ + f3 * scaleCore + f5 * scaleCore)).func_187315_a((double)x0, (double)x2).func_181669_b(color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha()).func_181675_d();
        buffer.func_181662_b((double)(posX + f1 * scaleCore - f4 * scaleCore), (double)(posY - f2 * scaleCore), (double)(posZ + f3 * scaleCore - f5 * scaleCore)).func_187315_a((double)x0, (double)x3).func_181669_b(color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha()).func_181675_d();
        tessellator.func_78381_a();
        GL11.glDisable((int)3042);
        GL11.glDepthMask((boolean)true);
        GL11.glPopMatrix();
        GL11.glBlendFunc((int)770, (int)0);
    }

    public void render(T te, double x, double y, double z, float partialTicks, int destroyStage, float alpha) {
        GL11.glPushMatrix();
        GL11.glTranslatef((float)((float)x + 0.5f), (float)((float)y + 1.5f), (float)((float)z + 0.5f));
        GL11.glPushMatrix();
        GL11.glRotatef((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        GL11.glPopMatrix();
        GL11.glPopMatrix();
        if (((TileEntityBlock)((Object)te)).getActive()) {
            if (te instanceof IIsMolecular) {
                GL11.glPushMatrix();
                this.renderItem((IIsMolecular)te, x, y, z, partialTicks);
                GL11.glPopMatrix();
            }
            GL11.glPushMatrix();
            this.renderCore(te, x, y, z);
            GL11.glPopMatrix();
        }
    }

    public boolean shouldSpreadItems() {
        return true;
    }

    private int transformModelCount(IIsMolecular itemIn, double p_177077_2_, double p_177077_4_, double p_177077_6_, float p_177077_8_, IBakedModel p_177077_9_) {
        ItemStack itemstack = itemIn.getItemStack();
        Item item = itemstack.func_77973_b();
        if (item == Items.field_190931_a) {
            return 0;
        }
        int i = this.getModelCount(itemstack);
        float f2 = p_177077_9_.func_177552_f().func_181688_b((ItemCameraTransforms.TransformType)ItemCameraTransforms.TransformType.GROUND).field_178363_d.y;
        if (!(itemIn instanceof TileCrystallize)) {
            GlStateManager.func_179137_b((double)((double)((float)p_177077_2_) + 0.5), (double)((double)((float)p_177077_4_ + 0.25f * f2) + 0.2), (double)((double)((float)p_177077_6_) + 0.5));
        } else {
            GlStateManager.func_179137_b((double)((double)((float)p_177077_2_) + 0.5), (double)((double)((float)p_177077_4_ + 0.25f * f2) + 0.37), (double)((double)((float)p_177077_6_) + 0.5));
        }
        GlStateManager.func_179152_a((float)0.5f, (float)0.5f, (float)0.5f);
        GL11.glRotatef((float)this.rotation, (float)0.0f, (float)1.0f, (float)0.0f);
        this.prevRotation = this.rotation = this.prevRotation + (this.rotation - this.prevRotation) * p_177077_8_;
        this.rotation = (float)((double)this.rotation + 0.25);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        return i;
    }

    protected int getModelCount(ItemStack stack) {
        int i = 1;
        if (stack.func_190916_E() > 48) {
            i = 5;
        } else if (stack.func_190916_E() > 32) {
            i = 4;
        } else if (stack.func_190916_E() > 16) {
            i = 3;
        } else if (stack.func_190916_E() > 1) {
            i = 2;
        }
        return i;
    }

    private void renderItem(IIsMolecular te, double x, double y, double z, float partialTicks) {
        ItemStack itemstack = te.getItemStack();
        int i = itemstack.func_190926_b() ? 187 : Item.func_150891_b((Item)itemstack.func_77973_b()) + itemstack.func_77960_j();
        this.random.setSeed(i);
        boolean flag = false;
        if (this.bindEntityTexture(te.getEntityBlock())) {
            Minecraft.func_71410_x().func_175598_ae().field_78724_e.func_110581_b(this.getEntityTexture(te.getEntityBlock())).func_174936_b(false, false);
            flag = true;
        }
        GlStateManager.func_179091_B();
        GlStateManager.func_179092_a((int)516, (float)0.1f);
        GlStateManager.func_179147_l();
        RenderHelper.func_74519_b();
        GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        GlStateManager.func_179094_E();
        IBakedModel ibakedmodel = Minecraft.func_71410_x().func_175599_af().func_184393_a(itemstack, te.getEntityBlock().func_145831_w(), null);
        int j = this.transformModelCount(te, x, y, z, partialTicks, ibakedmodel);
        boolean flag1 = ibakedmodel.func_177556_c();
        if (!flag1) {
            float f3 = -0.0f * (float)(j - 1) * 0.5f;
            float f4 = -0.0f * (float)(j - 1) * 0.5f;
            float f5 = -0.09375f * (float)(j - 1) * 0.5f;
            GlStateManager.func_179109_b((float)f3, (float)f4, (float)f5);
        }
        for (int k = 0; k < j; ++k) {
            IBakedModel transformedModel;
            GlStateManager.func_179094_E();
            if (flag1) {
                if (k > 0) {
                    float f7 = (this.random.nextFloat() * 2.0f - 1.0f) * 0.15f;
                    float f9 = (this.random.nextFloat() * 2.0f - 1.0f) * 0.15f;
                    float f6 = (this.random.nextFloat() * 2.0f - 1.0f) * 0.15f;
                    GlStateManager.func_179109_b((float)(this.shouldSpreadItems() ? f7 : 0.0f), (float)(this.shouldSpreadItems() ? f9 : 0.0f), (float)f6);
                }
                transformedModel = ForgeHooksClient.handleCameraTransforms((IBakedModel)ibakedmodel, (ItemCameraTransforms.TransformType)ItemCameraTransforms.TransformType.GROUND, (boolean)false);
                Minecraft.func_71410_x().func_175599_af().func_180454_a(itemstack, transformedModel);
                GlStateManager.func_179121_F();
                continue;
            }
            if (k > 0) {
                float f8 = (this.random.nextFloat() * 2.0f - 1.0f) * 0.15f * 0.5f;
                float f10 = (this.random.nextFloat() * 2.0f - 1.0f) * 0.15f * 0.5f;
                GlStateManager.func_179109_b((float)f8, (float)f10, (float)0.0f);
            }
            transformedModel = ForgeHooksClient.handleCameraTransforms((IBakedModel)ibakedmodel, (ItemCameraTransforms.TransformType)ItemCameraTransforms.TransformType.GROUND, (boolean)false);
            Minecraft.func_71410_x().func_175599_af().func_180454_a(itemstack, transformedModel);
            GlStateManager.func_179121_F();
            GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)0.09375f);
        }
        GlStateManager.func_179121_F();
        GlStateManager.func_179101_C();
        GlStateManager.func_179084_k();
        this.bindEntityTexture(te.getEntityBlock());
        if (flag) {
            Minecraft.func_71410_x().func_175598_ae().field_78724_e.func_110581_b(this.getEntityTexture(te.getEntityBlock())).func_174935_a();
        }
    }

    protected boolean bindEntityTexture(TileEntityBlock entity) {
        ResourceLocation resourcelocation = this.getEntityTexture(entity);
        if (resourcelocation == null) {
            return false;
        }
        this.func_147499_a(resourcelocation);
        return true;
    }

    protected ResourceLocation getEntityTexture(TileEntityBlock entity) {
        return TextureMap.field_110575_b;
    }
}

