/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.render.base;

import com.denfop.api.render.IModelCustom;
import com.denfop.api.render.IModelCustomLoader;
import com.denfop.render.base.ObjModelLoader;
import com.denfop.render.base.WavefrontObject;
import com.google.common.collect.Maps;
import java.util.Map;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class AdvancedModelLoader {
    private static final Map<String, IModelCustomLoader> instances = Maps.newHashMap();

    public static void registerModelHandler(IModelCustomLoader modelHandler) {
        String[] var1;
        for (String suffix : var1 = modelHandler.getSuffixes()) {
            instances.put(suffix, modelHandler);
        }
    }

    public static IModelCustom loadModel(ResourceLocation resource) throws IllegalArgumentException, WavefrontObject.ModelFormatException {
        String name = resource.func_110623_a();
        int i = name.lastIndexOf(46);
        if (i == -1) {
            throw new IllegalArgumentException("The resource name+" + resource + " is not valid");
        }
        String suffix = name.substring(i + 1);
        IModelCustomLoader loader = instances.get(suffix);
        if (loader == null) {
            throw new IllegalArgumentException("The resource name+" + resource + " is not supported");
        }
        return loader.loadInstance(resource);
    }

    static {
        AdvancedModelLoader.registerModelHandler(new ObjModelLoader());
    }
}

