/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.network.packet;

import com.denfop.IUCore;
import com.denfop.blocks.TileBlockCreator;
import com.denfop.network.DecoderHandler;
import com.denfop.network.packet.CustomPacketBuffer;
import com.denfop.network.packet.EnumTypePacket;
import com.denfop.network.packet.IPacket;
import com.denfop.tiles.base.TileEntityBlock;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class PacketUpdateTile
implements IPacket {
    public PacketUpdateTile() {
    }

    public PacketUpdateTile(TileEntityBlock te) {
        IUCore.network.getServer().addTileToUpdate(te);
    }

    public PacketUpdateTile(CustomPacketBuffer data, EntityPlayerMP player) {
        CustomPacketBuffer buffer = new CustomPacketBuffer(16384);
        buffer.writeByte(this.getId());
        buffer.writeBytes((ByteBuf)data);
        IUCore.network.getServer().sendPacket(buffer, player);
    }

    private static void apply(BlockPos pos, Class<? extends TileEntityBlock> teClass, World world, byte[] is) {
        if (world.func_175668_a(pos, false)) {
            TileEntity te = world.func_175625_s(pos);
            if (teClass != null && (te == null || te.getClass() != teClass || te.func_145837_r() || te.func_145831_w() != world)) {
                te = TileEntityBlock.instantiate(teClass);
                world.func_175690_a(pos, te);
                assert (!te.func_145837_r());
                assert (te.func_145831_w() == world);
            } else {
                if (te == null) {
                    return;
                }
                if (te.func_145837_r() || te.func_145831_w() != world) {
                    return;
                }
            }
            CustomPacketBuffer buf = new CustomPacketBuffer();
            buf.writeBytes(is);
            ((TileEntityBlock)te).readPacket(buf);
        }
    }

    @Override
    public byte getId() {
        return 0;
    }

    @Override
    public void readPacket(CustomPacketBuffer is, EntityPlayer entityPlayer) {
        BlockPos pos;
        int dimensionId = is.readInt();
        try {
            pos = DecoderHandler.decode(is, BlockPos.class);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        String fieldName = is.readString();
        String[] parts = fieldName.split("=");
        String firstPart = parts[0];
        String secondPart = parts[1];
        String[] subParts = firstPart.split(":");
        String prefix = subParts[0];
        String identifier = subParts[1];
        ResourceLocation res = new ResourceLocation(prefix, identifier);
        Class<TileEntityBlock> teClass = TileBlockCreator.instance.get((ResourceLocation)res).teInfo.getClassFromName(secondPart);
        byte[] bytes = new byte[is.writerIndex() - is.readerIndex()];
        is.readBytes(bytes);
        if (is.readerIndex() >= is.writerIndex()) {
            IUCore.proxy.requestTick(false, () -> {
                World world = IUCore.proxy.getPlayerWorld();
                if (world != null && world.field_73011_w.getDimension() == dimensionId) {
                    PacketUpdateTile.apply(pos, teClass, world, bytes);
                }
            });
        }
    }

    @Override
    public EnumTypePacket getPacketType() {
        return EnumTypePacket.SERVER;
    }
}

