/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.network.packet;

import com.denfop.IUCore;
import com.denfop.blocks.state.TileEntityBlockStateContainer;
import com.denfop.network.DecoderHandler;
import com.denfop.network.EncoderHandler;
import com.denfop.network.packet.CustomPacketBuffer;
import com.denfop.network.packet.EncodedType;
import com.denfop.network.packet.EnumTypePacket;
import com.denfop.network.packet.IPacket;
import com.denfop.render.base.ISpecialParticleModel;
import com.denfop.tiles.base.TileEntityBlock;
import com.denfop.utils.ParticleBaseBlockDust;
import java.io.IOException;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class PacketRunParticles
implements IPacket {
    public PacketRunParticles() {
    }

    public PacketRunParticles(World world, BlockPos pos, Entity entity) {
        CustomPacketBuffer buffer = new CustomPacketBuffer(64);
        buffer.writeByte(this.getId());
        try {
            EncoderHandler.encode(buffer, pos, false);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        buffer.writeDouble(entity.field_70165_t + ((double)world.field_73012_v.nextFloat() - 0.5) * (double)entity.field_70130_N);
        buffer.writeDouble(entity.func_174813_aQ().field_72338_b + 0.1);
        buffer.writeDouble(entity.field_70161_v + ((double)world.field_73012_v.nextFloat() - 0.5) * (double)entity.field_70130_N);
        buffer.writeDouble(-entity.field_70159_w * 4.0);
        buffer.writeDouble(-entity.field_70179_y * 4.0);
        for (EntityPlayer player : world.field_73010_i) {
            double distance;
            if (!(player instanceof EntityPlayerMP) || (distance = player.func_70092_e(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v)) > 1024.0) continue;
            IUCore.network.getServer().sendPacket(buffer, (EntityPlayerMP)player);
        }
    }

    @Override
    public byte getId() {
        return 14;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void readPacket(CustomPacketBuffer is, EntityPlayer entityPlayer) {
        BlockPos pos;
        try {
            pos = (BlockPos)DecoderHandler.decode(is, EncodedType.BlockPos);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        double x = is.readDouble();
        double y = is.readDouble();
        double z = is.readDouble();
        double xSpeed = is.readDouble();
        double zSpeed = is.readDouble();
        TileEntityBlock block = (TileEntityBlock)entityPlayer.func_130014_f_().func_175625_s(pos);
        if (block != null) {
            IUCore.proxy.requestTick(false, () -> {
                IBakedModel model;
                IBlockState state = block.getBlockState();
                ParticleBaseBlockDust particle = new ParticleBaseBlockDust(entityPlayer.func_130014_f_(), x, y, z, xSpeed, 0.0, zSpeed, state);
                if (pos != null && block.hasSpecialModel() && (model = Minecraft.func_71410_x().func_175602_ab().func_175023_a().func_178125_b(state)) instanceof ISpecialParticleModel) {
                    state = state.func_177230_c().getExtendedState(state, (IBlockAccess)entityPlayer.func_130014_f_(), pos);
                    ((ISpecialParticleModel)model).enhanceParticle((Particle)particle, (TileEntityBlockStateContainer.PropertiesStateInstance)state);
                }
                particle.func_174845_l();
                Minecraft.func_71410_x().field_71452_i.func_78873_a((Particle)particle);
            });
        }
    }

    @Override
    public EnumTypePacket getPacketType() {
        return EnumTypePacket.SERVER;
    }
}

