/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.network;

import com.denfop.api.radiationsystem.Radiation;
import com.denfop.api.recipe.RecipeInfo;
import com.denfop.api.research.main.BaseLevelSystem;
import com.denfop.api.vein.Vein;
import com.denfop.componets.AbstractComponent;
import com.denfop.invslot.InvSlot;
import com.denfop.network.packet.CustomPacketBuffer;
import com.denfop.network.packet.EncodedType;
import com.denfop.utils.ModUtils;
import com.mojang.authlib.GameProfile;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufOutputStream;
import java.io.DataOutput;
import java.io.IOException;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;

public class EncoderHandler {
    private static final Map<Class<?>, EncodedType> classToTypeCache = Collections.synchronizedMap(new IdentityHashMap());

    public static void encode(CustomPacketBuffer os, Object o) throws IOException {
        try {
            EncoderHandler.encode(os, o, true);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    private static int idFromType(EncodedType type) {
        return type.ordinal();
    }

    private static EncodedType typeFromObject(Object o) {
        return o == null ? EncodedType.Null : EncoderHandler.typeFromClass(o.getClass());
    }

    private static Class<?> box(Class<?> clazz) {
        if (clazz == Byte.TYPE) {
            return Byte.class;
        }
        if (clazz == Short.TYPE) {
            return Short.class;
        }
        if (clazz == Integer.TYPE) {
            return Integer.class;
        }
        if (clazz == Long.TYPE) {
            return Long.class;
        }
        if (clazz == Float.TYPE) {
            return Float.class;
        }
        if (clazz == Double.TYPE) {
            return Double.class;
        }
        if (clazz == Boolean.TYPE) {
            return Boolean.class;
        }
        return clazz == Character.TYPE ? Character.class : clazz;
    }

    private static EncodedType typeFromClass(Class<?> cls) {
        EncodedType[] var3;
        EncodedType ret;
        if (cls == null) {
            return EncodedType.Null;
        }
        if (cls.isArray()) {
            return EncodedType.Array;
        }
        if (cls.isPrimitive()) {
            cls = EncoderHandler.box(cls);
        }
        if ((ret = EncodedType.classToTypeMap.get(cls)) != null) {
            return ret;
        }
        ret = classToTypeCache.get(cls);
        if (ret != null) {
            return ret;
        }
        for (EncodedType type : var3 = EncodedType.types) {
            if (type.cls == null || !type.cls.isAssignableFrom(cls)) continue;
            classToTypeCache.put(cls, type);
            return type;
        }
        throw new IllegalStateException("unmatched " + cls);
    }

    public static void encode(CustomPacketBuffer os, Object o, boolean withType) throws IOException {
        EncodedType type = EncoderHandler.typeFromObject(o);
        if (withType) {
            os.writeByte(EncoderHandler.idFromType(type));
        }
        switch (type) {
            case Array: {
                Object value;
                int i;
                Class<?> componentClass = o.getClass().getComponentType();
                int len = Array.getLength(o);
                if (componentClass == Object.class && len > 0) {
                    boolean isEnum = false;
                    Class<Object> target = null;
                    block40: for (i = 0; i < len; ++i) {
                        value = Array.get(o, i);
                        if (target == null) {
                            if (value instanceof Enum) {
                                target = ((Enum)value).getDeclaringClass();
                                isEnum = true;
                                continue;
                            }
                            if (value == null) continue;
                            target = value.getClass();
                            assert (target != Object.class);
                            continue;
                        }
                        if (value != null) {
                            Class<?> valueClass = value.getClass();
                            if (valueClass != target && !target.isAssignableFrom(valueClass)) {
                                if (isEnum || value instanceof Enum) {
                                    throw new IllegalArgumentException("Array of mixed enum entries");
                                }
                                do {
                                    if ((target = target.getSuperclass()) != Object.class) continue;
                                    ++i;
                                    while (i < len) {
                                        if (Array.get(o, i) instanceof Enum) {
                                            throw new IllegalArgumentException("Array of mixed enum entries");
                                        }
                                        ++i;
                                    }
                                    break block40;
                                } while (!target.isAssignableFrom(valueClass));
                                continue;
                            }
                            assert (isEnum == value instanceof Enum);
                            continue;
                        }
                        if (!isEnum) continue;
                        throw new IllegalArgumentException("Enum array with null entry");
                    }
                    componentClass = target;
                }
                EncodedType componentType = EncoderHandler.typeFromClass(componentClass);
                os.writeByte(EncoderHandler.idFromType(componentType));
                os.writeBoolean(componentClass.isPrimitive());
                if (componentType == EncodedType.Enum) {
                    os.writeString(componentClass.getName());
                }
                os.func_150787_b(len);
                boolean anyTypeMismatch = false;
                for (i = 0; i < len; ++i) {
                    value = Array.get(o, i);
                    if (value != null && EncoderHandler.typeFromClass(value.getClass()) == componentType) continue;
                    anyTypeMismatch = true;
                    break;
                }
                os.writeBoolean(anyTypeMismatch);
                for (i = 0; i < len; ++i) {
                    EncoderHandler.encode(os, Array.get(o, i), anyTypeMismatch);
                }
                break;
            }
            case Block: {
                EncoderHandler.encode(os, ModUtils.getName((Block)o), false);
                break;
            }
            case BlockPos: {
                BlockPos pos = (BlockPos)o;
                os.writeInt(pos.func_177958_n());
                os.writeInt(pos.func_177956_o());
                os.writeInt(pos.func_177952_p());
                break;
            }
            case Boolean: {
                os.writeBoolean((Boolean)o);
                break;
            }
            case Byte: {
                os.writeByte(((Byte)o).byteValue());
                break;
            }
            case Character: {
                os.writeChar(((Character)o).charValue());
                break;
            }
            case ChunkPos: {
                ChunkPos chunkpos = (ChunkPos)o;
                os.writeInt(chunkpos.field_77276_a);
                os.writeInt(chunkpos.field_77275_b);
                break;
            }
            case Collection: {
                EncoderHandler.encode(os, ((Collection)o).toArray(), false);
                break;
            }
            case Component: {
                os.writeBytes((ByteBuf)((AbstractComponent)o).updateComponent());
                break;
            }
            case Double: {
                os.writeDouble((Double)o);
                break;
            }
            case Enchantment: {
                EncoderHandler.encode(os, Enchantment.field_185264_b.func_177774_c((Object)((Enchantment)o)), false);
                break;
            }
            case Enum: {
                os.func_150787_b(((Enum)o).ordinal());
                break;
            }
            case Float: {
                os.writeFloat(((Float)o).floatValue());
                break;
            }
            case Fluid: {
                os.writeString(((Fluid)o).getName());
                break;
            }
            case FluidStack: {
                FluidStack fs = (FluidStack)o;
                EncoderHandler.encode(os, fs.getFluid(), false);
                os.writeInt(fs.amount);
                EncoderHandler.encode(os, fs.tag, true);
                break;
            }
            case FluidTank: {
                FluidTank tank = (FluidTank)o;
                EncoderHandler.encode(os, tank.getFluid(), true);
                os.writeInt(tank.getCapacity());
                break;
            }
            case GameProfile: {
                GameProfile gp = (GameProfile)o;
                EncoderHandler.encode(os, gp.getId(), true);
                os.writeString(gp.getName());
                break;
            }
            case Integer: {
                os.writeInt((Integer)o);
                break;
            }
            case InvSlot: {
                InvSlot slot = (InvSlot)o;
                ItemStack[] contents = new ItemStack[slot.size()];
                for (int i = 0; i < slot.size(); ++i) {
                    contents[i] = slot.get(i);
                }
                EncoderHandler.encode(os, contents, false);
                break;
            }
            case Item: {
                EncoderHandler.encode(os, ModUtils.getName((Item)o), false);
                break;
            }
            case ItemStack: {
                ItemStack stack = (ItemStack)o;
                if (ModUtils.isEmpty(stack)) {
                    os.writeByte(0);
                    break;
                }
                os.writeByte(ModUtils.getSize(stack));
                EncoderHandler.encode(os, stack.func_77973_b(), false);
                os.writeShort(stack.func_77952_i());
                EncoderHandler.encode(os, stack.func_77978_p(), true);
                break;
            }
            case Long: {
                os.writeLong((Long)o);
                break;
            }
            case NBTTagCompound: {
                CompressedStreamTools.func_74800_a((NBTTagCompound)((NBTTagCompound)o), (DataOutput)new ByteBufOutputStream((ByteBuf)os));
                break;
            }
            case Null: {
                if (withType) break;
                throw new IllegalArgumentException("o has to be non-null without types");
            }
            case Object: {
                throw new IllegalArgumentException("unhandled class: " + o.getClass());
            }
            case Potion: {
                EncoderHandler.encode(os, Potion.field_188414_b.func_177774_c((Object)((Potion)o)), false);
                break;
            }
            case ResourceLocation: {
                ResourceLocation loc = (ResourceLocation)o;
                os.writeString(loc.func_110624_b());
                os.writeString(loc.func_110623_a());
                break;
            }
            case Short: {
                os.writeShort(((Short)o).shortValue());
                break;
            }
            case String: {
                os.writeString((String)o);
                break;
            }
            case TileEntity: {
                TileEntity te = (TileEntity)o;
                EncoderHandler.encode(os, te.func_145831_w(), false);
                EncoderHandler.encode(os, te.func_174877_v(), false);
                break;
            }
            case BaseLevelSystem: {
                BaseLevelSystem baseResearch = (BaseLevelSystem)o;
                os.writeString(baseResearch.getPlayer().func_70005_c_());
                EncoderHandler.encode(os, baseResearch.write(), true);
                break;
            }
            case UUID: {
                UUID uuid = (UUID)o;
                os.writeLong(uuid.getMostSignificantBits());
                os.writeLong(uuid.getLeastSignificantBits());
                break;
            }
            case Vec3: {
                Vec3d v = (Vec3d)o;
                os.writeDouble(v.field_72450_a);
                os.writeDouble(v.field_72448_b);
                os.writeDouble(v.field_72449_c);
                break;
            }
            case World: {
                os.writeInt(((World)o).field_73011_w.getDimension());
                break;
            }
            case Vein: {
                Vein vein = (Vein)o;
                os.writeBytes((ByteBuf)vein.writePacket());
                break;
            }
            case RecipeInfo: {
                RecipeInfo recipeInfo = (RecipeInfo)o;
                os.writeBytes((ByteBuf)recipeInfo.getPacket());
                break;
            }
            case Radiation: {
                Radiation radiation = (Radiation)o;
                os.writeBytes((ByteBuf)radiation.writePacket());
                break;
            }
            case FAKE_PLANET: {
                break;
            }
            default: {
                throw new IllegalArgumentException("unhandled type: " + (Object)((Object)type));
            }
        }
    }
}

