/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.items.resource;

import com.denfop.api.IModelRegister;
import com.denfop.items.block.ISubItem;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.translation.I18n;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemSubTypes<T extends Enum<T>>
extends Item
implements ISubItem<T>,
IModelRegister {
    protected final PropertyEnum<T> typeProperty;

    private ItemSubTypes(PropertyEnum<T> typeProperty) {
        this.typeProperty = typeProperty;
        this.func_77627_a(true);
    }

    protected ItemSubTypes(Class<T> typeClass) {
        this(PropertyEnum.func_177707_a((String)"type", typeClass, Arrays.asList(typeClass.getEnumConstants())));
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerModels() {
        ArrayList list = new ArrayList(this.typeProperty.func_177700_c());
        for (int i = 0; i < this.typeProperty.func_177700_c().size(); ++i) {
            this.registerModel(this, i, ((IStringSerializable)((Enum)list.get(i))).func_176610_l());
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void registerModel(Item item, int meta, String extraName) {
        ModelLoader.setCustomModelResourceLocation((Item)item, (int)meta, (ModelResourceLocation)new ModelResourceLocation("industrialupgrade:items/" + extraName, null));
    }

    public String func_77653_i(ItemStack stack) {
        return I18n.func_74838_a((String)this.func_77667_c(stack));
    }

    public String func_77667_c(ItemStack stack) {
        T type = this.getType(stack);
        return type == null ? super.func_77667_c(stack).replace("item", "iu").replace(".name", "") : super.func_77667_c(stack).replace("item", "iu") + "." + ((IStringSerializable)type).func_176610_l();
    }

    @Override
    public ItemStack getItemStack(T type) {
        return this.getItemStackUnchecked(type);
    }

    protected ItemStack getItemStackUnchecked(T type) {
        return new ItemStack((Item)this, 1, new ArrayList(this.typeProperty.func_177700_c()).indexOf(type));
    }

    public void func_150895_a(@Nonnull CreativeTabs tab, @Nonnull NonNullList<ItemStack> subItems) {
        if (this.func_194125_a(tab)) {
            for (Enum type : this.typeProperty.func_177700_c()) {
                subItems.add((Object)this.getItemStackUnchecked(type));
            }
        }
    }

    public Set<T> getAllTypes() {
        return EnumSet.allOf(this.typeProperty.func_177699_b());
    }

    public final T getType(ItemStack stack) {
        return (T)((Enum)new ArrayList(this.typeProperty.func_177700_c()).get(stack.func_77960_j()));
    }
}

