/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.items.resource;

import com.denfop.IUCore;
import com.denfop.IUPotion;
import com.denfop.api.IModelRegister;
import com.denfop.api.item.IHazmatLike;
import com.denfop.blocks.ISubEnum;
import com.denfop.items.reactors.IRadioactiveItemType;
import com.denfop.items.resource.ItemSubTypes;
import com.denfop.register.Register;
import javax.annotation.Nonnull;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemNuclearResource
extends ItemSubTypes<Types>
implements IModelRegister {
    protected static final String NAME = "nuclearresource";

    public ItemNuclearResource() {
        super(Types.class);
        this.func_77637_a(IUCore.ReactorsTab);
        Register.registerItem(this, IUCore.getIdentifier(NAME)).func_77655_b(NAME);
        IUCore.proxy.addIModelRegister(this);
    }

    public void func_77663_a(ItemStack stack, World world, Entity rawEntity, int slotIndex, boolean isCurrentItem) {
        EntityLivingBase entity;
        Types rawType;
        Item item = stack.func_77973_b();
        if (item instanceof ItemSubTypes && (rawType = (Types)((ItemSubTypes)item).getType(stack)) != null && rawEntity instanceof EntityLivingBase && !IHazmatLike.hasCompleteHazmat(entity = (EntityLivingBase)rawEntity)) {
            IUPotion.radiation.applyTo(entity, rawType.getRadiationDuration() * 20, rawType.getRadiationAmplifier());
        }
    }

    @Override
    public void func_150895_a(@Nonnull CreativeTabs tab, @Nonnull NonNullList<ItemStack> subItems) {
        if (this.func_194125_a(tab)) {
            for (Types type : this.typeProperty.func_177700_c()) {
                subItems.add((Object)this.getItemStackUnchecked(type));
            }
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerModel(Item stack, int meta, String extraName) {
        ModelLoader.setCustomModelResourceLocation((Item)this, (int)meta, (ModelResourceLocation)new ModelResourceLocation("industrialupgrade:nuclearresource/" + Types.getFromID(meta).func_176610_l(), null));
    }

    public static enum Types implements ISubEnum,
    IRadioactiveItemType
    {
        uranium(0, 60, 100),
        uranium_235(1, 150, 100),
        uranium_238(2, 10, 90),
        plutonium(3, 150, 100),
        mox(4, 300, 100),
        small_uranium_235(5, 150, 100),
        small_uranium_238(6, 10, 90),
        small_plutonium(7, 150, 100),
        uranium_pellet(8, 60, 100),
        mox_pellet(9, 300, 100),
        rtg_pellet(10, 2, 90);

        private final int id;
        private final int radLen;
        private final int radAmplifier;

        private Types(int id, int radLen, int radAmplifier) {
            this.id = id;
            this.radLen = radLen;
            this.radAmplifier = radAmplifier;
        }

        public static Types getFromID(int ID) {
            return Types.values()[ID % Types.values().length];
        }

        public String func_176610_l() {
            return this.name();
        }

        @Override
        public int getId() {
            return this.id;
        }

        @Override
        public int getRadiationDuration() {
            return this.radLen;
        }

        @Override
        public int getRadiationAmplifier() {
            return this.radAmplifier;
        }
    }
}

