/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.items.reactors;

import com.denfop.IUCore;
import com.denfop.IUPotion;
import com.denfop.Localization;
import com.denfop.api.item.IHazmatLike;
import com.denfop.api.reactors.EnumTypeComponent;
import com.denfop.api.reactors.IAdvReactor;
import com.denfop.api.reactors.IReactorItem;
import com.denfop.items.reactors.IRadioactiveItemType;
import com.denfop.items.reactors.ItemDamage;
import com.denfop.utils.ModUtils;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemBaseRod
extends ItemDamage
implements IRadioactiveItemType,
IReactorItem {
    public final int numberOfCells;
    private final int heat;
    private final float power;
    private final String name;
    private final int level;
    private final double radiation;
    double[] p = new double[]{5.0, 20.0, 60.0, 200.0};

    public ItemBaseRod(String internalName, int cells, int heat, float power, int level) {
        super(internalName, 1);
        this.heat = heat;
        this.power = power;
        this.func_77637_a(IUCore.ReactorsTab);
        this.func_77625_d(1);
        this.numberOfCells = cells;
        this.setNoRepair();
        this.func_77637_a(IUCore.ReactorsTab);
        this.name = internalName;
        this.level = level;
        this.radiation = power * (float)level * (float)cells;
    }

    @SideOnly(value=Side.CLIENT)
    public static ModelResourceLocation getModelLocation(String name) {
        String loc = "industrialupgrade:reactors/" + name;
        return new ModelResourceLocation(loc, null);
    }

    public void func_77663_a(ItemStack stack, World world, Entity rawEntity, int slotIndex, boolean isCurrentItem) {
        EntityLivingBase entity;
        if (rawEntity instanceof EntityLivingBase && !IHazmatLike.hasCompleteHazmat(entity = (EntityLivingBase)rawEntity)) {
            IUPotion.radiation.applyTo(entity, this.getRadiationDuration(), this.getRadiationAmplifier());
        }
    }

    public String func_77653_i(ItemStack stack) {
        return I18n.func_74838_a((String)this.func_77667_c(stack).replace("item", "iu").replace(".name", ""));
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerModel(Item item, int meta, String name) {
        ModelLoader.setCustomModelResourceLocation((Item)item, (int)meta, (ModelResourceLocation)ItemBaseRod.getModelLocation(name));
    }

    @Override
    public void registerModels() {
        this.registerModels(this.name);
    }

    public void func_77624_a(@Nonnull ItemStack stack, World world, @Nonnull List<String> tooltip, @Nonnull ITooltipFlag advanced) {
        super.func_77624_a(stack, world, tooltip, advanced);
        double temp = Math.log10(this.numberOfCells);
        double temp1 = Math.log10(2.0);
        double m = temp / temp1;
        tooltip.add(Localization.translate("reactor.info") + ModUtils.getString(this.p[(int)m] * (double)this.power * (double)this.level) + " EF");
        tooltip.add(Localization.translate("reactor.rod.radiation") + (int)this.radiation);
        tooltip.add(Localization.translate("reactor.rod.heat") + this.heat);
        tooltip.add(Localization.translate("reactor.rod_level") + this.level);
        tooltip.add(Localization.translate("reactor.rod_level1"));
    }

    @Override
    public int getRadiationDuration() {
        return 200;
    }

    @Override
    public int getRadiationAmplifier() {
        return 100;
    }

    @Override
    public EnumTypeComponent getType() {
        return EnumTypeComponent.ROD;
    }

    @Override
    public int getLevel() {
        return this.level;
    }

    @Override
    public double getRadiation() {
        return this.radiation;
    }

    @Override
    public int getAutoRepair(IAdvReactor reactor) {
        return 0;
    }

    @Override
    public int getRepairOther(IAdvReactor reactor) {
        return 0;
    }

    @Override
    public int getDamageCFromHeat(int heat, IAdvReactor reactor) {
        return 1;
    }

    @Override
    public int getHeat(IAdvReactor reactor) {
        return this.heat;
    }

    @Override
    public double getHeatRemovePercent(IAdvReactor reactor) {
        return 0.0;
    }

    @Override
    public void damageItem(ItemStack stack, int damage) {
    }

    @Override
    public boolean updatableItem() {
        return true;
    }

    @Override
    public boolean caneExtractHeat() {
        return true;
    }

    @Override
    public double getEnergyProduction(IAdvReactor reactor) {
        double temp = Math.log10(this.numberOfCells);
        double temp1 = Math.log10(2.0);
        double m = temp / temp1;
        return this.p[(int)m] * (double)this.power * (double)this.level;
    }

    @Override
    public boolean needClear(ItemStack stack) {
        return this.getMaxCustomDamage(stack) - this.getCustomDamage(stack) == 0;
    }
}

