/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.items.modules;

import com.denfop.IUCore;
import com.denfop.Localization;
import com.denfop.api.IModelRegister;
import com.denfop.blocks.ISubEnum;
import com.denfop.items.modules.EnumQuarryModules;
import com.denfop.items.resource.ItemSubTypes;
import com.denfop.register.Register;
import com.denfop.utils.ModUtils;
import java.util.List;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.OreDictionary;

public class ItemQuarryModule
extends ItemSubTypes<CraftingTypes>
implements IModelRegister {
    protected static final String NAME = "quarrymodules";

    public ItemQuarryModule() {
        super(CraftingTypes.class);
        this.func_77637_a(IUCore.ModuleTab);
        Register.registerItem(this, IUCore.getIdentifier(NAME)).func_77655_b(NAME);
        IUCore.proxy.addIModelRegister(this);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerModel(Item item, int meta, String extraName) {
        ModelLoader.setCustomModelResourceLocation((Item)this, (int)meta, (ModelResourceLocation)new ModelResourceLocation("industrialupgrade:quarrymodules/" + CraftingTypes.getFromID(meta).func_176610_l(), null));
    }

    public void func_77624_a(@Nonnull ItemStack itemStack, @Nullable World worldIn, @Nonnull List<String> info, @Nonnull ITooltipFlag flagIn) {
        super.func_77624_a(itemStack, worldIn, info, flagIn);
        int meta = itemStack.func_77952_i();
        switch (meta) {
            case 0: {
                info.add(Localization.translate("iu.quarry"));
                info.add(Localization.translate("iu.quarry1"));
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                info.add(Localization.translate("iu.quarry"));
                info.add(Localization.translate("iu.quarry2"));
                break;
            }
            case 12: {
                info.add(Localization.translate("iu.blacklist"));
                NBTTagCompound nbt = ModUtils.nbt(itemStack);
                int size = nbt.func_74762_e("size");
                for (int i = 0; i < size; ++i) {
                    String l = "number_" + i;
                    String ore = ModUtils.NBTGetString(itemStack, l);
                    ItemStack stack = (ItemStack)OreDictionary.getOres((String)ore).get(0);
                    info.add(stack.func_82833_r());
                }
                break;
            }
            case 13: {
                info.add(Localization.translate("iu.whitelist"));
                NBTTagCompound nbt = ModUtils.nbt(itemStack);
                int size = nbt.func_74762_e("size");
                for (int i = 0; i < size; ++i) {
                    String l = "number_" + i;
                    String ore = ModUtils.NBTGetString(itemStack, l);
                    ItemStack stack = (ItemStack)OreDictionary.getOres((String)ore).get(0);
                    info.add(stack.func_82833_r());
                }
                break;
            }
            case 14: {
                info.add(TextFormatting.DARK_PURPLE + Localization.translate("iu.macerator"));
                break;
            }
            case 15: {
                info.add(TextFormatting.DARK_PURPLE + Localization.translate("iu.comb_macerator"));
            }
        }
        EnumQuarryModules enumQuarryModules = EnumQuarryModules.values()[meta];
        if (enumQuarryModules.cost < 0.0) {
            info.add(TextFormatting.GREEN + Localization.translate("iu.quarry_energy1") + (int)(Math.abs(enumQuarryModules.cost) * 100.0) + "%");
        } else if (enumQuarryModules.cost > 0.0) {
            info.add(TextFormatting.RED + Localization.translate("iu.quarry_energy") + (int)(enumQuarryModules.cost * 100.0) + "%");
        }
    }

    public String func_77658_a() {
        return "iu." + super.func_77658_a().substring(3);
    }

    public static enum CraftingTypes implements ISubEnum
    {
        per(0),
        ef(1),
        ef1(2),
        ef2(3),
        ef3(4),
        ef4(5),
        for1(6),
        for2(7),
        for3(8),
        kar1(9),
        kar2(10),
        kar3(11),
        blackmodule(12),
        whitemodule(13),
        macerator(14),
        comb_macerator(15);

        private final String name = this.name().toLowerCase(Locale.US);
        private final int ID;

        private CraftingTypes(int ID) {
            this.ID = ID;
        }

        public static CraftingTypes getFromID(int ID) {
            return CraftingTypes.values()[ID % CraftingTypes.values().length];
        }

        public String func_176610_l() {
            return this.name;
        }

        @Override
        public int getId() {
            return this.ID;
        }
    }
}

