/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.items.energy;

import com.denfop.IUCore;
import com.denfop.api.IModelRegister;
import com.denfop.api.tile.IWrenchable;
import com.denfop.audio.EnumSound;
import com.denfop.register.Register;
import com.denfop.utils.ModUtils;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.GameType;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jetbrains.annotations.NotNull;

public class ItemToolWrench
extends Item
implements IModelRegister {
    private final String name;

    public ItemToolWrench() {
        this("wrench");
    }

    protected ItemToolWrench(String name) {
        this.func_77656_e(120);
        this.func_77625_d(1);
        this.setNoRepair();
        this.func_77637_a(IUCore.EnergyTab);
        this.name = name;
        IUCore.proxy.addIModelRegister(this);
        Register.registerItem(this, IUCore.getIdentifier(name)).func_77655_b(name);
    }

    @SideOnly(value=Side.CLIENT)
    public static ModelResourceLocation getModelLocation(String name) {
        String loc = "industrialupgrade:energy/" + name;
        return new ModelResourceLocation(loc, null);
    }

    @SideOnly(value=Side.CLIENT)
    public static void registerModel(Item item, int meta, String name) {
        ModelLoader.setCustomModelResourceLocation((Item)item, (int)meta, (ModelResourceLocation)ItemToolWrench.getModelLocation(name));
    }

    public static WrenchResult wrenchBlock(World world, BlockPos pos, EnumFacing side, EntityPlayer player, boolean remove) {
        IBlockState state = world.func_180495_p(pos);
        state = state.func_185899_b((IBlockAccess)world, pos);
        Block block = (state = state.func_185899_b((IBlockAccess)world, pos)).func_177230_c();
        if (!block.isAir(state, (IBlockAccess)world, pos)) {
            if (block instanceof IWrenchable) {
                int experience;
                EnumFacing currentFacing;
                IWrenchable wrenchable = (IWrenchable)block;
                EnumFacing newFacing = currentFacing = wrenchable.getFacing(world, pos);
                if (!IUCore.keyboard.isChangeKeyDown(player)) {
                    newFacing = player.func_70093_af() ? side.func_176734_d() : side;
                } else {
                    EnumFacing.Axis axis = side.func_176740_k();
                    if (side.func_176743_c() == EnumFacing.AxisDirection.POSITIVE && !player.func_70093_af() || side.func_176743_c() == EnumFacing.AxisDirection.NEGATIVE && player.func_70093_af()) {
                        newFacing = currentFacing.func_176732_a(axis);
                    } else {
                        for (experience = 0; experience < 3; ++experience) {
                            newFacing = newFacing.func_176732_a(axis);
                        }
                    }
                }
                if (newFacing != currentFacing && wrenchable.setFacing(world, pos, newFacing, player)) {
                    return WrenchResult.Rotated;
                }
                if (remove && wrenchable.wrenchCanRemove(world, pos, player)) {
                    if (!world.field_72995_K) {
                        TileEntity te = world.func_175625_s(pos);
                        if (player instanceof EntityPlayerMP) {
                            experience = ForgeHooks.onBlockBreakEvent((World)world, (GameType)((EntityPlayerMP)player).field_71134_c.func_73081_b(), (EntityPlayerMP)((EntityPlayerMP)player), (BlockPos)pos);
                            if (experience < 0) {
                                return WrenchResult.Nothing;
                            }
                        } else {
                            experience = 0;
                        }
                        block.func_176208_a(world, pos, state, player);
                        if (!block.removedByPlayer(state, world, pos, player, true)) {
                            return WrenchResult.Nothing;
                        }
                        block.func_176206_d(world, pos, state);
                        List<ItemStack> drops = wrenchable.getWrenchDrops(world, pos, state, te, player, 0);
                        if (drops != null && !drops.isEmpty()) {
                            for (ItemStack drop : drops) {
                                ModUtils.dropAsEntity(world, pos, drop);
                            }
                        }
                        wrenchable.wrenchBreak(world, pos);
                        if (!player.field_71075_bZ.field_75098_d && experience > 0) {
                            block.func_180637_b(world, pos, experience);
                        }
                    }
                    return WrenchResult.Removed;
                }
            } else if (block.rotateBlock(world, pos, side)) {
                return WrenchResult.Rotated;
            }
        }
        return WrenchResult.Nothing;
    }

    private static String getTeName(Object te) {
        return te != null ? te.getClass().getSimpleName().replace("TileEntity", "") : "none";
    }

    @SideOnly(value=Side.CLIENT)
    public void registerModels(String name) {
        this.registerModel(0, name, null);
    }

    @SideOnly(value=Side.CLIENT)
    protected void registerModel(int meta, String name, String extraName) {
        ItemToolWrench.registerModel(this, meta, name);
    }

    public boolean canTakeDamage(ItemStack stack, int amount) {
        return true;
    }

    @NotNull
    public EnumActionResult onItemUseFirst(EntityPlayer player, World world, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ, EnumHand hand) {
        ItemStack stack = ModUtils.get(player, hand);
        if (!this.canTakeDamage(stack, 1)) {
            return EnumActionResult.FAIL;
        }
        WrenchResult result = ItemToolWrench.wrenchBlock(world, pos, side, player, this.canTakeDamage(stack, 10));
        if (result != WrenchResult.Nothing) {
            if (!world.field_72995_K) {
                this.damage(stack, result == WrenchResult.Rotated ? 1 : 10, player);
            } else {
                player.func_184185_a(EnumSound.wrench.getSoundEvent(), 1.0f, 1.0f);
            }
            return world.field_72995_K ? EnumActionResult.PASS : EnumActionResult.SUCCESS;
        }
        return EnumActionResult.FAIL;
    }

    public void damage(ItemStack is, int damage, EntityPlayer player) {
        is.func_77972_a(damage, (EntityLivingBase)player);
    }

    @Override
    public void registerModels() {
        this.registerModels(this.name);
    }

    private static enum WrenchResult {
        Rotated,
        Removed,
        Nothing;

    }
}

