/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.items.energy;

import com.denfop.ElectricItem;
import com.denfop.api.item.IEnergyItem;
import com.denfop.items.energy.ItemToolIU;
import com.denfop.utils.ElectricItemManager;
import com.denfop.utils.ModUtils;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class ItemEnergyTool
extends ItemToolIU
implements IEnergyItem {
    public double operationEnergyCost;
    public int maxCharge;
    public int transferLimit;
    public int tier;

    protected ItemEnergyTool(String name, int operationEnergyCost) {
        this(name, 2.0f, -3.0f, operationEnergyCost, new HashSet<Block>());
    }

    private ItemEnergyTool(String name, float damage, float speed, int operationEnergyCost, Set<Block> mineableBlocks) {
        super(name, damage, speed, mineableBlocks);
        this.operationEnergyCost = operationEnergyCost;
        this.func_77656_e(27);
        this.setNoRepair();
    }

    @SideOnly(value=Side.CLIENT)
    public static ModelResourceLocation getModelLocation(String name) {
        String loc = "industrialupgrade:energy_tools/" + name;
        return new ModelResourceLocation(loc, null);
    }

    @Override
    public boolean showDurabilityBar(ItemStack stack) {
        return true;
    }

    @Override
    public int getRGBDurabilityForDisplay(ItemStack stack) {
        return ModUtils.convertRGBcolorToInt(33, 91, 199);
    }

    @Override
    public double getDurabilityForDisplay(ItemStack stack) {
        return Math.min(Math.max(1.0 - ElectricItem.manager.getCharge(stack) / ElectricItem.manager.getMaxCharge(stack), 0.0), 1.0);
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing side, float xOffset, float yOffset, float zOffset) {
        ElectricItem.manager.use(ModUtils.get(player, hand), 0.0, (EntityLivingBase)player);
        return super.func_180614_a(player, world, pos, hand, side, xOffset, yOffset, zOffset);
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        ElectricItem.manager.use(ModUtils.get(player, hand), 0.0, (EntityLivingBase)player);
        return super.func_77659_a(world, player, hand);
    }

    @Override
    public float func_150893_a(ItemStack stack, IBlockState state) {
        return !ElectricItem.manager.canUse(stack, this.operationEnergyCost) ? 1.0f : super.func_150893_a(stack, state);
    }

    public boolean func_77644_a(ItemStack itemstack, EntityLivingBase entityliving, EntityLivingBase entityliving1) {
        return true;
    }

    public int func_77619_b() {
        return 0;
    }

    public boolean isRepairable() {
        return false;
    }

    @Override
    public boolean canProvideEnergy(ItemStack stack) {
        return false;
    }

    @Override
    public double getMaxEnergy(ItemStack stack) {
        return this.maxCharge;
    }

    @Override
    public short getTierItem(ItemStack stack) {
        return (short)this.tier;
    }

    @Override
    public double getTransferEnergy(ItemStack stack) {
        return this.transferLimit;
    }

    public boolean func_179218_a(ItemStack stack, World world, IBlockState state, BlockPos pos, EntityLivingBase user) {
        if (state.func_185887_b(world, pos) != 0.0f) {
            ElectricItem.manager.use(stack, this.operationEnergyCost, user);
        }
        return true;
    }

    public boolean func_82789_a(ItemStack par1ItemStack, ItemStack par2ItemStack) {
        return false;
    }

    public boolean isBookEnchantable(ItemStack itemstack1, ItemStack itemstack2) {
        return false;
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> subItems) {
        if (this.func_194125_a(tab)) {
            ElectricItemManager.addChargeVariants((Item)this, subItems);
        }
    }

    public ItemStack getItemStack(double charge) {
        ItemStack ret = new ItemStack((Item)this);
        ElectricItem.manager.charge(ret, charge, Integer.MAX_VALUE, true, false);
        return ret;
    }

    public ItemStack getItemStack() {
        ItemStack ret = new ItemStack((Item)this);
        ElectricItem.manager.charge(ret, this.maxCharge, Integer.MAX_VALUE, true, false);
        return ret;
    }

    public boolean onDroppedByPlayer(ItemStack item, EntityPlayer player) {
        return true;
    }

    public void setDamage(ItemStack stack, int damage) {
        this.getDamage(stack);
    }
}

