/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.items.energy;

import com.denfop.ElectricItem;
import com.denfop.IUCore;
import com.denfop.Localization;
import com.denfop.api.IModelRegister;
import com.denfop.api.item.IEnergyItem;
import com.denfop.items.BaseEnergyItem;
import com.denfop.utils.ModUtils;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.client.renderer.block.model.ModelBakery;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.input.Keyboard;

public class ItemBattery
extends BaseEnergyItem
implements IModelRegister {
    private static final int maxLevel = 4;
    public final boolean wirelessCharge;
    private final String name1;

    public ItemBattery(String name, double maxCharge, double transferLimit, int tier, boolean wirelessCharge) {
        super(name, maxCharge, transferLimit, tier);
        this.wirelessCharge = wirelessCharge;
        this.name1 = name;
        IUCore.proxy.addIModelRegister(this);
    }

    public ItemBattery(String name, double maxCharge, double transferLimit, int tier) {
        super(name, maxCharge, transferLimit, tier);
        this.wirelessCharge = false;
        this.name1 = name;
        IUCore.proxy.addIModelRegister(this);
    }

    @SideOnly(value=Side.CLIENT)
    public static ModelResourceLocation getModelLocation1(String name, String extraName) {
        String loc = "industrialupgrade:battery/" + name + extraName;
        return new ModelResourceLocation(loc, null);
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        if (this.wirelessCharge) {
            int mode = ModUtils.NBTGetInteger(stack, "mode");
            if (mode > 4 || mode < 0) {
                mode = 0;
            }
            tooltip.add(TextFormatting.GREEN + Localization.translate("message.text.mode") + ": " + Localization.translate("message.battery.mode." + mode));
            if (!Keyboard.isKeyDown((int)42)) {
                tooltip.add(Localization.translate("press.lshift"));
            }
            if (Keyboard.isKeyDown((int)42)) {
                tooltip.add(Localization.translate("iu.changemode_key") + Localization.translate("iu.changemode_rcm1"));
            }
        }
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
    }

    public int func_77619_b() {
        return 0;
    }

    public boolean isBookEnchantable(@Nonnull ItemStack stack, @Nonnull ItemStack book) {
        return false;
    }

    @Override
    public void func_150895_a(@Nonnull CreativeTabs p_150895_1_, @Nonnull NonNullList<ItemStack> var3) {
        if (this.func_194125_a(p_150895_1_)) {
            ItemStack var4 = new ItemStack((Item)this, 1);
            ElectricItem.manager.charge(var4, 2.147483647E9, Integer.MAX_VALUE, true, false);
            var3.add((Object)var4);
            var3.add((Object)new ItemStack((Item)this, 1));
        }
    }

    @Override
    public void registerModels() {
        this.registerModels(this.name1);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerModels(String name) {
        ModelLoader.setCustomMeshDefinition((Item)this, stack -> {
            double damage = ElectricItem.manager.getCharge(stack);
            double maxDamage = ElectricItem.manager.getMaxCharge(stack);
            int level = (int)(4.0 * damage / maxDamage);
            return ItemBattery.getModelLocation1(this.name1, Integer.toString(level));
        });
        for (int level = 0; level <= 4; ++level) {
            ModelBakery.registerItemVariants((Item)this, (ResourceLocation[])new ResourceLocation[]{ItemBattery.getModelLocation1(this.name1, Integer.toString(level))});
        }
    }

    public void func_77663_a(@Nonnull ItemStack itemStack, @Nonnull World p_77663_2_, @Nonnull Entity p_77663_3_, int p_77663_4_, boolean p_77663_5_) {
        if (!(p_77663_3_ instanceof EntityPlayer)) {
            return;
        }
        if (this.wirelessCharge) {
            int mode = ModUtils.NBTGetInteger(itemStack, "mode");
            EntityPlayer entityplayer = (EntityPlayer)p_77663_3_;
            if (mode == 1) {
                if (IUCore.proxy.isSimulating() && entityplayer.func_130014_f_().field_73011_w.getWorldTime() % 40L == 0L) {
                    boolean transferred = false;
                    for (int i = 0; i < 9; ++i) {
                        double transfer;
                        ItemStack stack = (ItemStack)entityplayer.field_71071_by.field_70462_a.get(i);
                        if (stack.func_190926_b() || !(stack.func_77973_b() instanceof IEnergyItem) || stack.func_77973_b() instanceof ItemBattery || (transfer = ElectricItem.manager.discharge(itemStack, 2.0 * this.transferLimit, Integer.MAX_VALUE, true, true, true)) <= 0.0 || (transfer = ElectricItem.manager.charge(stack, transfer, Integer.MAX_VALUE, true, false)) <= 0.0) continue;
                        ElectricItem.manager.discharge(itemStack, transfer, Integer.MAX_VALUE, true, true, false);
                        transferred = true;
                    }
                    if (transferred && !IUCore.proxy.isRendering()) {
                        entityplayer.field_71070_bA.func_75142_b();
                    }
                }
            } else if (mode == 2) {
                if (IUCore.proxy.isSimulating() && entityplayer.func_130014_f_().field_73011_w.getWorldTime() % 40L == 0L) {
                    boolean transferred = false;
                    for (int i = 0; i < entityplayer.field_71071_by.field_70462_a.size(); ++i) {
                        double transfer;
                        ItemStack stack = (ItemStack)entityplayer.field_71071_by.field_70462_a.get(i);
                        if (stack.func_190926_b() || !(stack.func_77973_b() instanceof IEnergyItem) || stack.func_77973_b() instanceof ItemBattery || (transfer = ElectricItem.manager.discharge(itemStack, 2.0 * this.transferLimit, Integer.MAX_VALUE, true, true, true)) <= 0.0 || (transfer = ElectricItem.manager.charge(stack, transfer, Integer.MAX_VALUE, true, false)) <= 0.0) continue;
                        ElectricItem.manager.discharge(itemStack, transfer, Integer.MAX_VALUE, true, true, false);
                        transferred = true;
                    }
                    if (transferred && !IUCore.proxy.isRendering()) {
                        entityplayer.field_71070_bA.func_75142_b();
                    }
                }
            } else if (mode == 3) {
                if (IUCore.proxy.isSimulating() && entityplayer.func_130014_f_().field_73011_w.getWorldTime() % 40L == 0L) {
                    boolean transferred = false;
                    for (int i = 0; i < entityplayer.field_71071_by.field_70460_b.size(); ++i) {
                        double transfer;
                        ItemStack stack = (ItemStack)entityplayer.field_71071_by.field_70460_b.get(i);
                        if (stack.func_190926_b() || !(stack.func_77973_b() instanceof IEnergyItem) || stack.func_77973_b() instanceof ItemBattery || (transfer = ElectricItem.manager.discharge(itemStack, 2.0 * this.transferLimit, Integer.MAX_VALUE, true, true, true)) <= 0.0 || (transfer = ElectricItem.manager.charge(stack, transfer, Integer.MAX_VALUE, true, false)) <= 0.0) continue;
                        ElectricItem.manager.discharge(itemStack, transfer, Integer.MAX_VALUE, true, true, false);
                        transferred = true;
                    }
                    if (transferred && !IUCore.proxy.isRendering()) {
                        entityplayer.field_71070_bA.func_75142_b();
                    }
                }
            } else if (mode == 4) {
                double transfer;
                ItemStack stack;
                int i;
                boolean transferred;
                if (IUCore.proxy.isSimulating() && entityplayer.func_130014_f_().field_73011_w.getWorldTime() % 40L == 0L) {
                    transferred = false;
                    for (i = 0; i < entityplayer.field_71071_by.field_70460_b.size(); ++i) {
                        stack = (ItemStack)entityplayer.field_71071_by.field_70460_b.get(i);
                        if (stack.func_190926_b() || !(stack.func_77973_b() instanceof IEnergyItem) || stack.func_77973_b() instanceof ItemBattery || (transfer = ElectricItem.manager.discharge(itemStack, 2.0 * this.transferLimit, Integer.MAX_VALUE, true, true, true)) <= 0.0 || (transfer = ElectricItem.manager.charge(stack, transfer, Integer.MAX_VALUE, true, false)) <= 0.0) continue;
                        ElectricItem.manager.discharge(itemStack, transfer, Integer.MAX_VALUE, true, true, false);
                        transferred = true;
                    }
                    if (transferred && !IUCore.proxy.isRendering()) {
                        entityplayer.field_71070_bA.func_75142_b();
                    }
                }
                if (IUCore.proxy.isSimulating() && entityplayer.func_130014_f_().field_73011_w.getWorldTime() % 40L == 0L) {
                    transferred = false;
                    for (i = 0; i < entityplayer.field_71071_by.field_70462_a.size(); ++i) {
                        stack = (ItemStack)entityplayer.field_71071_by.field_70462_a.get(i);
                        if (stack.func_190926_b() || !(stack.func_77973_b() instanceof IEnergyItem) || stack.func_77973_b() instanceof ItemBattery || (transfer = ElectricItem.manager.discharge(itemStack, 2.0 * this.transferLimit, Integer.MAX_VALUE, true, true, true)) <= 0.0 || (transfer = ElectricItem.manager.charge(stack, transfer, Integer.MAX_VALUE, true, false)) <= 0.0) continue;
                        ElectricItem.manager.discharge(itemStack, transfer, Integer.MAX_VALUE, true, true, false);
                        transferred = true;
                    }
                    if (transferred && !IUCore.proxy.isRendering()) {
                        entityplayer.field_71070_bA.func_75142_b();
                    }
                }
            }
        }
    }

    @Override
    public boolean canProvideEnergy(ItemStack stack) {
        return true;
    }

    @Nonnull
    public ActionResult<ItemStack> func_77659_a(@Nonnull World world, @Nonnull EntityPlayer player, @Nonnull EnumHand hand) {
        if (IUCore.proxy.isSimulating() && this.wirelessCharge) {
            int mode = ModUtils.NBTGetInteger(player.func_184586_b(hand), "mode");
            if (++mode > 4 || mode < 0) {
                mode = 0;
            }
            ModUtils.NBTSetInteger(player.func_184586_b(hand), "mode", mode);
            IUCore.proxy.messagePlayer(player, TextFormatting.GREEN + Localization.translate("message.text.mode") + ": " + Localization.translate("message.battery.mode." + mode), new Object[0]);
        }
        ItemStack stack = ModUtils.get(player, hand);
        if (!world.field_72995_K && ModUtils.getSize(stack) == 1) {
            if (ElectricItem.manager.getCharge(stack) > 0.0) {
                boolean transferred = false;
                for (int i = 0; i < 9; ++i) {
                    double transfer;
                    ItemStack target = (ItemStack)player.field_71071_by.field_70462_a.get(i);
                    if (target.func_190926_b() || !(target.func_77973_b() instanceof IEnergyItem) || target == stack || ElectricItem.manager.discharge(target, Double.POSITIVE_INFINITY, Integer.MAX_VALUE, true, true, true) > 0.0 || (transfer = ElectricItem.manager.discharge(stack, 2.0 * this.transferLimit, Integer.MAX_VALUE, true, true, true)) <= 0.0 || (transfer = ElectricItem.manager.charge(target, transfer, this.tier, true, false)) <= 0.0) continue;
                    ElectricItem.manager.discharge(stack, transfer, Integer.MAX_VALUE, true, true, false);
                    transferred = true;
                }
                if (transferred) {
                    player.field_71070_bA.func_75142_b();
                }
            }
            return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
        }
        return new ActionResult(EnumActionResult.PASS, (Object)stack);
    }
}

