/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.items.bags;

import com.denfop.container.ContainerBase;
import com.denfop.container.ContainerLeadBox;
import com.denfop.gui.GuiLeadBox;
import com.denfop.invslot.InvSlot;
import com.denfop.items.ItemStackInventory;
import com.denfop.tiles.base.TileEntityInventory;
import com.denfop.utils.ModUtils;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemStackLeadBox
extends ItemStackInventory {
    public final int inventorySize;
    public final ItemStack itemStack1;

    public ItemStackLeadBox(EntityPlayer player, ItemStack stack, int inventorySize) {
        super(player, stack, inventorySize);
        this.inventorySize = inventorySize;
        this.itemStack1 = stack;
    }

    @Override
    public void save() {
        super.save();
    }

    public void saveAndThrow(ItemStack stack) {
        NBTTagList contentList = new NBTTagList();
        for (int i = 0; i < this.inventory.length; ++i) {
            if (ModUtils.isEmpty(this.inventory[i])) continue;
            NBTTagCompound nbt = new NBTTagCompound();
            nbt.func_74774_a("Slot", (byte)i);
            this.inventory[i].func_77955_b(nbt);
            contentList.func_74742_a((NBTBase)nbt);
        }
        ModUtils.nbt(stack).func_74782_a("Items", (NBTBase)contentList);
        this.func_174888_l();
    }

    public ContainerBase<ItemStackLeadBox> getGuiContainer(EntityPlayer player) {
        return new ContainerLeadBox(player, this);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiScreen getGui(EntityPlayer player, boolean isAdmin) {
        return new GuiLeadBox(new ContainerLeadBox(player, this), this.itemStack1);
    }

    public TileEntityInventory getParent() {
        return null;
    }

    @Override
    public void addInventorySlot(InvSlot var1) {
    }

    @Override
    public int getBaseIndex(InvSlot var1) {
        return 0;
    }

    public ItemStack get(int index) {
        return this.inventory[index];
    }

    protected void restore(ItemStack[] backup) {
        if (backup.length != this.inventory.length) {
            throw new IllegalArgumentException("invalid array size");
        }
        System.arraycopy(backup, 0, this.inventory, 0, this.inventory.length);
    }

    @Nonnull
    public String func_70005_c_() {
        return "toolbox";
    }

    public boolean func_145818_k_() {
        return false;
    }

    public int add(Collection<ItemStack> stacks) {
        return this.add(stacks, false);
    }

    public boolean add(ItemStack stack) {
        if (stack == null) {
            throw new NullPointerException("null ItemStack");
        }
        return this.add(Collections.singletonList(stack), false);
    }

    public boolean canAdd(Collection<ItemStack> stacks) {
        return this.add(stacks, true) == 0;
    }

    public boolean canAdd(ItemStack stack) {
        if (stack == null) {
            throw new NullPointerException("null ItemStack");
        }
        return this.add(Collections.singletonList(stack), true);
    }

    protected ItemStack[] backup() {
        ItemStack[] ret = new ItemStack[this.inventory.length];
        for (int i = 0; i < this.inventory.length; ++i) {
            ItemStack content = this.inventory[i];
            ret[i] = ModUtils.isEmpty(content) ? ModUtils.emptyStack : content.func_77946_l();
        }
        return ret;
    }

    public void put(ItemStack content) {
        this.put(0, content);
    }

    public void put(int index, ItemStack content) {
        if (ModUtils.isEmpty(content)) {
            content = ModUtils.emptyStack;
        }
        this.inventory[index] = content;
        this.save();
    }

    public int getStackSizeLimit() {
        return 64;
    }

    private boolean add(List<ItemStack> stacks, boolean simulate) {
        if (stacks != null && !stacks.isEmpty()) {
            for (ItemStack stack : stacks) {
                for (int i = 0; i < this.inventory.length; ++i) {
                    if (this.get(i) == null || this.get(i).func_190926_b()) {
                        if (!simulate) {
                            this.put(i, stack.func_77946_l());
                        }
                        return true;
                    }
                    if (!this.get(i).func_77969_a(stack) || this.get(i).func_190916_E() + stack.func_190916_E() > stack.func_77976_d()) continue;
                    if (stack.func_77978_p() == null && this.get(i).func_77978_p() == null) {
                        if (!simulate) {
                            this.get(i).func_190917_f(stack.func_190916_E());
                        }
                        return true;
                    }
                    if (stack.func_77978_p() == null || !stack.func_77978_p().equals((Object)this.get(i).func_77978_p())) continue;
                    if (!simulate) {
                        this.get(i).func_190917_f(stack.func_190916_E());
                    }
                    return true;
                }
            }
            return false;
        }
        return true;
    }

    private int add(Collection<ItemStack> stacks, boolean simulate) {
        if (stacks != null && !stacks.isEmpty()) {
            ItemStack[] backup = simulate ? this.backup() : null;
            int totalAmount = 0;
            Iterator<ItemStack> var5 = stacks.iterator();
            while (true) {
                if (!var5.hasNext()) {
                    if (simulate) {
                        this.restore(backup);
                    }
                    return totalAmount;
                }
                ItemStack stack = var5.next();
                int amount = ModUtils.getSize(stack);
                if (amount <= 0) continue;
                block1: for (int pass = 0; pass < 2; ++pass) {
                    for (int i = 0; i < this.inventorySize; ++i) {
                        ItemStack existingStack = this.get(i);
                        int space = this.getStackSizeLimit();
                        if (!ModUtils.isEmpty(existingStack)) {
                            space = Math.min(space, existingStack.func_77976_d()) - ModUtils.getSize(existingStack);
                        }
                        if (space <= 0) continue;
                        if (pass == 0 && !ModUtils.isEmpty(existingStack) && ModUtils.checkItemEqualityStrict(stack, existingStack)) {
                            if (space >= amount) {
                                existingStack.func_190917_f(amount);
                                this.put(i, existingStack);
                                amount = 0;
                                break block1;
                            }
                            existingStack.func_190917_f(space);
                            this.put(i, existingStack);
                            amount -= space;
                            continue;
                        }
                        if (pass != 1 || !ModUtils.isEmpty(existingStack)) continue;
                        if (space >= amount) {
                            this.put(i, ModUtils.setSize(stack, amount));
                            amount = 0;
                            break block1;
                        }
                        this.put(i, ModUtils.setSize(stack, space));
                        amount -= space;
                    }
                }
                totalAmount += amount;
            }
        }
        return 0;
    }
}

