/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.items.armour;

import com.denfop.ElectricItem;
import com.denfop.IUCore;
import com.denfop.api.IModelRegister;
import com.denfop.api.item.IEnergyItem;
import com.denfop.items.armour.ItemArmorUtility;
import com.denfop.register.Register;
import com.denfop.utils.ElectricItemManager;
import com.denfop.utils.KeyboardClient;
import com.denfop.utils.ModUtils;
import java.util.List;
import net.minecraft.client.renderer.block.model.ModelBakery;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.input.Keyboard;

public class ItemArmorNightvisionGoggles
extends ItemArmorUtility
implements IModelRegister,
IEnergyItem {
    public ItemArmorNightvisionGoggles() {
        super("nightvision", EntityEquipmentSlot.HEAD);
        this.armorName = "nightvision_goggles";
        this.func_77655_b(this.armorName);
        this.func_77637_a(IUCore.EnergyTab);
        Register.registerItem(this, IUCore.getIdentifier(this.armorName)).func_77655_b(this.armorName);
        IUCore.proxy.addIModelRegister(this);
        this.setNoRepair();
    }

    @Override
    public boolean showDurabilityBar(ItemStack stack) {
        return true;
    }

    @Override
    public int getRGBDurabilityForDisplay(ItemStack stack) {
        return ModUtils.convertRGBcolorToInt(33, 91, 199);
    }

    @Override
    public double getDurabilityForDisplay(ItemStack stack) {
        return Math.min(Math.max(1.0 - ElectricItem.manager.getCharge(stack) / ElectricItem.manager.getMaxCharge(stack), 0.0), 1.0);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack p_77624_1_, @Nullable World p_77624_2_, List<String> p_77624_3_, ITooltipFlag p_77624_4_) {
        p_77624_3_.add("Nightvision Key: " + Keyboard.getKeyName((int)Math.abs(KeyboardClient.armormode.func_151463_i())));
        super.func_77624_a(p_77624_1_, p_77624_2_, p_77624_3_, p_77624_4_);
    }

    @Override
    public boolean canProvideEnergy(ItemStack stack) {
        return false;
    }

    @Override
    public double getMaxEnergy(ItemStack stack) {
        return 200000.0;
    }

    @Override
    public short getTierItem(ItemStack stack) {
        return 1;
    }

    @Override
    public double getTransferEnergy(ItemStack stack) {
        return 200.0;
    }

    @Override
    public void registerModels() {
        this.registerModels(this.armorName);
    }

    @SideOnly(value=Side.CLIENT)
    public void registerModels(String name) {
        String[] mode;
        ModelLoader.setCustomMeshDefinition((Item)this, stack -> {
            NBTTagCompound nbt = ModUtils.nbt(stack);
            String mode = nbt.func_74779_i("mode");
            if (nbt.func_74779_i("mode").equals("")) {
                return ItemArmorNightvisionGoggles.getModelLocation1(name, "");
            }
            return ItemArmorNightvisionGoggles.getModelLocation1("armor", "_" + this.field_77881_a.ordinal() + "_" + mode);
        });
        for (String s : mode = new String[]{"", "_Zelen", "_Demon", "_Dark", "_Cold", "_Ender", "_Ukraine", "_Fire", "_Snow", "_Taiga", "_Desert", "_Emerald"}) {
            if (s.equals("")) {
                ModelBakery.registerItemVariants((Item)this, (ResourceLocation[])new ResourceLocation[]{ItemArmorNightvisionGoggles.getModelLocation1(name, s)});
                continue;
            }
            ModelBakery.registerItemVariants((Item)this, (ResourceLocation[])new ResourceLocation[]{ItemArmorNightvisionGoggles.getModelLocation1("nightvision", "_" + this.field_77881_a.ordinal() + s)});
        }
    }

    @Override
    public String getArmorTexture(ItemStack stack, Entity entity, EntityEquipmentSlot slot, String type) {
        int suffix = this.field_77881_a == EntityEquipmentSlot.LEGS ? 2 : 1;
        NBTTagCompound nbtData = ModUtils.nbt(stack);
        if (!nbtData.func_74779_i("mode").isEmpty()) {
            return "industrialupgrade:textures/armor/armor" + this.field_77881_a.ordinal() + "_" + nbtData.func_74779_i("mode") + ".png";
        }
        return "industrialupgrade:textures/armor/" + this.armorName + "_" + suffix + ".png";
    }

    public void onArmorTick(World world, EntityPlayer player, ItemStack stack) {
        NBTTagCompound nbtData = ModUtils.nbt(stack);
        boolean active = nbtData.func_74767_n("active");
        byte toggleTimer = nbtData.func_74771_c("toggleTimer");
        if (IUCore.keyboard.isArmorKey(player) && toggleTimer == 0) {
            toggleTimer = 10;
            boolean bl = active = !active;
            if (IUCore.proxy.isSimulating()) {
                nbtData.func_74757_a("active", active);
                if (active) {
                    IUCore.proxy.messagePlayer(player, "Nightvision enabled.", new Object[0]);
                } else {
                    IUCore.proxy.messagePlayer(player, "Nightvision disabled.", new Object[0]);
                }
            }
        }
        if (IUCore.proxy.isSimulating() && toggleTimer > 0) {
            toggleTimer = (byte)(toggleTimer - 1);
            nbtData.func_74774_a("toggleTimer", toggleTimer);
        }
        boolean ret = false;
        if (active && IUCore.proxy.isSimulating() && ElectricItem.manager.use(stack, 1.0, (EntityLivingBase)player)) {
            int skylight = player.func_130014_f_().func_175671_l(new BlockPos((Entity)player));
            if (skylight > 8) {
                IUCore.proxy.removePotion((EntityLivingBase)player, MobEffects.field_76439_r);
                player.func_70690_d(new PotionEffect(MobEffects.field_76440_q, 100, 0, true, true));
            } else {
                IUCore.proxy.removePotion((EntityLivingBase)player, MobEffects.field_76440_q);
                player.func_70690_d(new PotionEffect(MobEffects.field_76439_r, 300, 0, true, true));
            }
            ret = true;
        }
        if (ret) {
            player.field_71069_bz.func_75142_b();
        }
    }

    public void func_150895_a(CreativeTabs tab, @NotNull NonNullList<ItemStack> subItems) {
        if (this.func_194125_a(tab)) {
            ElectricItemManager.addChargeVariants((Item)this, subItems);
        }
    }

    @Override
    public boolean func_82789_a(ItemStack par1ItemStack, ItemStack par2ItemStack) {
        return false;
    }
}

