/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.items.armour;

import com.denfop.ElectricItem;
import com.denfop.api.item.IEnergyItem;
import com.denfop.items.armour.ItemArmorBase;
import com.denfop.utils.ElectricItemManager;
import com.denfop.utils.ModUtils;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.NonNullList;
import net.minecraftforge.common.ISpecialArmor;
import org.jetbrains.annotations.NotNull;

public abstract class ItemArmorEnergy
extends ItemArmorBase
implements ISpecialArmor,
IEnergyItem {
    protected final double maxCharge;
    protected final double transferLimit;
    protected final int tier;

    public ItemArmorEnergy(String armorName, EntityEquipmentSlot armorType, double maxCharge, double transferLimit, int tier) {
        super(ItemArmor.ArmorMaterial.DIAMOND, armorName, armorType);
        this.maxCharge = maxCharge;
        this.tier = tier;
        this.transferLimit = transferLimit;
        this.func_77625_d(1);
        this.setNoRepair();
        this.func_77656_e(0);
    }

    @Override
    public boolean showDurabilityBar(ItemStack stack) {
        return true;
    }

    @Override
    public int getRGBDurabilityForDisplay(ItemStack stack) {
        return ModUtils.convertRGBcolorToInt(33, 91, 199);
    }

    @Override
    public double getDurabilityForDisplay(ItemStack stack) {
        return Math.min(Math.max(1.0 - ElectricItem.manager.getCharge(stack) / ElectricItem.manager.getMaxCharge(stack), 0.0), 1.0);
    }

    public int func_77619_b() {
        return 0;
    }

    public boolean func_77616_k(ItemStack stack) {
        return false;
    }

    public boolean isBookEnchantable(ItemStack stack, ItemStack book) {
        return false;
    }

    public void func_150895_a(CreativeTabs tab, @NotNull NonNullList<ItemStack> subItems) {
        if (this.func_194125_a(tab)) {
            ElectricItemManager.addChargeVariants((Item)this, subItems);
        }
    }

    public ISpecialArmor.ArmorProperties getProperties(EntityLivingBase player, @NotNull ItemStack armor, DamageSource source, double damage, int slot) {
        if (source.func_76363_c()) {
            return new ISpecialArmor.ArmorProperties(0, 0.0, 0);
        }
        double absorptionRatio = this.getBaseAbsorptionRatio() * this.getDamageAbsorptionRatio();
        int energyPerDamage = this.getEnergyPerDamage();
        int damageLimit = Integer.MAX_VALUE;
        if (energyPerDamage > 0) {
            damageLimit = (int)Math.min((double)damageLimit, 25.0 * ElectricItem.manager.getCharge(armor) / (double)energyPerDamage);
        }
        return new ISpecialArmor.ArmorProperties(0, absorptionRatio, damageLimit);
    }

    public int getArmorDisplay(EntityPlayer player, ItemStack armor, int slot) {
        return ElectricItem.manager.getCharge(armor) >= (double)this.getEnergyPerDamage() ? (int)Math.round(20.0 * this.getBaseAbsorptionRatio() * this.getDamageAbsorptionRatio()) : 0;
    }

    public void damageArmor(EntityLivingBase entity, ItemStack stack, DamageSource source, int damage, int slot) {
        ElectricItem.manager.discharge(stack, damage * this.getEnergyPerDamage(), Integer.MAX_VALUE, true, false, false);
    }

    @Override
    public boolean canProvideEnergy(ItemStack stack) {
        return false;
    }

    @Override
    public double getMaxEnergy(ItemStack stack) {
        return this.maxCharge;
    }

    @Override
    public short getTierItem(ItemStack stack) {
        return (short)this.tier;
    }

    @Override
    public double getTransferEnergy(ItemStack stack) {
        return this.transferLimit;
    }

    public boolean func_82789_a(ItemStack par1ItemStack, ItemStack par2ItemStack) {
        return false;
    }

    public abstract double getDamageAbsorptionRatio();

    public abstract int getEnergyPerDamage();

    protected final double getBaseAbsorptionRatio() {
        switch (this.field_77881_a) {
            case HEAD: 
            case FEET: {
                return 0.15;
            }
            case CHEST: {
                return 0.4;
            }
            case LEGS: {
                return 0.3;
            }
        }
        return 0.0;
    }
}

