/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.items;

import com.denfop.IUCore;
import com.denfop.IUItem;
import com.denfop.Localization;
import com.denfop.api.IModelRegister;
import com.denfop.api.inv.IAdvInventory;
import com.denfop.api.upgrades.IUpgradeItem;
import com.denfop.api.upgrades.UpgradableProperty;
import com.denfop.api.upgrades.UpgradeRegistry;
import com.denfop.blocks.ISubEnum;
import com.denfop.items.IItemStackInventory;
import com.denfop.items.ItemStackUpgradeModules;
import com.denfop.items.resource.ItemSubTypes;
import com.denfop.network.packet.CustomPacketBuffer;
import com.denfop.network.packet.IUpdatableItemStackEvent;
import com.denfop.register.Register;
import com.denfop.utils.ModUtils;
import java.text.DecimalFormat;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jetbrains.annotations.Nullable;

public class ItemUpgradeModule
extends ItemSubTypes<Types>
implements IModelRegister,
IUpgradeItem,
IItemStackInventory,
IUpdatableItemStackEvent {
    protected static final String NAME = "upgrades";
    private static final DecimalFormat decimalformat = new DecimalFormat("0.##");

    public ItemUpgradeModule() {
        super(Types.class);
        this.func_77637_a(IUCore.UpgradeTab);
        IUItem.overclockerUpgrade_1 = UpgradeRegistry.register(new ItemStack((Item)this, 1, Type.Overclocker1.ordinal()));
        IUItem.overclockerUpgrade1 = UpgradeRegistry.register(new ItemStack((Item)this, 1, Type.Overclocker2.ordinal()));
        IUItem.tranformerUpgrade = UpgradeRegistry.register(new ItemStack((Item)this, 1, Type.transformer.ordinal()));
        IUItem.tranformerUpgrade1 = UpgradeRegistry.register(new ItemStack((Item)this, 1, Type.transformer1.ordinal()));
        IUItem.lap_energystorage_upgrade = UpgradeRegistry.register(new ItemStack((Item)this, 1, Type.storage.ordinal()));
        IUItem.adv_lap_energystorage_upgrade = UpgradeRegistry.register(new ItemStack((Item)this, 1, Type.adv_storage.ordinal()));
        IUItem.imp_lap_energystorage_upgrade = UpgradeRegistry.register(new ItemStack((Item)this, 1, Type.imp_storage.ordinal()));
        IUItem.per_lap_energystorage_upgrade = UpgradeRegistry.register(new ItemStack((Item)this, 1, Type.per_storage.ordinal()));
        IUItem.fluidpullingUpgrade = UpgradeRegistry.register(new ItemStack((Item)this, 1, Type.fluid_pulling.ordinal()));
        IUItem.overclockerUpgrade = UpgradeRegistry.register(new ItemStack((Item)this, 1, Type.overclocker.ordinal()));
        IUItem.transformerUpgrade = UpgradeRegistry.register(new ItemStack((Item)this, 1, Type.transformer_simple.ordinal()));
        IUItem.energyStorageUpgrade = UpgradeRegistry.register(new ItemStack((Item)this, 1, Type.energy_storage.ordinal()));
        IUItem.ejectorUpgrade = UpgradeRegistry.register(new ItemStack((Item)this, 1, Type.ejector.ordinal()));
        IUItem.fluidEjectorUpgrade = UpgradeRegistry.register(new ItemStack((Item)this, 1, Type.fluid_ejector.ordinal()));
        IUItem.pullingUpgrade = UpgradeRegistry.register(new ItemStack((Item)this, 1, Type.pulling.ordinal()));
        Register.registerItem(this, IUCore.getIdentifier(NAME)).func_77655_b(NAME);
        IUCore.proxy.addIModelRegister(this);
    }

    public static Type getType(int meta) {
        if (meta < 0 || meta >= Type.Values.length) {
            return null;
        }
        return Type.Values[meta];
    }

    private static EnumFacing getDirection(ItemStack stack) {
        byte rawDir = ModUtils.nbt(stack).func_74771_c("dir");
        if (rawDir < 1 || rawDir > 6) {
            return null;
        }
        return EnumFacing.field_82609_l[rawDir - 1];
    }

    private static String getSideName(ItemStack stack) {
        EnumFacing dir = ItemUpgradeModule.getDirection(stack);
        if (dir == null) {
            return "iu.tooltip.upgrade.ejector.anyside";
        }
        switch (dir) {
            case WEST: {
                return "iu.dir.west";
            }
            case EAST: {
                return "iu.dir.east";
            }
            case DOWN: {
                return "iu.dir.bottom";
            }
            case UP: {
                return "iu.dir.top";
            }
            case NORTH: {
                return "iu.dir.north";
            }
            case SOUTH: {
                return "iu.dir.south";
            }
        }
        throw new RuntimeException("invalid dir: " + dir);
    }

    @Override
    public boolean isSuitableFor(ItemStack stack, Set<UpgradableProperty> types) {
        Type type = ItemUpgradeModule.getType(stack.func_77952_i());
        if (type == null) {
            return false;
        }
        switch (type) {
            case overclocker: 
            case Overclocker1: 
            case Overclocker2: {
                return types.contains((Object)UpgradableProperty.Processing);
            }
            case transformer: 
            case transformer1: 
            case transformer_simple: {
                return types.contains((Object)UpgradableProperty.Transformer);
            }
            case storage: 
            case adv_storage: 
            case imp_storage: 
            case per_storage: 
            case energy_storage: {
                return types.contains((Object)UpgradableProperty.EnergyStorage);
            }
            case ejector: {
                return types.contains((Object)UpgradableProperty.ItemConsuming);
            }
            case pulling: {
                return types.contains((Object)UpgradableProperty.ItemProducing);
            }
            case fluid_ejector: {
                return types.contains((Object)UpgradableProperty.FluidConsuming);
            }
            case fluid_pulling: {
                return types.contains((Object)UpgradableProperty.FluidProducing);
            }
        }
        return false;
    }

    @Override
    public int getExtraTier(ItemStack itemStack) {
        Type type = ItemUpgradeModule.getType(itemStack.func_77952_i());
        if (type == null) {
            return 0;
        }
        switch (type) {
            case transformer_simple: {
                return 1;
            }
            case transformer: {
                return 2;
            }
            case transformer1: {
                return 4;
            }
        }
        return 0;
    }

    @Override
    public double getProcessTimeMultiplier(ItemStack itemStack) {
        Type type = ItemUpgradeModule.getType(itemStack.func_77952_i());
        if (type == null) {
            return 1.0;
        }
        switch (type) {
            case overclocker: {
                return 0.6;
            }
            case Overclocker1: {
                return 0.5;
            }
            case Overclocker2: {
                return 0.4;
            }
        }
        return 1.0;
    }

    @Override
    public double getExtraEnergyStorage(ItemStack stack) {
        Types type = (Types)this.getType(stack);
        if (type == null) {
            return 0.0;
        }
        switch (type) {
            case energy_storage: {
                return 10000.0;
            }
            case storageUpgrade: {
                return 100000.0;
            }
            case adv_storageUpgrade: {
                return 1000000.0;
            }
            case imp_storageUpgrade: {
                return 1.0E7;
            }
            case per_storageUpgrade: {
                return 1.0E8;
            }
        }
        return 0.0;
    }

    @Override
    public double getEnergyDemandMultiplier(ItemStack itemStack) {
        Type type = ItemUpgradeModule.getType(itemStack.func_77952_i());
        if (type == null) {
            return 1.0;
        }
        switch (type) {
            case overclocker: 
            case Overclocker1: {
                return 1.3;
            }
            case Overclocker2: {
                return 1.2;
            }
        }
        return 1.0;
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, @Nonnull List<String> list, @Nonnull ITooltipFlag flagIn) {
        Type type = ItemUpgradeModule.getType(stack.func_77952_i());
        if (type == null) {
            return;
        }
        super.func_77624_a(stack, worldIn, list, flagIn);
        switch (type) {
            case overclocker: 
            case Overclocker1: 
            case Overclocker2: {
                list.add(Localization.translate("iu.tooltip.upgrade.overclocker.time", decimalformat.format(100.0 * Math.pow(this.getProcessTimeMultiplier(stack), stack.func_190916_E()))));
                list.add(Localization.translate("iu.tooltip.upgrade.overclocker.power", decimalformat.format(100.0 * Math.pow(this.getEnergyDemandMultiplier(stack), stack.func_190916_E()))));
                break;
            }
            case ejector: 
            case fluid_ejector: {
                String side = ItemUpgradeModule.getSideName(stack);
                list.add(Localization.translate("iu.tooltip.upgrade.ejector", Localization.translate(side)));
                break;
            }
            case pulling: 
            case fluid_pulling: {
                String side = ItemUpgradeModule.getSideName(stack);
                list.add(Localization.translate("iu.tooltip.upgrade.pulling", Localization.translate(side)));
                break;
            }
            case transformer: 
            case transformer1: 
            case transformer_simple: {
                list.add(Localization.translate("iu.tooltip.upgrade.transformer", this.getExtraTier(stack) * stack.func_190916_E()));
                break;
            }
            case storage: 
            case adv_storage: 
            case imp_storage: 
            case per_storage: 
            case energy_storage: {
                list.add(Localization.translate("iu.tooltip.upgrade.storage", this.getExtraEnergyStorage(stack) * (double)ModUtils.getSize(stack)));
            }
        }
    }

    public String func_77658_a() {
        return "iu." + super.func_77658_a().substring(3);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerModel(Item item, int meta, String extraName) {
        ModelLoader.setCustomModelResourceLocation((Item)this, (int)meta, (ModelResourceLocation)new ModelResourceLocation("industrialupgrade:upgrades/" + Types.getFromID(meta).func_176610_l(), null));
    }

    @Override
    public IAdvInventory getInventory(EntityPlayer var1, ItemStack var2) {
        if (var2.func_77952_i() < 11) {
            return null;
        }
        return new ItemStackUpgradeModules(var1, var2);
    }

    public void save(ItemStack stack, EntityPlayer player) {
        NBTTagCompound nbt = ModUtils.nbt(stack);
        nbt.func_74757_a("open", true);
        nbt.func_74768_a("slot_inventory", player.field_71071_by.field_70461_c);
    }

    @Nonnull
    public ActionResult<ItemStack> func_77659_a(@Nonnull World world, EntityPlayer player, @Nonnull EnumHand hand) {
        ItemStack stack = ModUtils.get(player, hand);
        if (IUCore.proxy.isSimulating() && stack.func_77952_i() >= 11) {
            this.save(stack, player);
            player.openGui((Object)IUCore.instance, 1, world, (int)player.field_70165_t, (int)player.field_70163_u, (int)player.field_70161_v);
            return new ActionResult(EnumActionResult.SUCCESS, (Object)player.func_184586_b(hand));
        }
        return new ActionResult(EnumActionResult.PASS, (Object)player.func_184586_b(hand));
    }

    @Override
    public void updateField(String name, CustomPacketBuffer buffer, ItemStack stack) {
    }

    @Override
    public void updateEvent(int event, ItemStack stack) {
        NBTTagCompound nbt = ModUtils.nbt(stack);
        byte event1 = (byte)event;
        nbt.func_74774_a("dir", event1);
    }

    public static enum Types implements ISubEnum
    {
        overclockerUpgrade1(0),
        overclockerUpgrade2(1),
        transformerUpgrade1(2),
        transformerUpgrade2(3),
        storageUpgrade(4),
        adv_storageUpgrade(5),
        imp_storageUpgrade(6),
        per_storageUpgrade(7),
        overclocker(8),
        transformer(9),
        energy_storage(10),
        ejector(11),
        pulling(12),
        fluid_ejector(13),
        fluid_pulling(14);

        private final String name = this.name().toLowerCase(Locale.US);
        private final int ID;

        private Types(int ID) {
            this.ID = ID;
        }

        public static Types getFromID(int ID) {
            return Types.values()[ID % Types.values().length];
        }

        public String func_176610_l() {
            return this.name;
        }

        @Override
        public int getId() {
            return this.ID;
        }
    }

    private static enum Type {
        Overclocker1,
        Overclocker2,
        transformer,
        transformer1,
        storage,
        adv_storage,
        imp_storage,
        per_storage,
        overclocker,
        transformer_simple,
        energy_storage,
        ejector,
        pulling,
        fluid_ejector,
        fluid_pulling;

        public static final Type[] Values;

        static {
            Values = Type.values();
        }
    }
}

