/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.items;

import com.denfop.IUCore;
import com.denfop.api.inv.IAdvInventory;
import com.denfop.utils.ModUtils;
import java.util.Arrays;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;

public abstract class ItemStackInventory
implements IAdvInventory {
    public final EntityPlayer player;
    protected final ItemStack[] inventory;
    protected ItemStack containerStack;
    private boolean cleared;

    public ItemStackInventory(EntityPlayer player, ItemStack containerStack, int inventorySize) {
        this.containerStack = containerStack;
        this.inventory = new ItemStack[inventorySize];
        Arrays.fill(this.inventory, ItemStack.field_190927_a);
        this.player = player;
        if (IUCore.proxy.isSimulating()) {
            NBTTagCompound nbt = ModUtils.nbt(containerStack);
            if (!nbt.func_150297_b("uid", 3)) {
                nbt.func_74768_a("uid", IUCore.random.nextInt());
            }
            NBTTagList contentList = nbt.func_150295_c("Items", 10);
            for (int i = 0; i < contentList.func_74745_c(); ++i) {
                NBTTagCompound slotNbt = contentList.func_150305_b(i);
                byte slot = slotNbt.func_74771_c("Slot");
                if (slot < 0 || slot >= this.inventory.length) continue;
                this.inventory[slot] = new ItemStack(slotNbt);
            }
        }
    }

    public int func_70302_i_() {
        return this.inventory.length;
    }

    public boolean func_191420_l() {
        for (ItemStack stack : this.inventory) {
            if (ModUtils.isEmpty(stack)) continue;
            return false;
        }
        return true;
    }

    public ItemStack func_70301_a(int slot) {
        return this.inventory[slot];
    }

    public ItemStack func_70298_a(int index, int amount) {
        ItemStack stack;
        if (index >= 0 && index < this.inventory.length && !ModUtils.isEmpty(stack = this.inventory[index])) {
            ItemStack ret;
            if (amount >= ModUtils.getSize(stack)) {
                ret = stack;
                this.inventory[index] = ModUtils.emptyStack;
            } else {
                ret = ModUtils.setSize(stack, amount);
                this.inventory[index] = ModUtils.decSize(stack, amount);
            }
            this.save();
            return ret;
        }
        return ModUtils.emptyStack;
    }

    public void func_70299_a(int slot, ItemStack stack) {
        if (!ModUtils.isEmpty(stack) && ModUtils.getSize(stack) > this.func_70297_j_()) {
            stack = ModUtils.setSize(stack, this.func_70297_j_());
        }
        this.inventory[slot] = ModUtils.isEmpty(stack) ? ModUtils.emptyStack : stack;
        this.save();
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_94041_b(int slot, ItemStack stack1) {
        return false;
    }

    public void func_70296_d() {
        this.save();
    }

    public boolean func_70300_a(EntityPlayer player) {
        return player == this.player && this.getPlayerInventoryIndex() >= -1;
    }

    public void func_174889_b(EntityPlayer player) {
    }

    public void func_174886_c(EntityPlayer player) {
    }

    public ItemStack func_70304_b(int index) {
        ItemStack ret = this.func_70301_a(index);
        if (!ModUtils.isEmpty(ret)) {
            this.func_70299_a(index, ItemStack.field_190927_a);
        }
        return ret;
    }

    public int func_174887_a_(int id) {
        return 0;
    }

    public void func_174885_b(int id, int value) {
    }

    public int func_174890_g() {
        return 0;
    }

    public ITextComponent func_145748_c_() {
        return new TextComponentString(this.func_70005_c_());
    }

    public boolean isThisContainer(ItemStack stack) {
        if (!ModUtils.isEmpty(stack) && stack.func_77973_b() == this.containerStack.func_77973_b()) {
            NBTTagCompound nbt = stack.func_77978_p();
            return nbt != null && nbt.func_74762_e("uid") == this.getUid();
        }
        return false;
    }

    protected int getUid() {
        NBTTagCompound nbt = ModUtils.nbt(this.containerStack);
        return nbt.func_74762_e("uid");
    }

    protected int getPlayerInventoryIndex() {
        for (int i = -1; i < this.player.field_71071_by.func_70302_i_(); ++i) {
            ItemStack stack;
            ItemStack itemStack = stack = i == -1 ? this.player.field_71071_by.func_70445_o() : this.player.field_71071_by.func_70301_a(i);
            if (!this.isThisContainer(stack)) continue;
            return i;
        }
        return Integer.MIN_VALUE;
    }

    protected void save() {
        if (IUCore.proxy.isSimulating() && !this.cleared) {
            int idx;
            boolean dropItself = false;
            for (int i = 0; i < this.inventory.length; ++i) {
                if (!this.isThisContainer(this.inventory[i])) continue;
                this.inventory[i] = null;
                dropItself = true;
            }
            NBTTagList contentList = new NBTTagList();
            for (idx = 0; idx < this.inventory.length; ++idx) {
                if (ModUtils.isEmpty(this.inventory[idx])) continue;
                NBTTagCompound nbt = new NBTTagCompound();
                nbt.func_74774_a("Slot", (byte)idx);
                this.inventory[idx].func_77955_b(nbt);
                contentList.func_74742_a((NBTBase)nbt);
            }
            ModUtils.nbt(this.containerStack).func_74782_a("Items", (NBTBase)contentList);
            this.containerStack = ModUtils.setSize(this.containerStack, 1);
            if (dropItself) {
                ModUtils.dropAsEntity(this.player.func_130014_f_(), this.player.func_180425_c(), this.containerStack);
                this.func_174888_l();
            } else {
                idx = this.getPlayerInventoryIndex();
                if (idx < -1) {
                    this.func_174888_l();
                } else if (idx == -1) {
                    this.player.field_71071_by.func_70437_b(this.containerStack);
                } else {
                    this.player.field_71071_by.func_70299_a(idx, this.containerStack);
                }
            }
        }
    }

    public void saveAsThrown(ItemStack stack) {
        assert (IUCore.proxy.isSimulating());
        NBTTagList contentList = new NBTTagList();
        for (int i = 0; i < this.inventory.length; ++i) {
            if (ModUtils.isEmpty(this.inventory[i]) || this.isThisContainer(this.inventory[i])) continue;
            NBTTagCompound nbt = new NBTTagCompound();
            nbt.func_74774_a("Slot", (byte)i);
            this.inventory[i].func_77955_b(nbt);
            contentList.func_74742_a((NBTBase)nbt);
        }
        ModUtils.nbt(stack).func_74782_a("Items", (NBTBase)contentList);
        assert (ModUtils.nbt(stack).func_74762_e("uid") == 0);
        this.func_174888_l();
    }

    public void func_174888_l() {
        Arrays.fill(this.inventory, ItemStack.field_190927_a);
        this.cleared = true;
    }
}

