/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.items;

import com.denfop.IUCore;
import com.denfop.IUItem;
import com.denfop.api.IModelRegister;
import com.denfop.items.CellType;
import com.denfop.items.resource.ItemSubTypes;
import com.denfop.register.Register;
import com.denfop.utils.ModUtils;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidBlock;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jetbrains.annotations.NotNull;

public class ItemCell
extends ItemSubTypes<CellType>
implements IModelRegister {
    protected static final String NAME = "itemcell";

    public ItemCell() {
        super(CellType.class);
        this.func_77637_a(IUCore.ItemTab);
        this.func_77625_d(64);
        Register.registerItem(this, IUCore.getIdentifier(NAME)).func_77655_b(NAME);
        IUCore.proxy.addIModelRegister(this);
        IUItem.uuMatterCell = new ItemStack((Item)this, 1, 1);
        IUItem.HeliumCell = new ItemStack((Item)this, 1, 2);
        IUItem.NeftCell = new ItemStack((Item)this, 1, 3);
        IUItem.BenzCell = new ItemStack((Item)this, 1, 4);
        IUItem.DizelCell = new ItemStack((Item)this, 1, 5);
        IUItem.PolyethCell = new ItemStack((Item)this, 1, 6);
        IUItem.PolypropCell = new ItemStack((Item)this, 1, 7);
        IUItem.OxyCell = new ItemStack((Item)this, 1, 8);
        IUItem.HybCell = new ItemStack((Item)this, 1, 9);
    }

    @Override
    public String func_77653_i(ItemStack stack) {
        return I18n.func_74838_a((String)this.func_77667_c(stack).replace("iu.iucell", "iu.itemcell"));
    }

    public boolean tryPlaceContainedLiquid(FluidStack fs, @Nullable EntityPlayer player, World worldIn, BlockPos posIn) {
        Object containedBlock = fs.getFluid() == FluidRegistry.WATER ? Blocks.field_150358_i : (fs.getFluid() == FluidRegistry.LAVA ? Blocks.field_150356_k : fs.getFluid().getBlock());
        if (containedBlock == Blocks.field_150350_a) {
            return false;
        }
        IBlockState iblockstate = worldIn.func_180495_p(posIn);
        Material material = iblockstate.func_185904_a();
        boolean flag = !material.func_76220_a();
        boolean flag1 = iblockstate.func_177230_c().func_176200_f((IBlockAccess)worldIn, posIn);
        if (!(worldIn.func_175623_d(posIn) || flag || flag1)) {
            return false;
        }
        if (worldIn.field_73011_w.func_177500_n() && containedBlock == Blocks.field_150358_i) {
            int l = posIn.func_177958_n();
            int i = posIn.func_177956_o();
            int j = posIn.func_177952_p();
            worldIn.func_184133_a(player, posIn, SoundEvents.field_187646_bt, SoundCategory.BLOCKS, 0.5f, 2.6f + (worldIn.field_73012_v.nextFloat() - worldIn.field_73012_v.nextFloat()) * 0.8f);
            for (int k = 0; k < 8; ++k) {
                worldIn.func_175688_a(EnumParticleTypes.SMOKE_LARGE, (double)l + Math.random(), (double)i + Math.random(), (double)j + Math.random(), 0.0, 0.0, 0.0, new int[0]);
            }
        } else {
            if (!worldIn.field_72995_K && (flag || flag1) && !material.func_76224_d()) {
                worldIn.func_175655_b(posIn, true);
            }
            SoundEvent soundevent = containedBlock == Blocks.field_150356_k ? SoundEvents.field_187627_L : SoundEvents.field_187624_K;
            worldIn.func_184133_a(player, posIn, soundevent, SoundCategory.BLOCKS, 1.0f, 1.0f);
            worldIn.func_180501_a(posIn, containedBlock.func_176223_P(), 11);
        }
        fs.amount -= 1000;
        return true;
    }

    public ICapabilityProvider initCapabilities(@NotNull ItemStack stack, NBTTagCompound nbt) {
        CellType type = (CellType)this.getType(stack);
        CellType.CellFluidHandler handler = type.isFluidContainer() ? new CellType.CellFluidHandler(stack, type) : null;
        return handler;
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        RayTraceResult position = this.func_77621_a(world, player, true);
        if (position == null) {
            return ActionResult.newResult((EnumActionResult)EnumActionResult.FAIL, (Object)player.func_184586_b(hand));
        }
        boolean action = ForgeHooks.onRightClickBlock((EntityPlayer)player, (EnumHand)hand, (BlockPos)position.func_178782_a(), (EnumFacing)position.field_178784_b, (Vec3d)position.field_72307_f).isCanceled();
        if (action) {
            return ActionResult.newResult((EnumActionResult)EnumActionResult.FAIL, (Object)player.func_184586_b(hand));
        }
        if (position.field_72313_a == RayTraceResult.Type.BLOCK) {
            BlockPos pos = position.func_178782_a();
            ItemStack stack = player.func_184586_b(hand);
            if (stack.func_77952_i() != 0) {
                BlockPos blockpos1;
                Fluid fluid = IUItem.celltype1.get(stack.func_77952_i());
                boolean flag1 = world.func_180495_p(pos).func_177230_c().func_176200_f((IBlockAccess)world, pos);
                BlockPos blockPos = blockpos1 = flag1 && position.field_178784_b == EnumFacing.UP ? pos : pos.func_177972_a(position.field_178784_b);
                if (this.tryPlaceContainedLiquid(new FluidStack(fluid, 1000), player, world, blockpos1)) {
                    player.func_184586_b(hand).func_190918_g(1);
                    if (!ModUtils.storeInventoryItem(new ItemStack((Item)IUItem.cell_all, 1), player, false) && !world.field_72995_K) {
                        ModUtils.dropAsEntity(world, pos, new ItemStack((Item)IUItem.cell_all, 1));
                    }
                    return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)player.func_184586_b(hand));
                }
            } else {
                if (!world.canMineBlockBody(player, pos)) {
                    return ActionResult.newResult((EnumActionResult)EnumActionResult.FAIL, (Object)player.func_184586_b(hand));
                }
                if (!player.func_175151_a(pos, position.field_178784_b, player.func_184586_b(hand))) {
                    return ActionResult.newResult((EnumActionResult)EnumActionResult.FAIL, (Object)player.func_184586_b(hand));
                }
                IBlockState state = world.func_180495_p(pos);
                Block block = state.func_177230_c();
                if (block instanceof IFluidBlock && ((IFluidBlock)block).canDrain(world, pos)) {
                    Fluid liquid = ((IFluidBlock)block).getFluid();
                    if (IUItem.celltype.containsKey(liquid) && player.func_184586_b(hand).func_77952_i() == 0 && IUItem.celltype.containsKey(liquid)) {
                        world.func_175698_g(pos);
                        player.func_184586_b(hand).func_190918_g(1);
                        if (!player.field_71071_by.func_70441_a(new ItemStack((Item)IUItem.cell_all, 1, IUItem.celltype.get(liquid).intValue())) && !world.field_72995_K) {
                            ModUtils.dropAsEntity(world, pos, new ItemStack((Item)IUItem.cell_all, 1, IUItem.celltype.get(liquid).intValue()));
                        }
                        return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)player.func_184586_b(hand));
                    }
                } else if (state.func_185904_a().func_76224_d()) {
                    FluidStack ret = new FluidStack(FluidRegistry.getFluid((String)block.func_149739_a().substring(5)), 1000);
                    System.out.println(player.func_184586_b(hand).func_77952_i());
                    if (IUItem.celltype.containsKey(ret.getFluid()) && player.func_184586_b(hand).func_77952_i() == 0) {
                        world.func_175698_g(pos);
                        player.func_184586_b(hand).func_190918_g(1);
                        if (!player.field_71071_by.func_70441_a(new ItemStack((Item)IUItem.cell_all, 1, IUItem.celltype.get(ret.getFluid()).intValue())) && !world.field_72995_K) {
                            ModUtils.dropAsEntity(world, pos, new ItemStack((Item)IUItem.cell_all, 1, IUItem.celltype.get(ret.getFluid()).intValue()));
                        }
                        return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)player.func_184586_b(hand));
                    }
                }
            }
        }
        return ActionResult.newResult((EnumActionResult)EnumActionResult.PASS, (Object)player.func_184586_b(hand));
    }

    public String func_77658_a() {
        return "iu." + super.func_77658_a().substring(3);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerModel(Item item, int meta, String extraName) {
        ModelLoader.setCustomModelResourceLocation((Item)this, (int)meta, (ModelResourceLocation)new ModelResourceLocation("industrialupgrade:itemcell/itemcell" + CellType.getFromID(meta).func_176610_l(), null));
    }
}

