/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.items;

import com.denfop.ElectricItem;
import com.denfop.IUCore;
import com.denfop.api.item.IEnergyItem;
import com.denfop.register.Register;
import com.denfop.utils.ModUtils;
import javax.annotation.Nonnull;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class BaseEnergyItem
extends Item
implements IEnergyItem {
    protected final double maxCharge;
    protected final double transferLimit;
    protected final int tier;
    public String name;

    public BaseEnergyItem(String name, double maxCharge, double transferLimit, int tier) {
        this.maxCharge = maxCharge;
        this.transferLimit = transferLimit;
        this.tier = tier;
        this.func_77625_d(1);
        this.setNoRepair();
        this.func_77656_e(0);
        this.func_77637_a(IUCore.EnergyTab);
        this.name = name;
        this.func_77655_b(name);
        Register.registerItem(this, IUCore.getIdentifier(name)).func_77655_b(name);
    }

    @SideOnly(value=Side.CLIENT)
    public static void registerModel(Item item, int meta, String name) {
        ModelLoader.setCustomModelResourceLocation((Item)item, (int)meta, (ModelResourceLocation)BaseEnergyItem.getModelLocation(name));
    }

    @SideOnly(value=Side.CLIENT)
    public static ModelResourceLocation getModelLocation(String name) {
        String loc = "industrialupgrade:energy/" + name;
        return new ModelResourceLocation(loc, null);
    }

    @SideOnly(value=Side.CLIENT)
    public void registerModels(String name) {
        this.registerModel(0, name, null);
    }

    @SideOnly(value=Side.CLIENT)
    protected void registerModel(int meta, String name) {
        BaseEnergyItem.registerModel(this, meta, name);
    }

    @SideOnly(value=Side.CLIENT)
    protected void registerModel(int meta, String name, String extraName) {
        BaseEnergyItem.registerModel(this, meta, name);
    }

    @Override
    public boolean canProvideEnergy(ItemStack stack) {
        return false;
    }

    @Override
    public double getMaxEnergy(ItemStack stack) {
        return this.maxCharge;
    }

    @Override
    public short getTierItem(ItemStack stack) {
        return (short)this.tier;
    }

    @Override
    public double getTransferEnergy(ItemStack stack) {
        return this.transferLimit;
    }

    @Override
    public boolean showDurabilityBar(ItemStack stack) {
        return true;
    }

    @Override
    public int getRGBDurabilityForDisplay(ItemStack stack) {
        return ModUtils.convertRGBcolorToInt(33, 91, 199);
    }

    @Override
    public double getDurabilityForDisplay(ItemStack stack) {
        return Math.min(Math.max(1.0 - ElectricItem.manager.getCharge(stack) / ElectricItem.manager.getMaxCharge(stack), 0.0), 1.0);
    }

    public void func_150895_a(@Nonnull CreativeTabs p_150895_1_, @Nonnull NonNullList<ItemStack> var3) {
        if (this.func_194125_a(p_150895_1_)) {
            ItemStack var4 = new ItemStack((Item)this, 1);
            ElectricItem.manager.charge(var4, 2.147483647E9, Integer.MAX_VALUE, true, false);
            var3.add((Object)var4);
            var3.add((Object)new ItemStack((Item)this, 1));
        }
    }
}

