/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.invslot;

import com.denfop.IUCore;
import com.denfop.IUItem;
import com.denfop.api.gui.EnumTypeSlot;
import com.denfop.api.gui.ITypeSlot;
import com.denfop.invslot.InvSlot;
import com.denfop.items.modules.EnumQuarryModules;
import com.denfop.items.modules.EnumQuarryType;
import com.denfop.items.modules.ItemQuarryModule;
import com.denfop.network.packet.PacketUpdateFieldTile;
import com.denfop.tiles.mechanism.quarry.QuarryItem;
import com.denfop.tiles.mechanism.quarry.TileBaseQuantumQuarry;
import com.denfop.utils.ModUtils;
import java.util.ArrayList;
import net.minecraft.item.ItemStack;

public class InvSlotQuantumQuarry
extends InvSlot
implements ITypeSlot {
    public final int type;
    public final TileBaseQuantumQuarry tile;
    public int stackSizeLimit;

    public InvSlotQuantumQuarry(TileBaseQuantumQuarry base1, int oldStartIndex1, int type) {
        super(base1, InvSlot.TypeItemSlot.INPUT, oldStartIndex1);
        this.tile = base1;
        this.stackSizeLimit = 1;
        this.type = type;
    }

    public void update() {
        switch (this.type) {
            case 0: {
                this.tile.comb_mac_enabled = false;
                this.tile.mac_enabled = false;
                this.tile.col = 1;
                this.tile.chance = 0;
                this.tile.furnace = false;
                this.tile.main_list = new ArrayList<QuarryItem>(IUCore.list_quarry);
                if (!this.isEmpty()) {
                    ItemStack type1 = this.get();
                    EnumQuarryModules module = EnumQuarryModules.getFromID(type1.func_77952_i());
                    EnumQuarryType type = module.type;
                    switch (type) {
                        case SPEED: {
                            this.tile.original = true;
                            break;
                        }
                        case DEPTH: {
                            this.tile.col = module.efficiency * module.efficiency;
                            this.tile.original = true;
                            break;
                        }
                        case LUCKY: {
                            this.tile.chance = module.efficiency;
                            this.tile.original = true;
                            break;
                        }
                        case FURNACE: {
                            this.tile.furnace = true;
                            this.tile.main_list = new ArrayList<QuarryItem>(IUCore.get_ingot_quarry);
                            this.tile.original = false;
                            break;
                        }
                        case COMB_MAC: {
                            this.tile.comb_mac_enabled = true;
                            this.tile.main_list = new ArrayList<QuarryItem>(IUCore.get_comb_crushed_quarry);
                            this.tile.original = false;
                            break;
                        }
                        case MACERATOR: {
                            this.tile.mac_enabled = true;
                            this.tile.main_list = new ArrayList<QuarryItem>(IUCore.get_crushed_quarry);
                            this.tile.original = false;
                        }
                    }
                    this.tile.consume = (double)this.tile.energyconsume * (1.0 + module.cost);
                    this.tile.main_list.removeIf(stack -> this.tile.list(this.tile.list_modules, (QuarryItem)stack));
                    break;
                }
                this.tile.consume = this.tile.energyconsume;
                this.tile.col = 1;
                this.tile.chance = 0;
                this.tile.furnace = false;
                this.tile.comb_mac_enabled = false;
                this.tile.mac_enabled = false;
                this.tile.main_list = new ArrayList<QuarryItem>(IUCore.list_quarry);
                this.tile.main_list.removeIf(stack -> this.tile.list(this.tile.list_modules, (QuarryItem)stack));
                this.tile.original = true;
                break;
            }
            case 1: {
                this.tile.list_modules = this.get().func_190926_b() ? null : EnumQuarryModules.getFromID(this.get().func_77952_i());
                this.tile.list = ModUtils.getQuarryListFromModule(this.get());
                this.tile.main_list = this.tile.furnace ? new ArrayList<QuarryItem>(IUCore.get_ingot_quarry) : (this.tile.comb_mac_enabled ? new ArrayList<QuarryItem>(IUCore.get_comb_crushed_quarry) : (this.tile.mac_enabled ? new ArrayList<QuarryItem>(IUCore.get_crushed_quarry) : new ArrayList<QuarryItem>(IUCore.list_quarry)));
                this.tile.main_list.removeIf(stack -> this.tile.list(this.tile.list_modules, (QuarryItem)stack));
                this.tile.inputslot.update();
                break;
            }
            case 2: {
                this.tile.analyzer = !this.get().func_190926_b();
                new PacketUpdateFieldTile(this.tile, "analyzer", this.tile.analyzer);
            }
        }
    }

    @Override
    public void put(int index, ItemStack content) {
        super.put(index, content);
        switch (this.type) {
            case 0: {
                this.tile.comb_mac_enabled = false;
                this.tile.mac_enabled = false;
                this.tile.col = 1;
                this.tile.chance = 0;
                this.tile.furnace = false;
                this.tile.main_list = new ArrayList<QuarryItem>(IUCore.list_quarry);
                if (!this.isEmpty()) {
                    ItemStack type1 = this.get();
                    EnumQuarryModules module = EnumQuarryModules.getFromID(type1.func_77952_i());
                    EnumQuarryType type = module.type;
                    switch (type) {
                        case SPEED: {
                            this.tile.original = true;
                            break;
                        }
                        case DEPTH: {
                            this.tile.col = module.efficiency * module.efficiency;
                            this.tile.original = true;
                            break;
                        }
                        case LUCKY: {
                            this.tile.chance = module.efficiency;
                            this.tile.original = true;
                            break;
                        }
                        case FURNACE: {
                            this.tile.furnace = true;
                            this.tile.main_list = new ArrayList<QuarryItem>(IUCore.get_ingot_quarry);
                            this.tile.original = false;
                            break;
                        }
                        case COMB_MAC: {
                            this.tile.comb_mac_enabled = true;
                            this.tile.main_list = new ArrayList<QuarryItem>(IUCore.get_comb_crushed_quarry);
                            this.tile.original = false;
                            break;
                        }
                        case MACERATOR: {
                            this.tile.mac_enabled = true;
                            this.tile.main_list = new ArrayList<QuarryItem>(IUCore.get_crushed_quarry);
                            this.tile.original = false;
                        }
                    }
                    this.tile.consume = (double)this.tile.energyconsume * (1.0 + module.cost);
                    this.tile.main_list.removeIf(stack -> this.tile.list(this.tile.list_modules, (QuarryItem)stack));
                    break;
                }
                this.tile.consume = this.tile.energyconsume;
                this.tile.col = 1;
                this.tile.chance = 0;
                this.tile.furnace = false;
                this.tile.comb_mac_enabled = false;
                this.tile.mac_enabled = false;
                this.tile.main_list = new ArrayList<QuarryItem>(IUCore.list_quarry);
                this.tile.main_list.removeIf(stack -> this.tile.list(this.tile.list_modules, (QuarryItem)stack));
                this.tile.original = true;
                break;
            }
            case 1: {
                this.tile.list_modules = this.get().func_190926_b() ? null : EnumQuarryModules.getFromID(this.get().func_77952_i());
                this.tile.list = ModUtils.getQuarryListFromModule(this.get());
                this.tile.main_list.removeIf(stack -> this.tile.list(this.tile.list_modules, (QuarryItem)stack));
                this.tile.inputslot.update();
                break;
            }
            case 2: {
                this.tile.analyzer = !this.get().func_190926_b();
                new PacketUpdateFieldTile(this.tile, "analyzer", this.tile.analyzer);
            }
        }
    }

    @Override
    public boolean accepts(ItemStack itemStack, int index) {
        if (this.type == 0) {
            return itemStack.func_77973_b() instanceof ItemQuarryModule && EnumQuarryModules.getFromID((int)itemStack.func_77952_i()).type != EnumQuarryType.WHITELIST && EnumQuarryModules.getFromID((int)itemStack.func_77952_i()).type != EnumQuarryType.BLACKLIST;
        }
        if (this.type == 1 && itemStack.func_77973_b() instanceof ItemQuarryModule && (EnumQuarryModules.getFromID((int)itemStack.func_77952_i()).type == EnumQuarryType.WHITELIST || EnumQuarryModules.getFromID((int)itemStack.func_77952_i()).type == EnumQuarryType.BLACKLIST)) {
            ((TileBaseQuantumQuarry)this.base).list = ModUtils.getQuarryListFromModule(itemStack);
            return !itemStack.func_77973_b().equals(IUItem.analyzermodule);
        }
        return itemStack.func_77973_b().equals(IUItem.analyzermodule);
    }

    @Override
    public int getStackSizeLimit() {
        return this.stackSizeLimit;
    }

    @Override
    public void setStackSizeLimit(int stackSizeLimit) {
        this.stackSizeLimit = stackSizeLimit;
    }

    @Override
    public EnumTypeSlot getTypeSlot(int slotid) {
        switch (this.type) {
            case 0: {
                return EnumTypeSlot.QUARRY1;
            }
            case 1: {
                return EnumTypeSlot.LIST;
            }
            case 2: {
                return EnumTypeSlot.QUARRY;
            }
        }
        return null;
    }
}

