/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.invslot;

import com.denfop.api.inv.IAdvInventory;
import com.denfop.utils.ModUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public class InvSlot {
    public final IAdvInventory<?> base;
    protected final TypeItemSlot typeItemSlot;
    protected final List<ItemStack> contents;
    protected int stackSizeLimit;

    public InvSlot(IAdvInventory<?> base, TypeItemSlot typeItemSlot, int count) {
        this.contents = new ArrayList<ItemStack>(Collections.nCopies(count, ItemStack.field_190927_a));
        this.base = base;
        this.typeItemSlot = typeItemSlot;
        this.stackSizeLimit = 64;
        base.addInventorySlot(this);
    }

    public InvSlot(int count) {
        this.contents = new ArrayList<ItemStack>(Collections.nCopies(count, ItemStack.field_190927_a));
        this.base = null;
        this.typeItemSlot = null;
    }

    public ItemStack[] gets() {
        return this.contents.toArray(new ItemStack[0]);
    }

    public List<ItemStack> getContents() {
        return this.contents;
    }

    public void readFromNbt(NBTTagCompound nbt) {
        NBTTagList contentsTag = nbt.func_150295_c("Items", 10);
        for (int i = 0; i < contentsTag.func_74745_c(); ++i) {
            ItemStack stack;
            NBTTagCompound contentTag = contentsTag.func_150305_b(i);
            if (i >= this.size() || ModUtils.isEmpty(stack = new ItemStack(contentTag))) continue;
            this.putFromNBT(i, stack);
        }
        this.onChanged();
    }

    public boolean add(List<ItemStack> stacks) {
        return this.add(stacks, false);
    }

    public boolean add(ItemStack stack) {
        if (stack == null) {
            throw new NullPointerException("null ItemStack");
        }
        return this.add(Collections.singletonList(stack), false);
    }

    public boolean canAdd(List<ItemStack> stacks) {
        boolean can = true;
        for (ItemStack stack : stacks) {
            can = can && this.canAdd(stack);
        }
        return can;
    }

    public boolean canAdd(ItemStack stack) {
        if (stack == null) {
            throw new NullPointerException("null ItemStack");
        }
        return this.add(Collections.singletonList(stack), true);
    }

    private boolean add(List<ItemStack> stacks, boolean simulate) {
        if (stacks != null && !stacks.isEmpty()) {
            for (ItemStack stack : stacks) {
                for (int i = 0; i < this.size(); ++i) {
                    if (this.get(i).func_190926_b()) {
                        if (!simulate) {
                            this.put(i, stack.func_77946_l());
                        }
                        return true;
                    }
                    if (!this.get(i).func_77969_a(stack) || this.get(i).func_190916_E() + stack.func_190916_E() > stack.func_77976_d()) continue;
                    if (stack.func_77978_p() == null && this.get(i).func_77978_p() == null) {
                        if (!simulate) {
                            this.get(i).func_190917_f(stack.func_190916_E());
                        }
                        return true;
                    }
                    if (stack.func_77978_p() == null || !stack.func_77978_p().equals((Object)this.get(i).func_77978_p())) continue;
                    if (!simulate) {
                        this.get(i).func_190917_f(stack.func_190916_E());
                    }
                    return true;
                }
            }
            return false;
        }
        return true;
    }

    public NBTTagCompound writeToNbt(NBTTagCompound nbt) {
        NBTTagList contentsTag = new NBTTagList();
        for (ItemStack content : this.contents) {
            NBTTagCompound contentTag = new NBTTagCompound();
            content.func_77955_b(contentTag);
            contentsTag.func_74742_a((NBTBase)contentTag);
        }
        nbt.func_74782_a("Items", (NBTBase)contentsTag);
        return nbt;
    }

    public int size() {
        return this.contents.size();
    }

    public boolean isEmpty() {
        for (ItemStack stack : this.contents) {
            if (ModUtils.isEmpty(stack)) continue;
            return false;
        }
        return true;
    }

    public boolean isEmpty(int index) {
        return ModUtils.isEmpty(this.contents.get(index));
    }

    public ItemStack get() {
        return this.get(0);
    }

    public ItemStack get(int index) {
        return this.contents.get(index);
    }

    public void put(ItemStack content) {
        this.put(0, content);
    }

    protected void putFromNBT(int index, ItemStack content) {
        this.contents.set(index, content);
    }

    public void put(int index, ItemStack content) {
        this.contents.set(index, content);
        this.onChanged();
    }

    public void clear(int index) {
        this.put(index, ItemStack.field_190927_a);
    }

    public void onChanged() {
    }

    public boolean accepts(ItemStack stack, int index) {
        return true;
    }

    public boolean canInput() {
        return this.typeItemSlot == TypeItemSlot.INPUT || this.typeItemSlot == TypeItemSlot.INPUT_OUTPUT;
    }

    public boolean canOutput() {
        return this.typeItemSlot == TypeItemSlot.OUTPUT || this.typeItemSlot == TypeItemSlot.INPUT_OUTPUT;
    }

    public int getStackSizeLimit() {
        return this.stackSizeLimit;
    }

    public void setStackSizeLimit(int stackSizeLimit) {
        this.stackSizeLimit = stackSizeLimit;
    }

    public void set(int i, ItemStack empty) {
        this.contents.set(i, empty);
    }

    public static enum TypeItemSlot {
        INPUT,
        OUTPUT,
        INPUT_OUTPUT;


        public boolean isInput() {
            return this == INPUT || this == INPUT_OUTPUT;
        }

        public boolean isOutput() {
            return this == OUTPUT || this == INPUT_OUTPUT;
        }
    }
}

