/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.integration.jei.worldcollector.aer;

import com.denfop.IUItem;
import com.denfop.Localization;
import com.denfop.blocks.mechanism.BlockBaseMachine3;
import com.denfop.integration.jei.worldcollector.aer.AerWrapper;
import javax.annotation.Nonnull;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.gui.IDrawable;
import mezz.jei.api.gui.IDrawableStatic;
import mezz.jei.api.gui.IGuiItemStackGroup;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.IRecipeCategory;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;

public class AerCategory
extends Gui
implements IRecipeCategory<AerWrapper> {
    private final IDrawableStatic bg;
    private int progress = 0;
    private int energy = 0;

    public AerCategory(IGuiHelper guiHelper) {
        this.bg = guiHelper.createDrawable(new ResourceLocation("industrialupgrade", "textures/gui/guiaerassembler.png"), 5, 5, 140, 75);
    }

    @Nonnull
    public String getUid() {
        return BlockBaseMachine3.aer_assembler.func_176610_l();
    }

    @Nonnull
    public String getTitle() {
        return Localization.translate(new ItemStack((Block)IUItem.basemachine2, 1, 34).func_77977_a());
    }

    @Nonnull
    public String getModName() {
        return "Industrial Upgrade";
    }

    @Nonnull
    public IDrawable getBackground() {
        return this.bg;
    }

    public void drawExtras(@Nonnull Minecraft mc) {
        ++this.progress;
        ++this.energy;
        int energylevel = (int)Math.min(14.0f * (float)this.energy / 100.0f, 14.0f);
        int xScale = 24 * this.progress / 100;
        if (xScale > 24) {
            this.progress = 0;
        }
        mc.func_110434_K().func_110577_a(this.getTexture());
        this.func_73729_b(52, 45 - energylevel, 176, 14 - energylevel, 14, energylevel);
        this.func_73729_b(74, 29, 176, 14, xScale + 1, 16);
    }

    public void setRecipe(IRecipeLayout layout, AerWrapper recipes, @Nonnull IIngredients ingredients) {
        IGuiItemStackGroup isg = layout.getItemStacks();
        isg.init(0, true, 50, 11);
        isg.set(0, recipes.getInput());
        isg.init(2, false, 110, 28);
        isg.set(2, recipes.getOutput());
    }

    protected ResourceLocation getTexture() {
        return new ResourceLocation("industrialupgrade", "textures/gui/guiaerassembler.png");
    }
}

