/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.integration.jei.synthesis;

import com.denfop.IUItem;
import com.denfop.Localization;
import com.denfop.blocks.mechanism.BlockBaseMachine1;
import com.denfop.integration.jei.synthesis.SynthesisWrapper;
import javax.annotation.Nonnull;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.gui.IDrawable;
import mezz.jei.api.gui.IDrawableStatic;
import mezz.jei.api.gui.IGuiItemStackGroup;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.IRecipeCategory;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;

public class SynthesisCategory
extends Gui
implements IRecipeCategory<SynthesisWrapper> {
    private final IDrawableStatic bg;
    private int progress = 0;
    private int energy = 0;

    public SynthesisCategory(IGuiHelper guiHelper) {
        this.bg = guiHelper.createDrawable(new ResourceLocation("industrialupgrade", "textures/gui/guisynthesis.png"), 3, 3, 148, 80);
    }

    @Nonnull
    public String getUid() {
        return BlockBaseMachine1.synthesis.func_176610_l();
    }

    @Nonnull
    public String getTitle() {
        return Localization.translate(new ItemStack((Block)IUItem.basemachine, 1, 11).func_77977_a());
    }

    @Nonnull
    public String getModName() {
        return "Industrial Upgrade";
    }

    @Nonnull
    public IDrawable getBackground() {
        return this.bg;
    }

    public void drawExtras(@Nonnull Minecraft mc) {
        ++this.progress;
        ++this.energy;
        int energylevel = (int)Math.min(14.0f * (float)this.energy / 100.0f, 14.0f);
        int xScale = 15 * this.progress / 100;
        int xScale1 = 20 * this.progress / 100;
        if (xScale > 15) {
            this.progress = 0;
        }
        mc.func_110434_K().func_110577_a(this.getTexture());
        this.func_73729_b(129, 46 - energylevel, 176, 14 - energylevel, 14, energylevel);
        this.func_73729_b(36, 34, 177, 35, xScale + 1, 9);
        this.func_73729_b(79, 27, 177, 52, xScale1 + 1, 23);
    }

    public void setRecipe(IRecipeLayout layout, SynthesisWrapper recipes, @Nonnull IIngredients ingredients) {
        IGuiItemStackGroup isg = layout.getItemStacks();
        isg.init(0, true, 10, 30);
        isg.set(0, recipes.getInput());
        isg.init(1, true, 60, 30);
        isg.set(1, recipes.getInput1());
        isg.init(2, false, 106, 30);
        isg.set(2, recipes.getOutput());
    }

    protected ResourceLocation getTexture() {
        return new ResourceLocation("industrialupgrade", "textures/gui/guisynthesis.png");
    }
}

