/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.integration.jei.rotorrods;

import com.denfop.IUItem;
import com.denfop.Localization;
import com.denfop.blocks.mechanism.BlockBaseMachine3;
import com.denfop.integration.jei.rotorrods.RotorsRodWrapper;
import javax.annotation.Nonnull;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.gui.IDrawable;
import mezz.jei.api.gui.IDrawableStatic;
import mezz.jei.api.gui.IGuiItemStackGroup;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.IRecipeCategory;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;

public class RotorsRodCategory
extends Gui
implements IRecipeCategory<RotorsRodWrapper> {
    private final IDrawableStatic bg;
    private int progress = 0;

    public RotorsRodCategory(IGuiHelper guiHelper) {
        this.bg = guiHelper.createDrawable(new ResourceLocation("industrialupgrade", "textures/gui/guirotorrods.png"), 5, 5, 140, 65);
    }

    @Nonnull
    public String getUid() {
        return BlockBaseMachine3.rods_manufacturer.func_176610_l();
    }

    @Nonnull
    public String getTitle() {
        return Localization.translate(new ItemStack((Block)IUItem.basemachine2, 1, 21).func_77977_a());
    }

    @Nonnull
    public String getModName() {
        return "Industrial Upgrade";
    }

    @Nonnull
    public IDrawable getBackground() {
        return this.bg;
    }

    public void drawExtras(@Nonnull Minecraft mc) {
        ++this.progress;
        double xScale = 24.0f * (float)this.progress / 100.0f;
        if (xScale > 24.0) {
            this.progress = 0;
        }
        mc.func_110434_K().func_110577_a(this.getTexture());
        this.func_73729_b(74, 30, 176, 14, (int)(xScale + 1.0), 16);
    }

    public void setRecipe(IRecipeLayout layout, RotorsRodWrapper recipes, @Nonnull IIngredients ingredients) {
        IGuiItemStackGroup isg = layout.getItemStacks();
        for (int i = 0; i < recipes.getInput().length; ++i) {
            isg.init(i, true, 32 + 18 * (i / 3), 10 + 18 * (i % 3));
            isg.set(i, recipes.getInput()[i]);
        }
        isg.init(recipes.getInput().length, false, 110, 28);
        isg.set(recipes.getInput().length, recipes.getOutput());
    }

    protected ResourceLocation getTexture() {
        return new ResourceLocation("industrialupgrade", "textures/gui/guirotorrods.png");
    }
}

