/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.integration.jei.rolling;

import com.denfop.api.Recipes;
import com.denfop.api.recipe.BaseMachineRecipe;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.ItemStack;

public class RollingHandler {
    private static final List<RollingHandler> recipes = new ArrayList<RollingHandler>();
    private final ItemStack input;
    private final ItemStack output;

    public RollingHandler(ItemStack input, ItemStack output) {
        this.input = input;
        this.output = output;
    }

    public static List<RollingHandler> getRecipes() {
        if (recipes.isEmpty()) {
            RollingHandler.initRecipes();
        }
        return recipes;
    }

    public static RollingHandler addRecipe(ItemStack input, ItemStack output) {
        RollingHandler recipe = new RollingHandler(input, output);
        if (recipes.contains(recipe)) {
            return null;
        }
        recipes.add(recipe);
        return recipe;
    }

    public static RollingHandler getRecipe(ItemStack is) {
        if (is == null || is.func_190926_b()) {
            return null;
        }
        for (RollingHandler recipe : recipes) {
            if (!recipe.matchesInput(is)) continue;
            return recipe;
        }
        return null;
    }

    public static void initRecipes() {
        for (BaseMachineRecipe container : Recipes.recipes.getRecipeList("rolling")) {
            RollingHandler.addRecipe(container.input.getInputs().get(0).getInputs().get(0), container.getOutput().items.get(0));
        }
    }

    public ItemStack getInput() {
        return this.input;
    }

    public ItemStack getOutput() {
        return this.output.func_77946_l();
    }

    public boolean matchesInput(ItemStack is) {
        return is.func_77973_b() == this.input.func_77973_b();
    }
}

