/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.integration.jei.rods_factory;

import com.denfop.api.Recipes;
import com.denfop.api.recipe.BaseMachineRecipe;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.ItemStack;

public class RodFactoryHandler {
    private static final List<RodFactoryHandler> recipes = new ArrayList<RodFactoryHandler>();
    private final ItemStack output;
    private final List<ItemStack> inputs;

    public RodFactoryHandler(List<ItemStack> inputs, ItemStack output) {
        this.inputs = inputs;
        this.output = output;
    }

    public static List<RodFactoryHandler> getRecipes() {
        if (recipes.isEmpty()) {
            RodFactoryHandler.initRecipes();
        }
        return recipes;
    }

    public static RodFactoryHandler addRecipe(List<ItemStack> inputs, ItemStack output) {
        RodFactoryHandler recipe = new RodFactoryHandler(inputs, output);
        if (recipes.contains(recipe)) {
            return null;
        }
        recipes.add(recipe);
        return recipe;
    }

    public static RodFactoryHandler getRecipe(ItemStack is) {
        if (is == null || is.func_190926_b()) {
            return null;
        }
        for (RodFactoryHandler recipe : recipes) {
            if (!recipe.matchesInput(is)) continue;
            return recipe;
        }
        return null;
    }

    public static void initRecipes() {
        ArrayList<Object> stacks;
        for (BaseMachineRecipe container : Recipes.recipes.getRecipeList("reactor_simple_rod")) {
            stacks = new ArrayList<ItemStack>();
            container.input.getInputs().forEach(iInputItemStack -> stacks.add(iInputItemStack.getInputs().get(0)));
            RodFactoryHandler.addRecipe(stacks, container.getOutput().items.get(0));
        }
        for (BaseMachineRecipe container : Recipes.recipes.getRecipeList("reactor_dual_rod")) {
            stacks = new ArrayList();
            container.input.getInputs().forEach(iInputItemStack -> stacks.add(iInputItemStack.getInputs().get(0)));
            RodFactoryHandler.addRecipe(stacks, container.getOutput().items.get(0));
        }
        for (BaseMachineRecipe container : Recipes.recipes.getRecipeList("reactor_quad_rod")) {
            stacks = new ArrayList();
            container.input.getInputs().forEach(iInputItemStack -> stacks.add(iInputItemStack.getInputs().get(0)));
            RodFactoryHandler.addRecipe(stacks, container.getOutput().items.get(0));
        }
    }

    public List<ItemStack> getInputs() {
        return this.inputs;
    }

    public ItemStack getOutput() {
        return this.output.func_77946_l();
    }

    public boolean matchesInput(ItemStack is) {
        for (ItemStack input : this.getInputs()) {
            if (!input.func_77969_a(is)) continue;
            return true;
        }
        return false;
    }
}

