/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.integration.jei.recycler;

import com.denfop.IUItem;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.registry.ForgeRegistries;

public class RecyclerHandler {
    private static final List<RecyclerHandler> recipes = new ArrayList<RecyclerHandler>();
    private final ItemStack input;
    private final ItemStack output;

    public RecyclerHandler(ItemStack input, ItemStack output) {
        this.input = input;
        this.output = output;
    }

    public static List<RecyclerHandler> getRecipes() {
        if (recipes.isEmpty()) {
            RecyclerHandler.initRecipes();
        }
        return recipes;
    }

    public static RecyclerHandler addRecipe(ItemStack input, ItemStack output) {
        RecyclerHandler recipe = new RecyclerHandler(input, output);
        if (recipes.contains(recipe)) {
            return null;
        }
        recipes.add(recipe);
        return recipe;
    }

    public static RecyclerHandler getRecipe(ItemStack is) {
        if (is == null || is.func_190926_b()) {
            return null;
        }
        for (RecyclerHandler recipe : recipes) {
            if (!recipe.matchesInput(is)) continue;
            return recipe;
        }
        return null;
    }

    public static void initRecipes() {
        for (Item container : ForgeRegistries.ITEMS) {
            RecyclerHandler.addRecipe(new ItemStack(container), IUItem.scrap);
        }
        for (Item container : ForgeRegistries.BLOCKS) {
            RecyclerHandler.addRecipe(new ItemStack((Block)container), IUItem.scrap);
        }
    }

    public ItemStack getInput() {
        return this.input;
    }

    public ItemStack getOutput() {
        return this.output.func_77946_l();
    }

    public boolean matchesInput(ItemStack is) {
        return is.func_77973_b() == this.input.func_77973_b();
    }
}

