/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.integration.jei.quarry;

import com.denfop.IUItem;
import com.denfop.Localization;
import com.denfop.blocks.mechanism.BlockBaseMachine;
import com.denfop.integration.jei.quarry.QuarryWrapper;
import javax.annotation.Nonnull;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.gui.IDrawable;
import mezz.jei.api.gui.IDrawableStatic;
import mezz.jei.api.gui.IGuiItemStackGroup;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.IRecipeCategory;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;

public class QuarryCategory
extends Gui
implements IRecipeCategory<QuarryWrapper> {
    private final IDrawableStatic bg;
    private int energy = 0;

    public QuarryCategory(IGuiHelper guiHelper) {
        this.bg = guiHelper.createDrawable(new ResourceLocation("industrialupgrade", "textures/gui/guiquantumquerry.png"), 3, 3, 160, 80);
    }

    @Nonnull
    public String getUid() {
        return BlockBaseMachine.quantum_quarry.func_176610_l();
    }

    @Nonnull
    public String getTitle() {
        return Localization.translate(new ItemStack((Block)IUItem.machines, 1, 8).func_77977_a());
    }

    @Nonnull
    public String getModName() {
        return "Industrial Upgrade";
    }

    @Nonnull
    public IDrawable getBackground() {
        return this.bg;
    }

    public void drawExtras(Minecraft mc) {
        ++this.energy;
        int energylevel = (int)Math.min(48.0f * (float)this.energy / 100.0f, 48.0f);
        mc.func_110434_K().func_110577_a(this.getTexture());
        this.func_73729_b(143, 73 - energylevel, 176, 48 - energylevel, 48, energylevel);
    }

    public void setRecipe(IRecipeLayout layout, QuarryWrapper recipes, @Nonnull IIngredients ingredients) {
        IGuiItemStackGroup isg = layout.getItemStacks();
        isg.init(0, true, 4, 11);
        isg.set(0, new ItemStack(IUItem.analyzermodule));
        isg.init(1, false, 26, 2);
        isg.set(1, recipes.getOutput());
    }

    protected ResourceLocation getTexture() {
        return new ResourceLocation("industrialupgrade", "textures/gui/guiquantumquerry.png");
    }
}

