/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.integration.jei.plasticcratorplate;

import com.denfop.api.Recipes;
import com.denfop.api.recipe.BaseMachineRecipe;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;

public class PlasticCreatorPlateHandler {
    private static final List<PlasticCreatorPlateHandler> recipes = new ArrayList<PlasticCreatorPlateHandler>();
    private final FluidStack input2;
    private final ItemStack input;
    private final ItemStack output;

    public PlasticCreatorPlateHandler(ItemStack input, FluidStack input2, ItemStack output) {
        this.input = input;
        this.input2 = input2;
        this.output = output;
    }

    public static List<PlasticCreatorPlateHandler> getRecipes() {
        if (recipes.isEmpty()) {
            PlasticCreatorPlateHandler.initRecipes();
        }
        return recipes;
    }

    public static PlasticCreatorPlateHandler addRecipe(ItemStack input, FluidStack input2, ItemStack output) {
        PlasticCreatorPlateHandler recipe = new PlasticCreatorPlateHandler(input, input2, output);
        if (recipes.contains(recipe)) {
            return null;
        }
        recipes.add(recipe);
        return recipe;
    }

    public static PlasticCreatorPlateHandler getRecipe(ItemStack is) {
        if (is == null || is.func_190926_b()) {
            return null;
        }
        for (PlasticCreatorPlateHandler recipe : recipes) {
            if (!recipe.matchesInput(is)) continue;
            return recipe;
        }
        return null;
    }

    public static void initRecipes() {
        for (BaseMachineRecipe container : Recipes.recipes.getRecipeList("plasticplate")) {
            PlasticCreatorPlateHandler.addRecipe(container.input.getInputs().get(0).getInputs().get(0), container.input.getFluid(), container.getOutput().items.get(0));
        }
    }

    public ItemStack getInput() {
        return this.input;
    }

    public FluidStack getInput2() {
        return this.input2;
    }

    public ItemStack getOutput() {
        return this.output.func_77946_l();
    }

    public boolean matchesInput(ItemStack is) {
        return is.func_77969_a(this.input);
    }
}

