/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.integration.jei.orewashing;

import com.denfop.api.Recipes;
import com.denfop.api.recipe.BaseMachineRecipe;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.ItemStack;

public class OreWashingHandler {
    private static final List<OreWashingHandler> recipes = new ArrayList<OreWashingHandler>();
    private final ItemStack input;
    private final List<ItemStack> output;
    private final short temperature;

    public OreWashingHandler(ItemStack input, List<ItemStack> output, short temperature) {
        this.input = input;
        this.output = output;
        this.temperature = temperature;
    }

    public static List<OreWashingHandler> getRecipes() {
        if (recipes.isEmpty()) {
            OreWashingHandler.initRecipes();
        }
        return recipes;
    }

    public static OreWashingHandler addRecipe(ItemStack input, List<ItemStack> output, short temperature) {
        OreWashingHandler recipe = new OreWashingHandler(input, output, temperature);
        if (recipes.contains(recipe)) {
            return null;
        }
        recipes.add(recipe);
        return recipe;
    }

    public static OreWashingHandler getRecipe(ItemStack is) {
        if (is == null || is.func_190926_b()) {
            return null;
        }
        for (OreWashingHandler recipe : recipes) {
            if (!recipe.matchesInput(is)) continue;
            return recipe;
        }
        return null;
    }

    public static void initRecipes() {
        for (BaseMachineRecipe container : Recipes.recipes.getRecipeList("orewashing")) {
            OreWashingHandler.addRecipe(container.input.getInputs().get(0).getInputs().get(0), container.getOutput().items, (short)1000);
        }
    }

    public ItemStack getInput() {
        return this.input;
    }

    public List<ItemStack> getOutput() {
        return this.output;
    }

    public boolean matchesInput(ItemStack is) {
        return is.func_77973_b() == this.input.func_77973_b();
    }

    public short getTemperature() {
        return this.temperature;
    }
}

