/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.integration.jei.multiblock;

import com.denfop.Localization;
import com.denfop.api.multiblock.MultiBlockStructure;
import com.denfop.integration.jei.multiblock.MultiBlockWrapper;
import javax.annotation.Nonnull;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.gui.IDrawable;
import mezz.jei.api.gui.IDrawableStatic;
import mezz.jei.api.gui.IGuiItemStackGroup;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.util.ResourceLocation;

public class MultiBlockCategory
extends Gui
implements IRecipeCategory<MultiBlockWrapper> {
    private final IDrawableStatic bg;

    public MultiBlockCategory(IGuiHelper guiHelper) {
        this.bg = guiHelper.createDrawable(new ResourceLocation("industrialupgrade", "textures/gui/guivein.png"), 3, 3, 140, 140);
    }

    @Nonnull
    public String getUid() {
        return "multiblock_iu";
    }

    @Nonnull
    public String getTitle() {
        return Localization.translate("multiblock.jei");
    }

    @Nonnull
    public String getModName() {
        return "Industrial Upgrade";
    }

    @Nonnull
    public IDrawable getBackground() {
        return this.bg;
    }

    public void drawExtras(@Nonnull Minecraft mc) {
    }

    public void setRecipe(IRecipeLayout layout, MultiBlockWrapper recipes, @Nonnull IIngredients ingredients) {
        IGuiItemStackGroup isg = layout.getItemStacks();
        MultiBlockStructure structure = recipes.structure;
        for (int i = 0; i < structure.itemStackList.size(); ++i) {
            int x = 5 + i % 6 * 20;
            int y = 30 + i / 6 * 20;
            isg.init(i, true, x, y);
            isg.set(i, structure.itemStackList.get(i));
        }
        double y = structure.itemStackList.size();
        y /= 6.0;
        isg.init(structure.itemStackList.size(), true, 50 + Localization.translate("multiblock.jei2").length() * 3, (int)(10.0 + (y += 1.0) * 23.0));
        isg.set(structure.itemStackList.size(), structure.itemStackList.get(0));
    }

    protected ResourceLocation getTexture() {
        return new ResourceLocation("industrialupgrade", "textures/gui/guivein.png");
    }
}

