/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.integration.jei.molecular;

import com.denfop.IUCore;
import com.denfop.Localization;
import com.denfop.integration.jei.molecular.MolecularTransformerHandler;
import com.denfop.utils.ModUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.ingredients.VanillaTypes;
import mezz.jei.api.recipe.IRecipeWrapper;
import net.minecraft.client.Minecraft;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;

public class MolecularTransformerRecipeWrapper
implements IRecipeWrapper {
    protected final String input;
    protected final String output;
    protected final String totalEU;
    private final ItemStack inputstack;
    private final ItemStack outputstack;

    public MolecularTransformerRecipeWrapper(MolecularTransformerHandler container) {
        String inputText;
        if (!container.getInput().func_190926_b()) {
            inputText = container.getInput().func_82833_r();
        } else {
            IUCore.log.warn("Unexpected empty recipe input: " + container.getInput() + " (" + container.getInput().getClass() + ')');
            inputText = "Empty " + container.getInput().getClass().getSimpleName();
        }
        this.inputstack = container.getInput();
        this.outputstack = container.getOutput();
        this.input = Localization.translate("gui.MolecularTransformer.input") + ' ' + inputText;
        this.output = Localization.translate("gui.MolecularTransformer.output") + ' ' + container.getOutput().func_82833_r();
        this.totalEU = String.format("%s %s %s", Localization.translate("gui.MolecularTransformer.energyPerOperation"), ModUtils.getString(container.getEnergy()), Localization.translate("iu.generic.text.EF"));
    }

    public ItemStack getInput() {
        return this.inputstack;
    }

    public List<List<ItemStack>> getInputs() {
        ItemStack inputs = this.inputstack;
        ArrayList<ItemStack> stack = new ArrayList<ItemStack>();
        if (OreDictionary.getOreIDs((ItemStack)inputs).length > 0) {
            int id = OreDictionary.getOreIDs((ItemStack)inputs)[0];
            stack.addAll((Collection<ItemStack>)OreDictionary.getOres((String)OreDictionary.getOreName((int)id)));
        } else {
            stack.add(inputs);
        }
        return inputs.func_190926_b() ? Collections.emptyList() : Collections.singletonList(stack);
    }

    public List<ItemStack> getOutputs() {
        return new ArrayList<ItemStack>(Collections.singleton(this.outputstack));
    }

    public void getIngredients(IIngredients ingredients) {
        ingredients.setInputLists(VanillaTypes.ITEM, this.getInputs());
        ingredients.setOutputs(VanillaTypes.ITEM, this.getOutputs());
    }

    public ItemStack getOutput() {
        return this.outputstack;
    }

    public void drawInfo(Minecraft minecraft, int recipeWidth, int recipeHeight, int mouseX, int mouseY) {
        int y = 5;
        int x = 49;
        minecraft.field_71466_p.func_78279_b(this.input, x, y, recipeWidth - x, 0xFFFFFF);
        minecraft.field_71466_p.func_78279_b(this.output, x, y += minecraft.field_71466_p.func_78267_b(this.input, recipeWidth - x) + 5, recipeWidth - x, 0xFFFFFF);
        minecraft.field_71466_p.func_78276_b(this.totalEU, x, y += minecraft.field_71466_p.func_78267_b(this.output, recipeWidth - x) + 5, 0xFFFFFF);
    }
}

