/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.integration.jei.molecular;

import com.denfop.api.Recipes;
import com.denfop.api.recipe.BaseMachineRecipe;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.ItemStack;

public class MolecularTransformerHandler {
    private static final List<MolecularTransformerHandler> recipes = new ArrayList<MolecularTransformerHandler>();
    private final double energy;
    private final ItemStack input;
    private final ItemStack output;

    public MolecularTransformerHandler(ItemStack input, ItemStack output, double energy) {
        this.input = input;
        this.output = output;
        this.energy = energy;
    }

    public static List<MolecularTransformerHandler> getRecipes() {
        if (recipes.isEmpty()) {
            MolecularTransformerHandler.initRecipes();
        }
        return recipes;
    }

    public static MolecularTransformerHandler addRecipe(ItemStack input, ItemStack output, double energy) {
        MolecularTransformerHandler recipe = new MolecularTransformerHandler(input, output, energy);
        if (recipes.contains(recipe)) {
            return null;
        }
        recipes.add(recipe);
        return recipe;
    }

    public static MolecularTransformerHandler getRecipe(ItemStack is) {
        if (is == null || is.func_190926_b()) {
            return null;
        }
        for (MolecularTransformerHandler recipe : recipes) {
            if (!recipe.matchesInput(is)) continue;
            return recipe;
        }
        return null;
    }

    public static void initRecipes() {
        for (BaseMachineRecipe container : Recipes.recipes.getRecipeList("molecular")) {
            MolecularTransformerHandler.addRecipe(container.input.getInputs().get(0).getInputs().get(0), container.getOutput().items.get(0), container.getOutput().metadata.func_74769_h("energy"));
        }
    }

    public ItemStack getInput() {
        return this.input;
    }

    public ItemStack getOutput() {
        return this.output.func_77946_l();
    }

    public double getEnergy() {
        return this.energy;
    }

    public boolean matchesInput(ItemStack is) {
        return is.func_77973_b() == this.input.func_77973_b();
    }
}

