/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.integration.jei.handlerho;

import com.denfop.integration.jei.handlerho.HandlerHOHandler;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.ingredients.VanillaTypes;
import mezz.jei.api.recipe.IRecipeWrapper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.oredict.OreDictionary;

public class HandlerHORecipeWrapper
implements IRecipeWrapper {
    protected final ItemStack inputstack;
    protected final List<ItemStack> outputstack;
    protected final NBTTagCompound nbt;

    public HandlerHORecipeWrapper(HandlerHOHandler container) {
        this.inputstack = container.getInput();
        this.outputstack = container.getOutput();
        this.nbt = container.getNBT();
    }

    public ItemStack getInput() {
        return this.inputstack;
    }

    public NBTTagCompound getMeta() {
        return this.nbt;
    }

    public List<List<ItemStack>> getInputs() {
        ItemStack inputs = this.inputstack;
        ArrayList<ItemStack> stack = new ArrayList<ItemStack>();
        if (OreDictionary.getOreIDs((ItemStack)inputs).length > 0) {
            int id = OreDictionary.getOreIDs((ItemStack)inputs)[0];
            stack.addAll((Collection<ItemStack>)OreDictionary.getOres((String)OreDictionary.getOreName((int)id)));
        } else {
            stack.add(inputs);
        }
        return inputs.func_190926_b() ? Collections.emptyList() : Collections.singletonList(stack);
    }

    public List<ItemStack> getOutputs() {
        return this.outputstack;
    }

    public void getIngredients(IIngredients ingredients) {
        ingredients.setInputLists(VanillaTypes.ITEM, this.getInputs());
        ingredients.setOutputs(VanillaTypes.ITEM, this.getOutputs());
    }

    public List<ItemStack> getOutput() {
        return this.outputstack;
    }

    public void drawInfo(@Nonnull Minecraft minecraft, int recipeWidth, int recipeHeight, int mouseX, int mouseY) {
        int size = this.getOutputs().size();
        int y = 11;
        int x = 122;
        int temperature = 38 * this.nbt.func_74765_d("temperature") / 5000;
        short temp = this.nbt.func_74765_d("temperature");
        if (temperature > 0) {
            this.drawTexturedModalRect(48, 49, 176, 50, temperature + 1, 11);
        }
        for (int i = 0; i < size; ++i) {
            minecraft.field_71466_p.func_78279_b("" + this.nbt.func_74762_e("input" + i) + "%", x, y, recipeWidth - x, 0x404040);
            y += 18;
        }
        minecraft.field_71466_p.func_78276_b("" + temp + "\u00b0C", 56, 67, 0x404040);
    }

    public void drawTexturedModalRect(int x, int y, int textureX, int textureY, int width, int height) {
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        bufferbuilder.func_181662_b((double)x, (double)(y + height), 0.0).func_187315_a((double)((float)textureX * 0.00390625f), (double)((float)(textureY + height) * 0.00390625f)).func_181675_d();
        bufferbuilder.func_181662_b((double)(x + width), (double)(y + height), 0.0).func_187315_a((double)((float)(textureX + width) * 0.00390625f), (double)((float)(textureY + height) * 0.00390625f)).func_181675_d();
        bufferbuilder.func_181662_b((double)(x + width), (double)y, 0.0).func_187315_a((double)((float)(textureX + width) * 0.00390625f), (double)((float)textureY * 0.00390625f)).func_181675_d();
        bufferbuilder.func_181662_b((double)x, (double)y, 0.0).func_187315_a((double)((float)textureX * 0.00390625f), (double)((float)textureY * 0.00390625f)).func_181675_d();
        tessellator.func_78381_a();
    }
}

